/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.j2ee.nodes;

import java.lang.reflect.Method;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.modules.j2ee.actions.CustomizerAction;
import org.netbeans.jellytools.modules.j2ee.actions.RefreshAction;
import org.netbeans.jellytools.modules.j2ee.actions.RemoveInstanceAction;
import org.netbeans.jellytools.modules.j2ee.actions.RestartAction;
import org.netbeans.jellytools.modules.j2ee.actions.StartAction;
import org.netbeans.jellytools.modules.j2ee.actions.StartDebugAction;
import org.netbeans.jellytools.modules.j2ee.actions.StopAction;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2eeServerNode
extends org.netbeans.jellytools.nodes.Node {
    static final CustomizerAction customizerAction = new CustomizerAction();
    static final StartDebugAction startDebugAction = new StartDebugAction();
    static final RefreshAction refreshAction = new RefreshAction();
    static final RemoveInstanceAction removeInstanceAction = new RemoveInstanceAction();
    static final RestartAction restartAction = new RestartAction();
    static final StartAction startAction = new StartAction();
    static final StopAction stopAction = new StopAction();
    private static final String SERVERS = Bundle.getString((String)"org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", (String)"SERVER_REGISTRY_NODE");
    public static final int STATE_WAITING = 1;
    public static final int STATE_STOPPED = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_DEBUGGING = 4;
    public static final int STATE_SUSPENDED = 5;
    public static final int STATE_PROFILING = 6;
    public static final int STATE_PROFILER_BLOCKING = 7;
    public static final int STATE_PROFILER_STARTING = 8;

    public J2eeServerNode(String string) {
        super(new RuntimeTabOperator().getRootNode(), SERVERS + "|" + string);
    }

    public static J2eeServerNode invoke(String string) {
        RuntimeTabOperator.invoke();
        return new J2eeServerNode(string);
    }

    public void verifyPopup() {
        this.verifyPopup(new Action[]{customizerAction, startDebugAction, refreshAction, removeInstanceAction, restartAction, startAction, stopAction});
    }

    public void properties() {
        this.waitNotWaiting();
        customizerAction.perform(this);
    }

    public void debug() {
        this.waitNotWaiting();
        startDebugAction.perform(this);
        this.waitDebugging();
    }

    public void refresh() {
        this.waitNotWaiting();
        refreshAction.perform(this);
        this.waitNotWaiting();
    }

    public void remove() {
        this.waitNotWaiting();
        removeInstanceAction.perform(this);
    }

    public void restart() {
        this.waitNotWaiting();
        restartAction.perform(this);
    }

    public void start() {
        this.waitNotWaiting();
        startAction.perform(this);
        this.waitRunning();
    }

    public void stop() {
        this.waitNotWaiting();
        stopAction.perform(this);
        this.waitStopped();
    }

    public void waitFinished() {
        this.waitNotWaiting();
    }

    static Class<? extends Node.Cookie> classServerInstance() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName("org.netbeans.modules.j2ee.deployment.impl.ServerInstance", false, classLoader);
            return clazz.asSubclass(Node.Cookie.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
            return Node.Cookie.class;
        }
    }

    private void waitDebugging() {
        this.waitServerState(4);
    }

    private void waitRunning() {
        this.waitServerState(3);
    }

    private void waitStopped() {
        this.waitServerState(2);
    }

    private static int getServerState(Node node) {
        try {
            Node.Cookie cookie = node.getCookie(J2eeServerNode.classServerInstance());
            Method method = J2eeServerNode.classServerInstance().getMethod("getServerState", new Class[0]);
            return (Integer)method.invoke((Object)cookie, new Object[0]);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return 2;
        }
    }

    private void waitServerState(int n) {
        final Node node = (Node)this.getOpenideNode();
        final int n2 = n;
        J2eeServerNode.waitFor(new Waitable(){

            public Object actionProduced(Object object) {
                if (J2eeServerNode.getServerState(node) == n2) {
                    return "Server state: " + this.getStateName() + " reached.";
                }
                return null;
            }

            public String getDescription() {
                return "Wait for server state: " + this.getStateName();
            }

            private String getStateName() {
                switch (n2) {
                    case 4: {
                        return "DEBUGGING";
                    }
                    case 3: {
                        return "RUNNING";
                    }
                    case 2: {
                        return "STOPPED";
                    }
                    case 5: {
                        return "SUSPENDED";
                    }
                    case 1: {
                        return "WAITING";
                    }
                }
                return "UNKNOWN STATE";
            }
        });
    }

    private void waitNotWaiting() {
        final Node node = (Node)this.getOpenideNode();
        J2eeServerNode.waitFor(new Waitable(){

            public Object actionProduced(Object object) {
                if (J2eeServerNode.getServerState(node) != 1) {
                    return "Server leaves WAITING state.";
                }
                return null;
            }

            public String getDescription() {
                return "Wait till server leaves state WAITING.";
            }
        });
    }

    private static Object waitFor(Waitable waitable) {
        Waiter waiter = new Waiter(waitable);
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", 120000L);
        try {
            return waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException(waitable.getDescription() + " has been " + "interrupted.", (Throwable)interruptedException);
        }
    }
}

