/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.FacesMessageUtils;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class LabelRenderer
extends Renderer {
    private static final String[] EVENT_NAMES = new String[]{"onClick", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut"};

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String value;
        boolean requiredFlag;
        String toolTip;
        UIComponent labeledComponent;
        if (!(component instanceof Label)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Label.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Label.renderer", params);
            throw new FacesException(message);
        }
        Label label = (Label)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)label.getClientId(context), "id");
        String forId = label.getFor();
        UIComponent fallbackIndicatorComponent = labeledComponent = label.getLabeledComponent(context);
        if (labeledComponent != null) {
            if (labeledComponent instanceof ComplexComponent) {
                forId = ((ComplexComponent)labeledComponent).getLabeledElementId(context);
                fallbackIndicatorComponent = ((ComplexComponent)labeledComponent).getIndicatorComponent(context, label);
            } else {
                forId = labeledComponent.getClientId(context);
            }
        }
        if (forId != null && forId.length() != 0) {
            writer.writeAttribute("for", (Object)forId, "for");
        }
        if (label.getStyle() != null) {
            writer.writeAttribute("style", (Object)label.getStyle(), "style");
        }
        if ((toolTip = label.getToolTip()) != null) {
            writer.writeAttribute("title", (Object)toolTip, "toolTip");
        }
        this.writeEvents(label, writer);
        boolean errorFlag = false;
        String errorMsg = null;
        boolean isHideIndicators = label.isHideIndicators();
        boolean bl = requiredFlag = label.isRequiredIndicator() && !isHideIndicators;
        if (!isHideIndicators) {
            UIComponent indicatorComponent = label.getIndicatorComponent(context, false);
            if (indicatorComponent == null) {
                indicatorComponent = fallbackIndicatorComponent;
            }
            if (indicatorComponent != null) {
                if (this.isProperty(indicatorComponent, "readOnly", false)) {
                    requiredFlag = false;
                } else {
                    requiredFlag = this.isProperty(indicatorComponent, "required", false);
                    boolean bl2 = errorFlag = !this.isProperty(indicatorComponent, "valid", true);
                    if (errorFlag) {
                        errorMsg = FacesMessageUtils.getDetailMessages(context, indicatorComponent.getClientId(context), true, " ");
                    }
                }
            }
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)label, this.getThemeStyleClass(label, theme, errorFlag));
        if (errorFlag) {
            UIComponent ei = label.getErrorIcon(theme, context, errorMsg);
            RenderingUtilities.renderComponent(ei, context);
        }
        if ((value = this.formatLabelText(context, label)) != null) {
            writer.writeText((Object)value, "text");
        }
        if (requiredFlag) {
            RenderingUtilities.renderComponent(label.getRequiredIcon(theme, context), context);
        }
        writer.endElement("label");
        Iterator children = label.getChildren().iterator();
        while (children.hasNext()) {
            RenderingUtilities.renderComponent((UIComponent)children.next(), context);
        }
    }

    private String formatLabelText(FacesContext context, Label label) {
        String text = ConversionUtilities.convertValueToString((UIComponent)label, label.getValue());
        text = text.concat(" ");
        if (label.getChildCount() == 0) {
            return text;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (UIComponent kid : label.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            list.add(((UIParameter)kid).getValue());
        }
        if (list.size() == 0) {
            return text;
        }
        return MessageFormat.format(text, list.toArray(new Object[list.size()]));
    }

    private String getThemeStyleClass(Label label, Theme theme, boolean errorFlag) {
        String style = null;
        int level = label.getLabelLevel();
        if (errorFlag) {
            style = theme.getStyleClass("CONTENT_ERROR_LABEL_TEXT");
        } else if (level == 1) {
            style = theme.getStyleClass("LABEL_LEVEL_ONE_TEXT");
        } else if (level == 2) {
            style = theme.getStyleClass("LABEL_LEVEL_TWO_TEXT");
        } else if (level == 3) {
            style = theme.getStyleClass("LABEL_LEVEL_THREE_TEXT");
        }
        return style;
    }

    private void writeEvents(Label label, ResponseWriter writer) throws IOException {
        Map attributes = label.getAttributes();
        int length = EVENT_NAMES.length;
        for (int i = 0; i < length; ++i) {
            Object value = attributes.get(EVENT_NAMES[i]);
            if (value == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(EVENT_NAMES[i].toLowerCase(), (Object)((String)value), EVENT_NAMES[i]);
                continue;
            }
            writer.writeAttribute(EVENT_NAMES[i].toLowerCase(), (Object)value.toString(), EVENT_NAMES[i]);
        }
    }

    private boolean isProperty(UIComponent component, String property, boolean doesNotExist) {
        Object o = component.getAttributes().get(property);
        if (o == null) {
            return doesNotExist;
        }
        return o != null && o instanceof Boolean ? (Boolean)o : false;
    }
}

