/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RendererBase
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean isWidgetChild = this.isWidgetChild(context, component);
        if (isWidgetChild || this.getWidgetType(context, component) == null) {
            return;
        }
        String id = "_" + component.getClientId(context);
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)id, null);
        JavaScriptUtilities.renderJavaScriptBegin(component, writer, false);
        writer.write(JavaScriptUtilities.getModuleName("widget.common._createWidget('"));
        writer.write(id);
        writer.write("',");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        try {
            JSONObject json = this.getProperties(context, component);
            this.setCoreProperties(context, component, json);
            ResponseWriter writer = context.getResponseWriter();
            writer.write(JSONUtilities.getString(json));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean isWidgetChild = this.isWidgetChild(context, component);
        if (isWidgetChild || this.getWidgetType(context, component) == null) {
            return;
        }
        writer.write(");");
        JavaScriptUtilities.renderJavaScriptEnd(component, writer, false);
        writer.endElement("span");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected abstract JSONObject getProperties(FacesContext var1, UIComponent var2) throws IOException, JSONException;

    protected String getTemplatePath(FacesContext context, UIComponent component) throws IOException {
        return (String)component.getAttributes().get("htmlTemplate");
    }

    protected abstract String getWidgetType(FacesContext var1, UIComponent var2) throws IOException;

    protected void setCoreProperties(FacesContext context, UIComponent component, JSONObject json) throws IOException, JSONException {
        json.put("id", (Object)component.getClientId(context)).put("widgetType", (Object)this.getWidgetType(context, component)).put("templatePath", (Object)this.getTemplatePath(context, component));
    }

    protected Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private boolean isWidgetChild(FacesContext context, UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent == null) {
            return false;
        }
        String family = parent.getFamily();
        String type = parent.getRendererType();
        if (family == null || type == null) {
            return false;
        }
        Renderer renderer = context.getRenderKit().getRenderer(family, type);
        return renderer instanceof RendererBase;
    }
}

