/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class BooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer,
TableCellEditor,
ActionListener,
ItemListener {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;
    private ImageIcon iconVisible;
    private ImageIcon iconInvisible;
    private ImageIcon iconLocked;
    private ImageIcon iconUnlocked;
    protected EventListenerList listenerList = new EventListenerList();

    public BooleanTableCellRenderer(int n, int n2) {
        try {
            this.initIcons();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        this.addActionListener(this);
        this.addItemListener(this);
        this.setBackground(Color.WHITE);
        Dimension dimension = new Dimension(this.iconVisible.getIconWidth() + n, this.iconVisible.getIconHeight() + n2);
        this.setPreferredSize(dimension);
        this.setHorizontalAlignment(0);
    }

    private void initIcons() throws MalformedURLException {
        this.iconVisible = new ImageIcon(this.getClass().getResource("res/visible.png"));
        this.iconInvisible = new ImageIcon(this.getClass().getResource("res/invisible.png"));
        this.iconLocked = new ImageIcon(this.getClass().getResource("res/lock.png"));
        this.iconUnlocked = new ImageIcon(this.getClass().getResource("res/unlock.png"));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof Boolean) {
            this.setImages(n2);
            this.setSelected((Boolean)object);
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (!bl && jTable.isCellEditable(n, n2)) {
                    Color color = UIManager.getColor("Table.focusCellForeground");
                    if (color != null) {
                        super.setForeground(color);
                    }
                    if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(color);
                    }
                }
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
        throw new IllegalArgumentException("Only Boolean can be rendered.");
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object instanceof Boolean) {
            this.setImages(n2);
            this.setSelected((Boolean)object);
            return this;
        }
        throw new IllegalArgumentException("Only Boolean can be edited.");
    }

    private void setImages(int n) {
        if (n == 3) {
            this.setSelectedIcon(this.iconLocked);
            this.setIcon(this.iconUnlocked);
        } else {
            this.setSelectedIcon(this.iconVisible);
            this.setIcon(this.iconInvisible);
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingCanceled(this.changeEvent);
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEditingStopped();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fireEditingStopped();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }
}

