/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.hibernate.editor.ContextUtilities;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentContext {
    private Document document;
    private XMLSyntaxSupport syntaxSupport;
    private int caretOffset = -1;
    private SyntaxElement element;
    private TokenItem token;
    private boolean valid = false;
    private StartTag docRoot;
    private String defaultNamespace;
    private HashMap<String, String> declaredNamespaces = new HashMap();
    private String schemaLocation;
    private String noNamespaceSchemaLocation;

    DocumentContext(Document document) {
        this.document = document;
        this.syntaxSupport = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
    }

    public void reset(int n) {
        this.caretOffset = n;
        this.initialize();
    }

    private void initialize() {
        this.valid = true;
        this.declaredNamespaces.clear();
        try {
            this.element = this.syntaxSupport.getElementChain(this.caretOffset);
            this.token = this.syntaxSupport.getTokenChain(this.caretOffset, Math.min(this.document.getLength(), this.caretOffset + 1));
            this.docRoot = ContextUtilities.getRoot(this.element);
            this.populateNamespaces();
        }
        catch (BadLocationException badLocationException) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getCurrentTokenId() {
        if (this.isValid()) {
            return this.token.getTokenID().getNumericID();
        }
        return -1;
    }

    public TokenItem getCurrentToken() {
        if (this.isValid()) {
            return this.token;
        }
        return null;
    }

    public String getCurrentTokenImage() {
        if (this.isValid()) {
            return this.token.getImage();
        }
        return null;
    }

    public SyntaxElement getCurrentElement() {
        return this.element;
    }

    public List<String> getPathFromRoot() {
        if (this.isValid()) {
            SyntaxElement syntaxElement = this.element;
            Stack<SyntaxElement> stack = new Stack<SyntaxElement>();
            while (syntaxElement != null) {
                if (syntaxElement instanceof EndTag || syntaxElement instanceof EmptyTag && stack.isEmpty() || syntaxElement instanceof StartTag && stack.isEmpty()) {
                    stack.push(syntaxElement);
                    syntaxElement = syntaxElement.getPrevious();
                    continue;
                }
                if (syntaxElement instanceof StartTag) {
                    EndTag endTag;
                    StartTag startTag = (StartTag)syntaxElement;
                    if (stack.peek() instanceof EndTag) {
                        endTag = (EndTag)stack.peek();
                        if (endTag.getTagName().equals(startTag.getTagName())) {
                            stack.pop();
                        }
                    } else {
                        endTag = stack.peek();
                        String string = endTag instanceof StartTag ? ((StartTag)endTag).getTagName() : ((EmptyTag)endTag).getTagName();
                        stack.push(syntaxElement);
                    }
                }
                syntaxElement = syntaxElement.getPrevious();
            }
            return this.createPath(stack);
        }
        return Collections.emptyList();
    }

    private List<String> createPath(Stack<SyntaxElement> stack) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!stack.isEmpty()) {
            SyntaxElement syntaxElement = stack.pop();
            String string = syntaxElement instanceof StartTag ? ((StartTag)syntaxElement).getTagName() : ((EmptyTag)syntaxElement).getTagName();
            if (string == null) continue;
            arrayList.add(string);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Document getDocument() {
        return this.document;
    }

    public String lookupNamespacePrefix(String string) {
        return this.declaredNamespaces.get(string);
    }

    public String getNamespacePrefix(String string) {
        for (Map.Entry<String, String> entry : this.declaredNamespaces.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Collection<String> getDeclaredNamespaces() {
        return this.declaredNamespaces.values();
    }

    public StartTag getDocRoot() {
        return this.docRoot;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    private void populateNamespaces() {
        SyntaxElement syntaxElement;
        for (syntaxElement = this.element; syntaxElement != null && !(syntaxElement instanceof StartTag) && !(syntaxElement instanceof EmptyTag); syntaxElement = syntaxElement.getPrevious()) {
        }
        if (syntaxElement == null) {
            return;
        }
        for (Node node = (Node)syntaxElement; node != null; node = node.getParentNode()) {
            if (!(node instanceof StartTag) && !(node instanceof EmptyTag)) continue;
            NamedNodeMap namedNodeMap = ((Tag)node).getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string;
                Attr attr = (Attr)namedNodeMap.item(i);
                String string2 = attr.getName();
                String string3 = attr.getValue();
                if (string2 == null || string3 == null || (string = ContextUtilities.getPrefixFromNamespaceDeclaration(string2)) == null || this.declaredNamespaces.containsKey(string)) continue;
                this.declaredNamespaces.put(string, string3);
            }
        }
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DocumentContext documentContext = (DocumentContext)object;
        return this.document == documentContext.document || this.document != null && this.document.equals(documentContext.document);
    }

    public int hashCode() {
        int n = 5;
        n = 61 * n + (this.document != null ? this.document.hashCode() : 0);
        return n;
    }
}

