/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.wizards.HibernateRevengDatabaseTablesPanel;
import org.netbeans.modules.hibernate.wizards.HibernateRevengWizard;
import org.netbeans.modules.hibernate.wizards.HibernateRevengWizardHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateRevengDbTablesWizardDescriptor
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private HibernateRevengDatabaseTablesPanel component;
    private boolean componentInitialized;
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private String title;

    public HibernateRevengDbTablesWizardDescriptor(Project project, String string) {
        this.project = project;
        this.title = string;
    }

    public HibernateRevengDatabaseTablesPanel getComponent() {
        if (this.component == null) {
            this.component = new HibernateRevengDatabaseTablesPanel(this.project);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(HibernateRevengDbTablesWizardDescriptor.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
        if (!this.componentInitialized) {
            this.componentInitialized = true;
            this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
            this.getComponent().initialize(this.project);
        }
    }

    public boolean isValid() {
        if (this.getComponent().getConfigurationFile() != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.getComponent().getConfigurationFile());
                HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)dataObject;
                HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
                boolean bl = hibernateEnvironment.canLoadDBDriver(hibernateCfgDataObject.getHibernateConfiguration());
                if (!bl) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateRevengDbTablesWizardDescriptor.class, (String)"ERR_Include_DBJars"));
                    return false;
                }
            }
            catch (Exception exception) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateRevengDbTablesWizardDescriptor.class, (String)"ERR_Include_DBJars"));
                return false;
            }
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        WizardDescriptor wizardDescriptor2 = wizardDescriptor;
        Object object = wizardDescriptor2.getValue();
        if (object.equals(WizardDescriptor.NEXT_OPTION) || object.equals(WizardDescriptor.FINISH_OPTION)) {
            HibernateRevengWizardHelper hibernateRevengWizardHelper = HibernateRevengWizard.getHelper(this.wizardDescriptor);
            hibernateRevengWizardHelper.setTableClosure(this.getComponent().getTableClosure());
            hibernateRevengWizardHelper.setConfigurationFile(this.getComponent().getConfigurationFile());
            hibernateRevengWizardHelper.setSchemaName(this.getComponent().getSchemaName());
            hibernateRevengWizardHelper.setCatalogName(this.getComponent().getCatalogName());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }

    private void setErrorMessage(String string) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
    }
}

