/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlParser;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.util.JarExploder;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class EjbDataSourcesImportor {
    private static final String tmpDir = System.getProperty("java.io.tmpdir");
    private String filePath;

    public EjbDataSourcesImportor(String string) {
        this.filePath = string;
    }

    public Collection getEjbGroups() {
        try {
            this.explodeJar();
            EjbDataSourceXmlParser ejbDataSourceXmlParser = new EjbDataSourceXmlParser(tmpDir + File.separator + "ejbsources.xml");
            Collection collection = ejbDataSourceXmlParser.parse();
            for (EjbGroup ejbGroup : collection) {
                ejbGroup.fixJarDir(tmpDir);
            }
            return collection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void explodeJar() throws EjbLoadException {
        try {
            File file = new File(tmpDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            JarExploder jarExploder = new JarExploder();
            jarExploder.explodeJar(file.getAbsolutePath(), this.filePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "Error occurred when trying to import EJB sets. Cannot find file " + this.filePath;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor").log(65536, string);
            String string2 = NbBundle.getMessage(EjbDataSourcesImportor.class, (String)"FILE_NOT_FOUND", (Object)this.filePath);
            throw new EjbLoadException(1, string2);
        }
        catch (IOException iOException) {
            String string = "Error occurred when trying to import EJB sets. Cannot read file " + this.filePath;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor").log(65536, string);
            String string3 = NbBundle.getMessage(EjbDataSourcesImportor.class, (String)"CANNOT_READ_FILE", (Object)this.filePath);
            throw new EjbLoadException(1, string3);
        }
    }
}

