/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;

public class ScaleActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor SCALE_NW_MOUSE_CURSOR = new ActionMouseCursor(6, 3);
    private static final ActionMouseCursor SCALE_SE_MOUSE_CURSOR = new ActionMouseCursor(5, 3);

    public ScaleActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        MouseEvent mouseEvent;
        SVGObject sVGObject;
        if (!bl && !this.m_sceneMgr.isReadOnly() && aWTEvent.getID() == 501 && (sVGObject = this.getObjectToScaleAt(mouseEvent = (MouseEvent)aWTEvent)) != null) {
            return new ScaleAction(this, sVGObject, mouseEvent);
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        SVGObject sVGObject = this.getSelectedObject();
        if (!bl && sVGObject != null) {
            if (this.isNWScalePoint(sVGObject, mouseEvent)) {
                return SCALE_NW_MOUSE_CURSOR;
            }
            if (this.isSEScalePoint(sVGObject, mouseEvent)) {
                return SCALE_SE_MOUSE_CURSOR;
            }
        }
        return null;
    }

    private SVGObject getObjectToScaleAt(MouseEvent mouseEvent) {
        SVGObject sVGObject = this.getSelectedObject();
        if (sVGObject != null && (this.isNWScalePoint(sVGObject, mouseEvent) || this.isSEScalePoint(sVGObject, mouseEvent))) {
            return sVGObject;
        }
        return null;
    }

    protected SVGObject getSelectedObject() {
        SVGObject[] sVGObjectArray = this.m_sceneMgr.getSelected();
        if (sVGObjectArray != null && sVGObjectArray.length > 0) {
            return sVGObjectArray[0];
        }
        return null;
    }

    private boolean isNWScalePoint(SVGObject sVGObject, MouseEvent mouseEvent) {
        return sVGObject.getOutline().isAtScaleNWHandlePoint(mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean isSEScalePoint(SVGObject sVGObject, MouseEvent mouseEvent) {
        return sVGObject.getOutline().isAtScaleSEHandlePoint(mouseEvent.getX(), mouseEvent.getY());
    }

    protected static class ScaleAction
    extends AbstractComposerAction {
        protected final SVGObject m_scaled;
        private final int m_x;
        private final int m_y;

        public ScaleAction(ComposerActionFactory composerActionFactory, SVGObject sVGObject, MouseEvent mouseEvent) {
            super(composerActionFactory);
            this.m_scaled = sVGObject;
            this.m_x = mouseEvent.getX();
            this.m_y = mouseEvent.getY();
        }

        public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
            if (!bl && aWTEvent.getID() == 506) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Rectangle rectangle = this.m_scaled.getScreenBBox();
                this.m_scaled.scale(this.calculateScaleX(mouseEvent.getX()), this.calculateScaleY(mouseEvent.getY()));
                rectangle.add(this.m_scaled.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(rectangle, 5);
            } else {
                this.actionCompleted();
                this.m_scaled.commitChanges();
            }
            return false;
        }

        public ActionMouseCursor getMouseCursor(boolean bl) {
            return bl ? null : SCALE_SE_MOUSE_CURSOR;
        }

        public synchronized void actionCompleted() {
            this.m_scaled.repaint(5);
            this.m_scaled.applyTextChanges();
            this.m_scaled.commitChanges();
            super.actionCompleted();
        }

        protected float calculateScaleX(int n) {
            float[] fArray = this.m_scaled.getOutline().getScalePivotPoint();
            return this.calculateScale(fArray[0], this.m_x, n);
        }

        protected float calculateScaleY(int n) {
            float[] fArray = this.m_scaled.getOutline().getScalePivotPoint();
            return this.calculateScale(fArray[1], this.m_y, n);
        }

        private float calculateScale(float f, float f2, float f3) {
            float f4 = f - f2;
            float f5 = f4 * f4;
            f4 = f - f3;
            float f6 = f4 * f4;
            return f6 / f5;
        }
    }
}

