/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.imageio.IIOException;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.SVGAnimationRasterizerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class SaveAnimationAsImageAction
extends CookieAction {
    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public static void setDialogMinimumSize(final Dialog dialog) {
        dialog.pack();
        dialog.setSize(dialog.getPreferredSize());
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = dialog.getWidth();
                int n2 = dialog.getHeight();
                Dimension dimension = dialog.getPreferredSize();
                int n3 = Math.max(n, dimension.width);
                int n4 = Math.max(n2, dimension.height);
                if (n != n3 || n2 != n4) {
                    dialog.setSize(new Dimension(n3, n4));
                }
            }
        });
    }

    protected void performAction(Node[] nodeArray) {
        SVGDataObject sVGDataObject = (SVGDataObject)((Object)nodeArray[0].getLookup().lookup(SVGDataObject.class));
        if (sVGDataObject != null) {
            try {
                SVGAnimationRasterizerPanel sVGAnimationRasterizerPanel = new SVGAnimationRasterizerPanel(sVGDataObject);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sVGAnimationRasterizerPanel, NbBundle.getMessage(SaveAnimationAsImageAction.class, (String)"TITLE_AnimationExport"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                SaveAnimationAsImageAction.setDialogMinimumSize(dialog);
                dialog.setVisible(true);
                sVGAnimationRasterizerPanel.stopProcessing();
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && sVGAnimationRasterizerPanel.isExportConfirmed()) {
                    AnimationRasterizer.export(sVGDataObject, sVGAnimationRasterizerPanel);
                }
            }
            catch (IIOException iIOException) {
                String string = NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"MSG_IMG_ENCODING_ERROR") + ": " + iIOException.getLocalizedMessage();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            }
            catch (Exception exception) {
                SceneManager.error("Animation export failed", exception);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(SaveAnimationAsImageAction.class, (String)"LBL_ExportAnimationAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected int mode() {
        return 1;
    }

    protected Class[] cookieClasses() {
        return new Class[]{SVGDataObject.class};
    }

    protected boolean asynchronous() {
        return false;
    }
}

