/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Dialog;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.SVGImageRasterizerPanel;
import org.netbeans.modules.mobility.svgcore.export.SaveAnimationAsImageAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class SaveAsImageAction
extends CookieAction {
    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodeArray) {
        SVGDataObject sVGDataObject = (SVGDataObject)((Object)nodeArray[0].getLookup().lookup(SVGDataObject.class));
        if (sVGDataObject != null) {
            try {
                SVGImageRasterizerPanel sVGImageRasterizerPanel = new SVGImageRasterizerPanel(sVGDataObject, null);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sVGImageRasterizerPanel, NbBundle.getMessage(SaveAnimationAsImageAction.class, (String)"TITLE_ImageExport"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                SaveAnimationAsImageAction.setDialogMinimumSize(dialog);
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && sVGImageRasterizerPanel.isExportConfirmed()) {
                    AnimationRasterizer.export(sVGDataObject, sVGImageRasterizerPanel);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(SaveAsImageAction.class, (String)"LBL_ExportAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected int mode() {
        return 1;
    }

    protected Class[] cookieClasses() {
        return new Class[]{SVGDataObject.class};
    }

    protected boolean asynchronous() {
        return false;
    }
}

