/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.microedition.m2g.SVGImage;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.CharSeq;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.editor.structure.api.DocumentModelStateListener;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.ElementMapping;
import org.netbeans.modules.mobility.svgcore.model.EncodingInputStream;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SVGFileModel {
    protected static final int MAX_TOOLTIP_ATTR_SIZE = 100;
    protected static final String XML_TAG = "tag";
    protected static final String XML_EMPTY_TAG = "empty_tag";
    protected static final String XML_ERROR_TAG = "error";
    protected static final String[] ANIMATION_TAGS = new String[]{"animate", "animateTransform", "animateMotion", "animateColor", "set"};
    protected static final String TRANSACTION_TOKEN = "transaction";
    protected static final String MODEL_UPDATE_TOKEN = "update";
    private final XmlMultiViewEditorSupport m_edSup;
    private final ElementMapping m_mapping;
    private final List<ModelListener> m_modelListeners = new ArrayList<ModelListener>();
    private final Object m_lock = new Object();
    private final Object m_transactionLock = new Object();
    private volatile BaseDocument m_bDoc;
    private DocumentModel m_model;
    private boolean m_isChanged = true;
    private volatile boolean m_eventInProgress = false;
    private volatile boolean m_sourceChanged = false;
    private volatile boolean m_updateInProgress = false;
    private volatile boolean m_updateInProcess = false;
    private volatile int[] m_transactionCounter = new int[]{0};
    private final DocumentListener m_docListener = new DocumentListener(){

        public void removeUpdate(DocumentEvent documentEvent) {
            SVGFileModel.this.documentModified(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SVGFileModel.this.documentModified(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getLength() > 0 || documentEvent.getOffset() > 0 || documentEvent.getType() != DocumentEvent.EventType.CHANGE) {
                SVGFileModel.this.documentModified(documentEvent);
            }
        }
    };
    private final DocumentModelListener m_modelListener = new DocumentModelListener(){

        public void documentElementRemoved(DocumentElement documentElement) {
            if (SVGFileModel.isTagElement(documentElement)) {
                if (SceneManager.isEnabled(Level.FINEST)) {
                    SceneManager.log(Level.FINEST, "Element removed: " + documentElement);
                }
                SVGFileModel.this.m_mapping.remove(documentElement);
                SVGFileModel.this.fireModelChange();
            }
        }

        public void documentElementChanged(DocumentElement documentElement) {
            if (SVGFileModel.isTagElement(documentElement)) {
                if (SceneManager.isEnabled(Level.FINEST)) {
                    SceneManager.log(Level.FINEST, "Element changed: " + documentElement);
                }
                SVGFileModel.this.fireModelChange();
            }
        }

        public void documentElementAttributesChanged(DocumentElement documentElement) {
            if (SVGFileModel.isTagElement(documentElement)) {
                if (SceneManager.isEnabled(Level.FINEST)) {
                    SceneManager.log(Level.FINEST, "Element attr changed: " + documentElement);
                }
                SVGFileModel.this.fireModelChange();
            }
        }

        public void documentElementAdded(DocumentElement documentElement) {
            if (SVGFileModel.isTagElement(documentElement)) {
                if (SceneManager.isEnabled(Level.FINEST)) {
                    SceneManager.log(Level.FINEST, "Element added: " + documentElement);
                }
                SVGFileModel.this.m_mapping.add(documentElement);
                SVGFileModel.this.fireModelChange();
            }
        }
    };
    private final DocumentModelStateListener m_modelStateListener = new DocumentModelStateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sourceChanged() {
            Object object = SVGFileModel.this.m_lock;
            synchronized (object) {
                SceneManager.log(Level.FINER, "Document source changed.");
                SVGFileModel.this.m_sourceChanged = true;
                SVGFileModel.this.m_lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scanningStarted() {
            Object object = SVGFileModel.this.m_lock;
            synchronized (object) {
                SceneManager.log(Level.FINER, "Document scanning started.");
                SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.MODEL_UPDATE_TOKEN, true);
                SVGFileModel.this.m_updateInProgress = true;
                SVGFileModel.this.m_sourceChanged = false;
                SVGFileModel.this.m_lock.notifyAll();
            }
        }

        public void updateStarted() {
            SceneManager.log(Level.FINER, "Model update started.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateFinished() {
            Object object = SVGFileModel.this.m_lock;
            synchronized (object) {
                SceneManager.log(Level.FINER, "Model update finished.");
                SVGFileModel.this.m_updateInProgress = false;
                SVGFileModel.this.m_lock.notifyAll();
                SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.MODEL_UPDATE_TOKEN, false);
            }
        }
    };
    private final Runnable m_updateTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SceneManager.log(Level.FINER, "Update task started.");
            try {
                List list = SVGFileModel.this.m_modelListeners;
                synchronized (list) {
                    for (int i = 0; i < SVGFileModel.this.m_modelListeners.size(); ++i) {
                        ((ModelListener)SVGFileModel.this.m_modelListeners.get(i)).modelChanged();
                    }
                }
            }
            finally {
                SceneManager.log(Level.FINER, "Update task finished.");
                SVGFileModel.this.m_eventInProgress = false;
            }
        }
    };

    public SVGFileModel(XmlMultiViewEditorSupport xmlMultiViewEditorSupport) {
        this.m_edSup = xmlMultiViewEditorSupport;
        this.m_model = null;
        this.m_mapping = new ElementMapping(this);
    }

    public synchronized void attachToOpenedDocument() {
        assert (SwingUtilities.isEventDispatchThread()) : "Model initialisation must be called from AWT thread!";
        if (this.m_bDoc == null) {
            this.m_bDoc = this.getOpenedDoc();
            SceneManager.log(Level.INFO, "Using already opened document.");
            assert (this.m_bDoc != null);
            this.m_bDoc.addDocumentListener(this.m_docListener);
        } else assert (this.m_bDoc == this.getOpenedDoc()) : "Model mismatch";
    }

    public synchronized void detachDocument() {
        this.m_model = null;
        this.m_bDoc = null;
        this.m_modelListeners.clear();
        SceneManager.log(Level.INFO, "Removing the document.");
    }

    private BaseDocument getOpenedDoc() {
        JEditorPane[] jEditorPaneArray = this.m_edSup.getOpenedPanes();
        if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
            return (BaseDocument)jEditorPaneArray[0].getDocument();
        }
        return null;
    }

    private SceneManager getSceneManager() {
        return ((SVGDataObject)this.m_edSup.getDataObject()).getSceneManager();
    }

    public Object getTransactionMonitor() {
        return this.m_transactionLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementTransactionCounter() {
        int[] nArray = this.m_transactionCounter;
        synchronized (this.m_transactionCounter) {
            this.m_transactionCounter[0] = this.m_transactionCounter[0] + 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_transactionCounter[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementTransactionCounter() {
        int[] nArray = this.m_transactionCounter;
        synchronized (this.m_transactionCounter) {
            this.m_transactionCounter[0] = this.m_transactionCounter[0] - 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_transactionCounter[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTransactionCounter() {
        int[] nArray = this.m_transactionCounter;
        synchronized (this.m_transactionCounter) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_transactionCounter[0];
        }
    }

    private synchronized BaseDocument getDoc() {
        if (this.m_bDoc == null) {
            try {
                SceneManager.log(Level.INFO, "Opening new document.");
                this.m_bDoc = (BaseDocument)this.m_edSup.openDocument();
                assert (this.m_bDoc != null);
                this.m_bDoc.addDocumentListener(this.m_docListener);
            }
            catch (IOException iOException) {
                SceneManager.error("Could not open the document", iOException);
            }
        }
        return this.m_bDoc;
    }

    private synchronized void checkModel() {
        if (this.m_model == null) {
            try {
                this.m_model = DocumentModel.getDocumentModel((Document)this.getDoc());
                this.m_model.addDocumentModelListener(this.m_modelListener);
                this.m_model.addDocumentModelStateListener(this.m_modelStateListener);
            }
            catch (DocumentModelException documentModelException) {
                SceneManager.error("Could not obtain document model", documentModelException);
            }
        }
    }

    public SVGDataObject getDataObject() {
        return (SVGDataObject)this.m_edSup.getDataObject();
    }

    public SVGImage parseSVGImage() throws IOException, BadLocationException, InterruptedException {
        SceneManager.log(Level.INFO, "Parsing image...");
        this.checkModel();
        SVGImage sVGImage = this.m_mapping.parseDocument(true);
        SceneManager.log(Level.INFO, "Image parsed.");
        return sVGImage;
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    public void setChanged(boolean bl) {
        this.m_isChanged = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.m_modelListeners;
        synchronized (list) {
            this.m_modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.m_modelListeners;
        synchronized (list) {
            this.m_modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void documentModified(DocumentEvent documentEvent) {
        BaseDocumentEvent baseDocumentEvent;
        if (documentEvent instanceof BaseDocumentEvent && ((baseDocumentEvent = (BaseDocumentEvent)documentEvent).isInRedo() || baseDocumentEvent.isInUndo() || this.getTransactionCounter() == 0)) {
            SVGFileModel sVGFileModel = this;
            synchronized (sVGFileModel) {
                if (!this.m_updateInProcess) {
                    this.m_updateInProcess = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SVGFileModel.this.m_updateInProcess = false;
                            ((SVGDataObject)SVGFileModel.this.m_edSup.getDataObject()).fireContentChanged();
                        }
                    });
                }
            }
        }
        this.setChanged(true);
    }

    public synchronized DocumentModel getModel() {
        this.checkModel();
        return this.m_model;
    }

    public static boolean isTagElement(DocumentElement documentElement) {
        return documentElement != null && (documentElement.getType().equals(XML_TAG) || documentElement.getType().equals(XML_EMPTY_TAG));
    }

    public static boolean isError(DocumentElement documentElement) {
        return documentElement.getType().equals(XML_ERROR_TAG);
    }

    public static String getIdAttribute(DocumentElement documentElement) {
        AttributeSet attributeSet = documentElement.getAttributes();
        String string = (String)attributeSet.getAttribute("id");
        return string;
    }

    public static boolean isHiddenElement(DocumentElement documentElement) {
        AttributeSet attributeSet = documentElement.getAttributes();
        String string = (String)attributeSet.getAttribute("visibility");
        return string != null && string.equals("hidden");
    }

    public static List<DocumentElement> getParents(DocumentElement documentElement) {
        ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
        while (documentElement != null) {
            arrayList.add(documentElement);
            documentElement = documentElement.getParentElement();
        }
        return arrayList;
    }

    public DocumentElement getElementById(String string) {
        this.checkModel();
        DocumentElement documentElement = this.m_mapping.id2element(string);
        return documentElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getElementAsText(String string) throws BadLocationException {
        Object object = this.getTransactionMonitor();
        synchronized (object) {
            this.updateModel();
            try {
                this.m_model.readLock();
                DocumentElement documentElement = this.getElementById(string);
                if (documentElement != null) {
                    BaseDocument baseDocument = this.getDoc();
                    int n = documentElement.getStartOffset();
                    int n2 = documentElement.getEndOffset();
                    String string2 = baseDocument.getText(n, n2 - n + 1);
                    return string2;
                }
                String string3 = null;
                return string3;
            }
            finally {
                this.m_model.readUnlock();
            }
        }
    }

    public String getElementId(DocumentElement documentElement) {
        String string = this.m_mapping.element2id(documentElement);
        if (string == null) {
            string = "";
            System.out.println("Element " + documentElement + " could not be found!");
        }
        return string;
    }

    public String createUniqueId(String string, boolean bl) {
        return this.createUniqueId(string, bl, null);
    }

    public String createUniqueId(String string, boolean bl, Set<String> set) {
        return this.m_mapping.generateId(string, bl, set);
    }

    public static boolean isWrapperId(String string) {
        return ElementMapping.isWrapperId(string);
    }

    public synchronized String describeElement(String string) {
        DocumentElement documentElement = this.getElementById(string);
        if (documentElement != null) {
            this.checkIntegrity(documentElement);
            return SVGFileModel.describeElement(documentElement);
        }
        return "";
    }

    public int firstIndexOf(String string) {
        CharSeq charSeq = this.getDoc().getText();
        int n = charSeq.length();
        int n2 = string.length();
        if (n2 > 0) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (charSeq.charAt(i) == string.charAt(n3)) {
                    if (++n3 != n2) continue;
                    return i - n3 + 1;
                }
                n3 = 0;
            }
        }
        return -1;
    }

    public int[] getPositionByOffset(int n) {
        Element element = this.getDoc().getDefaultRootElement();
        int n2 = element.getElementCount();
        for (int i = 0; i < n2; ++i) {
            Element element2 = element.getElement(i);
            if (element2.getEndOffset() <= n) continue;
            assert (element2.getStartOffset() <= n);
            return new int[]{i + 1, n - element2.getStartOffset() + 1};
        }
        return null;
    }

    public int getOffsetByPosition(int n, int n2) {
        Element element = this.getDoc().getDefaultRootElement();
        n = Math.max(n, 1);
        n = Math.min(n, element.getElementCount());
        int n3 = element.getElement(n - 1).getStartOffset() + n2;
        return n3;
    }

    protected static String describeElement(DocumentElement documentElement) {
        StringBuilder stringBuilder = new StringBuilder();
        AttributeSet attributeSet = documentElement.getAttributes();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuilder.append("&nbsp;");
            stringBuilder.append(string);
            stringBuilder.append("=\"");
            Object object = attributeSet.getAttribute(string);
            if (object != null) {
                String string2 = object.toString();
                if (string2.length() > 100) {
                    stringBuilder.append(string2.substring(0, 100));
                    stringBuilder.append("...");
                } else {
                    stringBuilder.append(string2);
                }
            }
            stringBuilder.append('\"');
            stringBuilder.append("&nbsp;<br>");
        }
        return stringBuilder.toString();
    }

    public static boolean isAnimation(DocumentElement documentElement) {
        String string = documentElement.getName();
        for (int i = 0; i < ANIMATION_TAGS.length; ++i) {
            if (!ANIMATION_TAGS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private List<DocumentElement> collectFragmentsToDelete(CharSequence charSequence, DocumentElement documentElement, List<DocumentElement> list, List<String> list2) {
        assert (!list.contains(documentElement));
        list.add(documentElement);
        List<String> list3 = SVGFileModel.collectIds(documentElement, new ArrayList<String>());
        if (list2 != null) {
            list2.addAll(list3);
        }
        DocumentElement documentElement2 = this.m_model.getRootElement();
        ArrayList<ChangeDescriptor> arrayList = new ArrayList<ChangeDescriptor>();
        for (String object : list3) {
            SVGFileModel.resolveChanges(charSequence, documentElement2, object, object, arrayList);
        }
        for (ChangeDescriptor changeDescriptor : arrayList) {
            DocumentElement documentElement3 = changeDescriptor.m_elem;
            assert (documentElement3 != null);
            if (list.contains(documentElement3)) continue;
            this.collectFragmentsToDelete(charSequence, documentElement3, list, null);
        }
        return list;
    }

    public void deleteElement(final String string, final TransactionCommand transactionCommand) {
        this.runTransaction(new FileModelTransaction(){

            protected void transaction() throws BadLocationException {
                int n;
                int n2;
                final DocumentElement documentElement = SVGFileModel.this.checkIntegrity(string);
                BaseDocument baseDocument = SVGFileModel.this.getDoc();
                ArrayList arrayList = new ArrayList();
                CharSequence charSequence = (CharSequence)baseDocument.getProperty(CharSequence.class);
                List list = SVGFileModel.this.collectFragmentsToDelete(charSequence, documentElement, new ArrayList(), arrayList);
                block0: for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    DocumentElement documentElement2 = (DocumentElement)list.get(n2);
                    int n3 = documentElement2.getStartOffset();
                    int n4 = documentElement2.getEndOffset();
                    for (n = list.size() - 1; n >= 0; --n) {
                        DocumentElement documentElement3;
                        if (n == n2 || (documentElement3 = (DocumentElement)list.get(n)).getStartOffset() > n3 || documentElement3.getEndOffset() < n4) continue;
                        list.remove(n2);
                        continue block0;
                    }
                }
                if (list.size() > 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n5 = 0;
                    Object object = arrayList.iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        stringBuilder.append('\t');
                        if (++n5 > 10) {
                            stringBuilder.append("...\n");
                            break;
                        }
                        stringBuilder.append(string2);
                        stringBuilder.append('\n');
                    }
                    if ((object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SVGFileModel.class, (String)"WARNING_IDReferences", (Object)stringBuilder.toString()), 1, 2))) == NotifyDescriptor.NO_OPTION) {
                        Collections.sort(list, new Comparator(){

                            public int compare(Object object, Object object2) {
                                return ((DocumentElement)object2).getStartOffset() - ((DocumentElement)object).getStartOffset();
                            }
                        });
                    } else if (object == NotifyDescriptor.YES_OPTION) {
                        list.clear();
                        list.add(documentElement);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SVGSourceMultiViewElement.selectPosition(SVGFileModel.this.getDataObject(), documentElement.getStartOffset(), true);
                            }
                        });
                    } else {
                        if (object == NotifyDescriptor.CANCEL_OPTION || object == NotifyDescriptor.CLOSED_OPTION) {
                            return;
                        }
                        assert (false) : "Unknown option: " + object;
                    }
                }
                n2 = Integer.MAX_VALUE;
                ArrayList<String> arrayList2 = new ArrayList<String>(list.size());
                for (DocumentElement documentElement4 : list) {
                    n = documentElement4.getStartOffset();
                    int n6 = documentElement4.getEndOffset();
                    assert (n >= 0);
                    assert (n6 > n);
                    assert (n6 <= n2);
                    n2 = n;
                    String string3 = SVGFileModel.getIdAttribute(documentElement4);
                    if (string3 == null) {
                        string3 = SVGFileModel.this.getElementId(documentElement4);
                    }
                    if (string3 != null) {
                        arrayList2.add(string3);
                    }
                    SVGFileModel.removeFragment(baseDocument, charSequence, n, n6);
                }
                if (!arrayList2.isEmpty()) {
                    transactionCommand.execute(arrayList2);
                }
            }
        });
    }

    private static void removeFragment(BaseDocument baseDocument, CharSequence charSequence, int n, int n2) throws BadLocationException {
        char c;
        int n3 = n;
        int n4 = n2;
        boolean bl = false;
        while (n > 0 && (c = charSequence.charAt(n - 1)) <= ' ') {
            if (c == '\n') {
                bl = true;
            }
            --n;
        }
        int n5 = charSequence.length() - 1;
        while (n2 < n5 && (c = charSequence.charAt(n2 + 1)) <= ' ') {
            if (c == '\n') {
                bl = true;
            }
            ++n2;
        }
        int n6 = n;
        int n7 = n2;
        while (bl) {
            if (n6 < n3 && charSequence.charAt(n6++) == '\n') {
                n = n6;
                break;
            }
            if (n7 <= n4 || charSequence.charAt(n7--) != '\n') continue;
            n2 = n7;
            break;
        }
        baseDocument.remove(n, n2 - n + 1);
    }

    public void appendElement(final String string) {
        this.runTransaction(new FileModelTransaction(true){

            protected void transaction() throws BadLocationException {
                DocumentElement documentElement = SVGFileModel.getSVGRoot(SVGFileModel.this.m_model);
                if (documentElement != null) {
                    BaseDocument baseDocument = SVGFileModel.this.getDoc();
                    List list = documentElement.getChildren();
                    DocumentElement documentElement2 = SVGFileModel.getLastTagChild(list);
                    if (documentElement2 != null) {
                        CharSequence charSequence = (CharSequence)baseDocument.getProperty(CharSequence.class);
                        documentElement2 = SVGFileModel.getLastVisibleTagChild(list);
                        int n = documentElement2.getEndOffset() + 1;
                        String string2 = string;
                        int n2 = n;
                        while (n2 > 0) {
                            char c;
                            if ((c = charSequence.charAt(--n2)) <= ' ') {
                                if (c != '\n') continue;
                                break;
                            }
                            string2 = '\n' + string2;
                            break;
                        }
                        baseDocument.insertString(n, string2, null);
                        baseDocument.getFormatter().reformat(baseDocument, n, n + string2.length() + 1);
                    } else {
                        String string3 = baseDocument.getText(0, baseDocument.getLength());
                        int n = documentElement.getStartOffset();
                        int n3 = 0;
                        int n4 = documentElement.getEndOffset() - 1;
                        while (n4 > n) {
                            char c = string3.charAt(n4--);
                            n3 = c;
                            if (c != '/') continue;
                        }
                        if (n3 == 47) {
                            if (string3.charAt(n4) == '<') {
                                baseDocument.insertString(n4, string, null);
                                baseDocument.getFormatter().reformat(baseDocument, n4, n4 + string.length() + 1);
                            } else {
                                StringBuilder stringBuilder = new StringBuilder(string3.substring(n, n4 + 1));
                                stringBuilder.append(">\n");
                                stringBuilder.append(string);
                                stringBuilder.append("\n</svg>");
                                baseDocument.replace(n, documentElement.getEndOffset() - n + 1, stringBuilder.toString(), null);
                                baseDocument.getFormatter().reformat(baseDocument, n4, baseDocument.getLength());
                            }
                        }
                    }
                }
            }
        });
    }

    private static String getElemTextWithId(BaseDocument baseDocument, DocumentElement documentElement, String string) throws BadLocationException {
        String string2;
        int n = documentElement.getStartOffset();
        if (documentElement.getAttributes().isDefined("id")) {
            string2 = baseDocument.getText(n, documentElement.getEndOffset() - n + 1);
        } else {
            String string3 = documentElement.getName();
            n += 1 + string3.length();
            StringBuilder stringBuilder = new StringBuilder("<");
            stringBuilder.append(string3);
            stringBuilder.append(' ');
            SVGFileModel.injectId(stringBuilder, string);
            stringBuilder.append(baseDocument.getText(n, documentElement.getEndOffset() - n + 1));
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private static StringBuilder injectId(StringBuilder stringBuilder, String string) {
        stringBuilder.append("id");
        stringBuilder.append("=\"");
        stringBuilder.append(string);
        stringBuilder.append("\" ");
        return stringBuilder;
    }

    public void setAttributes(final String string, final String[] stringArray) {
        this.runTransaction(new FileModelTransaction(){

            protected void transaction() throws BadLocationException {
                boolean bl;
                DocumentElement documentElement = SVGFileModel.this.checkIntegrity(string);
                assert (SVGFileModel.isTagElement(documentElement)) : "Attribute change allowed only for tag elements";
                int n = documentElement.getStartOffset() + 1 + documentElement.getName().length();
                List list = documentElement.getChildren();
                int n2 = list.size() > 0 ? ((DocumentElement)list.get(0)).getStartOffset() - 1 : documentElement.getEndOffset() - 1;
                boolean bl2 = bl = !documentElement.getAttributes().isDefined("id");
                assert (stringArray.length % 2 == 0);
                BaseDocument baseDocument = SVGFileModel.this.getDoc();
                block0: for (int i = 0; i < stringArray.length; i += 2) {
                    String string6 = baseDocument.getText(n, n2 - n + 1);
                    String string2 = stringArray[i];
                    String string3 = stringArray[i + 1];
                    int n3 = SVGFileModel.indexOfAttr(string6, string2);
                    if (n3 != -1) {
                        int n4 = n3;
                        n3 += string2.length();
                        while (++n3 < string6.length()) {
                            if (string6.charAt(n3) != '\"') continue;
                            int n5 = n3;
                            while (++n5 < string6.length()) {
                                int n6;
                                if (string6.charAt(n5) != '\"') continue;
                                ++n3;
                                if (string3 != null) {
                                    String string4;
                                    if (bl) {
                                        StringBuilder stringBuilder = new StringBuilder(string3);
                                        stringBuilder.append("\" ");
                                        SVGFileModel.injectId(stringBuilder, string);
                                        bl = false;
                                        n6 = n5 - n3 + 1;
                                        string4 = stringBuilder.toString();
                                        baseDocument.replace(n + n3, n6, string4, null);
                                    } else {
                                        n6 = n5 - n3;
                                        string4 = string3;
                                        baseDocument.replace(n + n3, n6, string4, null);
                                    }
                                    n2 = n2 - n6 + string4.length();
                                    continue block0;
                                }
                                n6 = n5 - n4 + 1;
                                baseDocument.remove(n + n4, n6);
                                n2 -= n6;
                                continue block0;
                            }
                        }
                        SceneManager.log(Level.SEVERE, "Attribute " + string2 + " not changed: \"" + string6 + "\"");
                        continue;
                    }
                    if (string3 == null) continue;
                    StringBuilder stringBuilder = new StringBuilder(" ");
                    if (bl) {
                        SVGFileModel.injectId(stringBuilder, string);
                        bl = false;
                    }
                    stringBuilder.append(string2);
                    stringBuilder.append("=\"");
                    stringBuilder.append(string3);
                    stringBuilder.append("\" ");
                    String string5 = stringBuilder.toString();
                    baseDocument.insertString(n, string5, null);
                    n2 += string5.length();
                }
            }
        });
    }

    private static int skipWhite(String string, int n) {
        while (n < string.length()) {
            if (string.charAt(n) > ' ') {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static int indexOfAttr(String string, String string2) {
        int n = 0;
        while ((n = string.indexOf(string2, n)) != -1) {
            int n2;
            int n3 = n;
            if (n3 >= 1 && string.charAt(n3 - 1) != ' ' || (n2 = SVGFileModel.skipWhite(string, n += string2.length())) == -1 || string.charAt(n2) != '=' || (n2 = SVGFileModel.skipWhite(string, n2 + 1)) == -1 || string.charAt(n2) != '\"') continue;
            return n3;
        }
        return n;
    }

    public void setAttribute(final String string, final String string2, final String string3) {
        this.runTransaction(new FileModelTransaction(){

            protected void transaction() throws BadLocationException {
                DocumentElement documentElement = SVGFileModel.this.checkIntegrity(string);
                assert (SVGFileModel.isTagElement(documentElement)) : "Attribute change allowed only for tag elements";
                int n = documentElement.getStartOffset() + 1 + documentElement.getName().length();
                List list = documentElement.getChildren();
                int n2 = list.size() > 0 ? ((DocumentElement)list.get(0)).getStartOffset() - 1 : documentElement.getEndOffset() - 1;
                boolean bl = !documentElement.getAttributes().isDefined("id");
                BaseDocument baseDocument = SVGFileModel.this.getDoc();
                String string4 = baseDocument.getText(n, n2 - n + 1);
                int n3 = string4.indexOf(string2);
                if (n3 != -1) {
                    n3 += string2.length();
                    while (++n3 < string4.length()) {
                        if (string4.charAt(n3) != '\"') continue;
                        int n4 = n3;
                        while (++n4 < string4.length()) {
                            if (string4.charAt(n4) != '\"') continue;
                            ++n3;
                            if (bl) {
                                StringBuilder stringBuilder = new StringBuilder(string3);
                                stringBuilder.append("\" ");
                                SVGFileModel.injectId(stringBuilder, string);
                                baseDocument.replace(n + n3, n4 - n3 + 1, stringBuilder.toString(), null);
                            } else {
                                baseDocument.replace(n + n3, n4 - n3, string3, null);
                            }
                            return;
                        }
                    }
                    SceneManager.log(Level.SEVERE, "Attribute " + string2 + " not changed: \"" + string4 + "\"");
                } else {
                    StringBuilder stringBuilder = new StringBuilder(" ");
                    if (bl) {
                        SVGFileModel.injectId(stringBuilder, string);
                    }
                    stringBuilder.append(string2);
                    stringBuilder.append("=\"");
                    stringBuilder.append(string3);
                    stringBuilder.append("\" ");
                    baseDocument.insertString(n, stringBuilder.toString(), null);
                }
            }
        });
    }

    public void moveToBottom(final String string) {
        this.runTransaction(new FileModelTransaction(){

            protected void transaction() throws BadLocationException {
                DocumentElement documentElement;
                DocumentElement documentElement2 = SVGFileModel.this.checkIntegrity(string);
                if (documentElement2 != (documentElement = SVGFileModel.getFirstTagChild(documentElement2.getParentElement().getChildren()))) {
                    BaseDocument baseDocument = SVGFileModel.this.getDoc();
                    int n = documentElement2.getStartOffset();
                    int n2 = documentElement2.getEndOffset() - n + 1;
                    String string2 = SVGFileModel.getElemTextWithId(baseDocument, documentElement2, string);
                    int n3 = documentElement.getStartOffset();
                    assert (n3 < n) : "Offset overlap #1" + n3 + "," + n;
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n3, string2, null);
                }
            }
        });
    }

    public void moveToTop(final String string) {
        this.runTransaction(new FileModelTransaction(){

            protected void transaction() throws BadLocationException {
                DocumentElement documentElement;
                DocumentElement documentElement2 = SVGFileModel.this.checkIntegrity(string);
                if (documentElement2 != (documentElement = SVGFileModel.getLastTagChild(documentElement2.getParentElement().getChildren()))) {
                    BaseDocument baseDocument = SVGFileModel.this.getDoc();
                    int n = documentElement2.getStartOffset();
                    int n2 = documentElement2.getEndOffset() - n + 1;
                    String string2 = SVGFileModel.getElemTextWithId(baseDocument, documentElement2, string);
                    int n3 = documentElement.getEndOffset() + 1;
                    assert (n < n3) : "Offset overlap #2" + n3 + "," + n;
                    baseDocument.insertString(n3, string2, null);
                    baseDocument.remove(n, n2);
                }
            }
        });
    }

    public void moveForward(final String string) {
        this.runTransaction(new FileModelTransaction(){

            protected void transaction() throws BadLocationException {
                DocumentElement documentElement = SVGFileModel.this.checkIntegrity(string);
                DocumentElement documentElement2 = SVGFileModel.getNextTagSibling(documentElement);
                if (documentElement2 != null) {
                    BaseDocument baseDocument = SVGFileModel.this.getDoc();
                    int n = documentElement.getStartOffset();
                    int n2 = documentElement.getEndOffset() - n + 1;
                    String string2 = SVGFileModel.getElemTextWithId(baseDocument, documentElement, string);
                    int n3 = documentElement2.getEndOffset() + 1;
                    assert (n < n3) : "Offset overlap #3" + n3 + "," + n;
                    baseDocument.insertString(n3, string2, null);
                    baseDocument.remove(n, n2);
                }
            }
        });
    }

    public void moveBackward(final String string) {
        this.runTransaction(new FileModelTransaction(){

            protected void transaction() throws BadLocationException {
                DocumentElement documentElement = SVGFileModel.this.checkIntegrity(string);
                DocumentElement documentElement2 = SVGFileModel.getPreviousTagSibling(documentElement);
                if (documentElement2 != null) {
                    BaseDocument baseDocument = SVGFileModel.this.getDoc();
                    int n = documentElement.getStartOffset();
                    int n2 = documentElement.getEndOffset() - n + 1;
                    String string2 = SVGFileModel.getElemTextWithId(baseDocument, documentElement, string);
                    int n3 = documentElement2.getStartOffset();
                    assert (n > n3) : "Offset overlap #4" + n3 + "," + n;
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n3, string2, null);
                }
            }
        });
    }

    public static DocumentElement getSVGRoot(DocumentModel documentModel) {
        DocumentElement documentElement = documentModel.getRootElement();
        for (DocumentElement documentElement2 : documentElement.getChildren()) {
            if (!SVGFileModel.isTagElement(documentElement2) || !"svg".equals(documentElement2.getName())) continue;
            return documentElement2;
        }
        return null;
    }

    protected synchronized void fireModelChange() {
        if (!this.m_eventInProgress) {
            SwingUtilities.invokeLater(this.m_updateTask);
        }
    }

    public void runTransaction(final FileModelTransaction fileModelTransaction) {
        new Thread("TransactionWrapper"){

            public void run() {
                fileModelTransaction.run();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateModel() {
        SceneManager.log(Level.FINE, "Updating model...");
        this.checkModel();
        assert (!SwingUtilities.isEventDispatchThread()) : "Model update cannot be called in AWT thread.";
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_sourceChanged) {
                SceneManager.log(Level.FINE, "Forcing model update");
                this.m_model.forceUpdate();
            } else if (!this.m_updateInProgress) {
                SceneManager.log(Level.FINE, "Model already up to date.");
                return;
            }
            while (this.m_sourceChanged || this.m_updateInProgress) {
                SceneManager.log(Level.FINE, "Waiting for model update...");
                try {
                    this.m_lock.wait();
                    SceneManager.log(Level.FINE, "Wait ended.");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        SceneManager.log(Level.FINE, "Model update completed.");
    }

    public String getSVGBody(File file, StringBuilder stringBuilder) throws FileNotFoundException, IOException, DocumentModelException, DocumentModelException, BadLocationException {
        DocumentModel documentModel = SVGFileModel.loadDocumentModel(file);
        String string = file.getName();
        String string2 = this.createUniqueId(string.replace('.', '_'), true);
        String string3 = this.getWithUniqueIds(documentModel, string2, true, null, true);
        string3 = SVGFileModel.wrapText(string2, string3);
        if (stringBuilder != null) {
            stringBuilder.insert(0, string2);
        }
        return string3;
    }

    public String mergeImage(File file) throws FileNotFoundException, IOException, DocumentModelException, BadLocationException {
        SceneManager.log(Level.INFO, "Merging file " + file.getPath());
        StringBuilder stringBuilder = new StringBuilder();
        this.appendElement(this.getSVGBody(file, stringBuilder));
        return stringBuilder.toString();
    }

    public String mergeImage(String string, boolean bl) throws IOException, DocumentModelException, BadLocationException {
        EncodingInputStream encodingInputStream = new EncodingInputStream(string, "UTF-8");
        return this.mergeImage(SVGFileModel.loadDocumentModel(encodingInputStream), bl);
    }

    protected String mergeImage(DocumentModel documentModel, boolean bl) throws BadLocationException {
        String string = null;
        String string2 = null;
        if (bl) {
            string = this.createUniqueId("", true);
            string2 = this.getWithUniqueIds(documentModel, string, false, null, true);
            string2 = SVGFileModel.wrapText(string, string2);
        } else {
            String[] stringArray = new String[1];
            string2 = this.getWithUniqueIds(documentModel, string, false, stringArray, false);
            string = stringArray[0];
        }
        this.appendElement(string2);
        return string;
    }

    protected String getWithUniqueIds(DocumentModel documentModel, String string, boolean bl, String[] stringArray, boolean bl2) throws BadLocationException {
        return this.getWithUniqueIds(documentModel, string, bl, stringArray, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getWithUniqueIds(DocumentModel documentModel, String string, boolean bl, String[] stringArray, boolean bl2, boolean bl3) throws BadLocationException {
        try {
            List list;
            DocumentElement documentElement;
            documentModel.readLock();
            DocumentElement documentElement2 = bl ? SVGFileModel.getSVGRoot(documentModel) : documentModel.getRootElement();
            Document document = documentModel.getDocument();
            Object object = null;
            if (documentElement2 != null && (documentElement = SVGFileModel.getFirstTagChild(list = documentElement2.getChildren())) != null) {
                Object object2;
                int n = documentElement.getStartOffset();
                int n2 = SVGFileModel.getLastTagChild(list).getEndOffset();
                if (stringArray != null) {
                    stringArray[0] = SVGFileModel.getIdAttribute(documentElement);
                }
                HashSet<String> hashSet = new HashSet<String>();
                ArrayList<String> arrayList = new ArrayList<String>();
                StringBuilder stringBuilder = new StringBuilder();
                this.m_mapping.collectConflictingElements(documentElement2, arrayList, hashSet);
                if (!arrayList.isEmpty()) {
                    Object object3;
                    int n3 = document.getLength();
                    StringBuilder stringBuilder2 = new StringBuilder(document.getText(0, n3));
                    object2 = new ArrayList();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object3 = (String)arrayList.get(i);
                        String string2 = string != null ? this.m_mapping.generateId(string + '_' + (String)object3, false, hashSet) : this.m_mapping.generateId((String)object3, false, hashSet);
                        this.appendToConflictMsg(stringBuilder, (String)object3, string2, i, bl3);
                        hashSet.add(string2);
                        if (stringArray != null && ((String)object3).equals(stringArray[0])) {
                            stringArray[0] = string2;
                        }
                        SVGFileModel.resolveChanges(stringBuilder2, documentElement2, (String)object3, string2, (List<ChangeDescriptor>)object2);
                    }
                    Collections.sort(object2);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object3 = (ChangeDescriptor)iterator.next();
                        ((ChangeDescriptor)object3).replace(stringBuilder2);
                    }
                    object = stringBuilder2.substring(n, n2 + (stringBuilder2.length() - n3) + 1);
                    this.notifyAboutConflictIds(stringBuilder, bl3);
                } else {
                    object = document.getText(n, n2 - n + 1);
                }
                if (!bl2 && SVGFileModel.getIdAttribute(documentElement) == null && SVGFileModel.getTagChildCount(list) == 1) {
                    String string3 = '<' + documentElement.getName() + ' ';
                    int n4 = ((String)object).indexOf(string3);
                    if (n4 != -1) {
                        object2 = this.m_mapping.generateId("", false, hashSet);
                        object = ((String)object).substring(0, n4 += string3.length()) + SVGFileModel.injectId(new StringBuilder(), (String)object2).toString() + ((String)object).substring(n4);
                        if (stringArray != null) {
                            stringArray[0] = object2;
                        }
                    } else {
                        SceneManager.log(Level.SEVERE, "Could not inject id into:\n" + (String)object);
                    }
                }
            }
            list = object;
            return list;
        }
        finally {
            documentModel.readUnlock();
        }
    }

    private void appendToConflictMsg(StringBuilder stringBuilder, String string, String string2, int n, boolean bl) {
        if (bl) {
            return;
        }
        if (n < 10) {
            stringBuilder.append("\t'");
            stringBuilder.append(string).append("' -> '").append(string2);
            stringBuilder.append("'\n");
        } else if (n == 10) {
            stringBuilder.append("\t...\n");
        }
    }

    private void notifyAboutConflictIds(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            return;
        }
        String string = NbBundle.getMessage(ElementMapping.class, (String)"WARNING_IDConflicts", (Object)stringBuilder.toString());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
    }

    protected static String wrapText(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<g id=\"");
        stringBuilder.append(string);
        stringBuilder.append("\">\n");
        stringBuilder.append(string2);
        stringBuilder.append("\n</g>");
        return stringBuilder.toString();
    }

    private static boolean isElementIdChar(char c, boolean bl) {
        return (!bl || c != '.') && PerseusController.isElementIdChar(c);
    }

    private static int indexOf(CharSequence charSequence, String string, int n, int n2) {
        assert (n2 <= charSequence.length()) : "Index out of bounds: " + n2 + " > " + charSequence.length();
        int n3 = n;
        int n4 = string.length();
        if (n4 > 0) {
            block0: while (n3 < n2) {
                int n5 = 0;
                while (charSequence.charAt(n3++) == string.charAt(n5++)) {
                    if (n5 == n4) {
                        return n3 - n5;
                    }
                    if (n3 <= n2) continue;
                    break block0;
                }
            }
        }
        return -1;
    }

    public static void resolveChanges(CharSequence charSequence, DocumentElement documentElement, String string, String string2, List<ChangeDescriptor> list) {
        AttributeSet attributeSet = documentElement.getAttributes();
        List list2 = documentElement.getChildren();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)attributeSet.getAttribute(string3);
            if (string4 == null || string4.length() <= 0 || (n2 = string4.indexOf(string)) == -1 || n2 != 0 && SVGFileModel.isElementIdChar(string4.charAt(n2 - 1), false) || (n = n2 + string.length()) < string4.length() && SVGFileModel.isElementIdChar(string4.charAt(n), true)) continue;
            int n3 = documentElement.getStartOffset();
            int n4 = list2.isEmpty() ? documentElement.getEndOffset() : ((DocumentElement)list2.get(0)).getStartOffset();
            n = SVGFileModel.indexOf(charSequence, string3, n3, n4);
            if (n != -1 && (n = SVGFileModel.indexOf(charSequence, string, n + string3.length(), n4)) != -1) {
                list.add(new ChangeDescriptor(n, string.length(), string2, documentElement));
                continue;
            }
            SceneManager.log(Level.INFO, "Attribute value " + string4 + " not found at the DE " + documentElement);
        }
        for (String string3 : list2) {
            if (!SVGFileModel.isTagElement((DocumentElement)string3)) continue;
            SVGFileModel.resolveChanges(charSequence, (DocumentElement)string3, string, string2, list);
        }
    }

    private static List<String> collectIds(DocumentElement documentElement, List<String> list) {
        String string = SVGFileModel.getIdAttribute(documentElement);
        if (string != null) {
            list.add(string);
        }
        List list2 = documentElement.getChildren();
        for (DocumentElement documentElement2 : list2) {
            if (!SVGFileModel.isTagElement(documentElement2)) continue;
            SVGFileModel.collectIds(documentElement2, list);
        }
        return list;
    }

    public static DocumentModel loadDocumentModel(File file) throws FileNotFoundException, IOException, DocumentModelException {
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        String string = file.getName();
        int n = string.indexOf(46);
        if (n != -1 && SVGDataObject.isSVGZ(string.substring(n + 1))) {
            bufferedInputStream = new BufferedInputStream(new GZIPInputStream(bufferedInputStream));
        }
        return SVGFileModel.loadDocumentModel(bufferedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DocumentModel loadDocumentModel(InputStream inputStream) throws IOException, DocumentModelException {
        EditorKit editorKit = JEditorPane.createEditorKitForContentType("image/svg+xml");
        BaseDocument baseDocument = (BaseDocument)editorKit.createDefaultDocument();
        try {
            editorKit.read(inputStream, (Document)baseDocument, 0);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            inputStream.close();
        }
        DocumentModel documentModel = DocumentModel.getDocumentModel((Document)baseDocument);
        return documentModel;
    }

    private static DocumentElement getFirstTagChild(List<DocumentElement> list) {
        for (DocumentElement documentElement : list) {
            if (!SVGFileModel.isTagElement(documentElement)) continue;
            return documentElement;
        }
        return null;
    }

    private static DocumentElement getLastTagChild(List<DocumentElement> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            DocumentElement documentElement = list.get(i);
            if (!SVGFileModel.isTagElement(documentElement)) continue;
            return documentElement;
        }
        return null;
    }

    private static DocumentElement getLastVisibleTagChild(List<DocumentElement> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            DocumentElement documentElement = list.get(i);
            if (!SVGFileModel.isTagElement(documentElement) || SVGFileModel.isHiddenElement(documentElement)) continue;
            return documentElement;
        }
        return null;
    }

    private static int getTagChildCount(List<DocumentElement> list) {
        int n = 0;
        for (DocumentElement documentElement : list) {
            if (!SVGFileModel.isTagElement(documentElement)) continue;
            ++n;
        }
        return n;
    }

    private static DocumentElement getPreviousTagSibling(DocumentElement documentElement) {
        DocumentElement documentElement2 = documentElement.getParentElement();
        DocumentElement documentElement3 = null;
        assert (documentElement2 != null);
        for (DocumentElement documentElement4 : documentElement2.getChildren()) {
            if (documentElement4 == documentElement) {
                return documentElement3;
            }
            if (!SVGFileModel.isTagElement(documentElement4)) continue;
            documentElement3 = documentElement4;
        }
        assert (false) : "The document element " + documentElement + " is no longer part of the document";
        return null;
    }

    private static DocumentElement getNextTagSibling(DocumentElement documentElement) {
        DocumentElement documentElement2 = documentElement.getParentElement();
        DocumentElement documentElement3 = null;
        assert (documentElement2 != null);
        List list = documentElement2.getChildren();
        for (int i = list.size() - 1; i >= 0; --i) {
            DocumentElement documentElement4 = (DocumentElement)list.get(i);
            if (documentElement4 == documentElement) {
                return documentElement3;
            }
            if (!SVGFileModel.isTagElement(documentElement4)) continue;
            documentElement3 = documentElement4;
        }
        assert (false) : "The document element " + documentElement + " is no longer part of the document";
        return null;
    }

    private void checkIntegrity(DocumentElement documentElement) {
        this.checkModel();
        assert (documentElement != null);
        assert (documentElement.getDocument() == this.getDoc()) : "Element is not part of the current document";
        assert (documentElement.getDocumentModel() == this.m_model) : "Element is not part of the current document model";
        if (SVGFileModel.isTagElement(documentElement) && documentElement.getEndOffset() <= documentElement.getStartOffset()) {
            System.out.println("ERROR: Empy tag element: " + documentElement);
        }
    }

    private DocumentElement checkIntegrity(String string) {
        DocumentElement documentElement = this.getElementById(string);
        assert (documentElement != null) : "No element with id: " + string;
        this.checkIntegrity(documentElement);
        return documentElement;
    }

    public static final class ChangeDescriptor
    implements Comparable {
        private final int m_startOffset;
        private final int m_length;
        private final String m_newValue;
        private final DocumentElement m_elem;

        public ChangeDescriptor(int n, int n2, String string, DocumentElement documentElement) {
            this.m_startOffset = n;
            this.m_length = n2;
            this.m_newValue = string;
            this.m_elem = documentElement;
        }

        public ChangeDescriptor(int n, int n2, String string) {
            this(n, n2, string, null);
        }

        public void replace(StringBuilder stringBuilder) {
            stringBuilder.replace(this.m_startOffset, this.m_startOffset + this.m_length, this.m_newValue);
        }

        public int compareTo(Object object) {
            return ((ChangeDescriptor)object).m_startOffset - this.m_startOffset;
        }

        public boolean equals(Object object) {
            return ((ChangeDescriptor)object).m_startOffset == this.m_startOffset;
        }
    }

    public abstract class FileModelTransaction
    implements Runnable {
        private final boolean m_fireUpdate;

        public FileModelTransaction(boolean bl) {
            this.m_fireUpdate = bl;
        }

        public FileModelTransaction() {
            this(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SceneManager.log(Level.FINE, "Starting transaction...");
            if (SVGFileModel.this.incrementTransactionCounter() == 1) {
                SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.TRANSACTION_TOKEN, true);
            }
            Object object = SVGFileModel.this.getTransactionMonitor();
            synchronized (object) {
                SceneManager.log(Level.FINE, "Transaction started.");
                try {
                    SVGFileModel.this.updateModel();
                    SVGFileModel.this.getDoc().getFormatter().reformatLock();
                    SVGFileModel.this.getDoc().atomicLock();
                    SVGFileModel.this.m_model.readLock();
                    this.transaction();
                }
                catch (Exception exception) {
                    SceneManager.error("Transaction failed.", exception);
                    SVGFileModel.this.getDoc().atomicUndo();
                }
                finally {
                    SVGFileModel.this.m_model.readUnlock();
                    SVGFileModel.this.getDoc().atomicUnlock();
                    SVGFileModel.this.getDoc().getFormatter().reformatUnlock();
                    SceneManager.log(Level.FINE, "Transaction completed.");
                    if (SVGFileModel.this.decrementTransactionCounter() == 0) {
                        SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.TRANSACTION_TOKEN, false);
                    }
                }
            }
            if (this.m_fireUpdate) {
                SVGFileModel.this.getDataObject().fireContentChanged();
            } else {
                SVGFileModel.this.m_model.forceUpdate();
            }
        }

        protected abstract void transaction() throws Exception;
    }

    public static interface TransactionCommand {
        public Object execute(Object var1);
    }

    public static interface ModelListener {
        public void modelChanged();
    }
}

