/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public abstract class AbstractSVGAction
extends AbstractAction
implements Presenter.Popup {
    public static final String ICON_PATH_PREFIX = "org/netbeans/modules/mobility/svgcore/resources/";
    public static final String LBL_ID_PREFIX = "LBL_";
    public static final String ICON_ID_PREFIX = "ICON_";
    public static final String HINT_ID_PREFIX = "HINT_";
    public static final String KEY_ID_PREFIX = "KEY_";
    protected final String m_name;
    protected final String m_label;
    protected final String m_hint;
    protected final ImageIcon m_icon;
    protected final int m_toolbarPos;

    public AbstractSVGAction(String string) {
        this(string, true);
    }

    public AbstractSVGAction(String string, boolean bl) {
        this(string, bl, 100);
    }

    public AbstractSVGAction(String string, boolean bl, int n) {
        String string2;
        this.m_name = string;
        this.m_label = AbstractSVGAction.getMessage(LBL_ID_PREFIX + string);
        this.m_icon = AbstractSVGAction.getIcon(ICON_ID_PREFIX + string);
        this.setIcon(this.m_icon);
        try {
            string2 = AbstractSVGAction.getMessage(HINT_ID_PREFIX + string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = this.m_label;
        }
        this.m_hint = string2;
        try {
            String string3 = AbstractSVGAction.getCleanMessage(KEY_ID_PREFIX + string);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(string3);
            assert (keyStroke != null) : "Invalid key stroke: " + string;
            this.putValue("AcceleratorKey", keyStroke);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.setDescription(string2);
        this.setEnabled(bl);
        this.m_toolbarPos = n;
    }

    protected final void setIcon(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.putValue("SmallIcon", imageIcon);
        }
    }

    protected final void setDescription(String string) {
        KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
        if (keyStroke != null) {
            string = string + " (";
            String string2 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
            if (string2.length() > 0) {
                string = string + string2 + "+";
            }
            string = string + KeyEvent.getKeyText(keyStroke.getKeyCode()) + ")";
        }
        this.putValue("ShortDescription", string);
    }

    public String getActionID() {
        return this.m_name;
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem jMenuItem = new JMenuItem(this);
        jMenuItem.setText(this.getLabel());
        jMenuItem.setToolTipText(null);
        jMenuItem.setIcon(null);
        return jMenuItem;
    }

    public int getPositionInToolbar() {
        return this.m_toolbarPos;
    }

    public void registerAction(TopComponent topComponent) {
        KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
        if (keyStroke != null) {
            InputMap inputMap = topComponent.getInputMap(1);
            inputMap.put(keyStroke, this.m_name);
            topComponent.getActionMap().put(this.m_name, this);
        }
    }

    protected String getLabel() {
        return this.m_label;
    }

    public static String getMessage(String string) {
        return NbBundle.getMessage(SVGViewTopComponent.class, (String)string);
    }

    public static String getCleanMessage(String string) {
        int n;
        int n2;
        String string2 = AbstractSVGAction.getMessage(string);
        if (string2 != null && string2.length() > 0 && (n2 = string2.lastIndexOf(40)) != -1 && (n = string2.indexOf(41, n2)) != -1) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.delete(n2, n + 1);
            string2 = stringBuilder.toString().trim();
        }
        return string2;
    }

    public static ImageIcon getIcon(String string) {
        try {
            String string2 = AbstractSVGAction.getCleanMessage(string).trim();
            String string3 = ICON_PATH_PREFIX + string2;
            Image image = ImageUtilities.loadImage((String)string3);
            assert (image != null) : "Icon not found: " + string3;
            return new ImageIcon(image);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

