/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.netbeans.modules.glassfish.eecommon.api.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.nodes.ManagerNode;
import org.netbeans.modules.reglib.BrowserSupport;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.ServiceTag;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegisterAction
extends CookieAction {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.j2ee.sun.ide.runtime.actions.RegisterAction");
    private static final RequestProcessor RP = new RequestProcessor("GlassFish Registration RP");

    protected Class[] cookieClasses() {
        return new Class[0];
    }

    protected int mode() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        ManagerNode managerNode = (ManagerNode)((Object)nodeArray[0].getLookup().lookup(ManagerNode.class));
        if (managerNode == null) return;
        InputStream inputStream = null;
        File file = managerNode.getDeploymentManager().getPlatformRoot();
        File file2 = new File(file, "lib" + File.separator + "registration" + File.separator + "servicetag-registry.xml");
        RepositoryReader repositoryReader = new RepositoryReader(file2);
        List<RepositoryServiceTag> list = repositoryReader.getRepositoryServiceTags();
        RegistrationData registrationData = new RegistrationData();
        for (RepositoryServiceTag repositoryServiceTag : list) {
            ServiceTag serviceTag = ServiceTag.newInstance((String)repositoryServiceTag.getInstanceURN(), (String)repositoryServiceTag.getProductName(), (String)repositoryServiceTag.getProductVersion(), (String)repositoryServiceTag.getProductURN(), (String)repositoryServiceTag.getProductParent(), (String)repositoryServiceTag.getProductParentURN(), (String)repositoryServiceTag.getProductDefinedInstID(), (String)repositoryServiceTag.getProductVendor(), (String)repositoryServiceTag.getPlatformArch(), (String)repositoryServiceTag.getContainer(), (String)repositoryServiceTag.getSource());
            registrationData.addServiceTag(serviceTag);
        }
        RegisterAction.register(registrationData, "nb", file2);
        Object var13_17 = null;
        if (null == inputStream) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (ParserConfigurationException parserConfigurationException) {
                Exceptions.printStackTrace((Throwable)parserConfigurationException);
                Object var13_18 = null;
                if (null == inputStream) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                Exceptions.printStackTrace((Throwable)transformerConfigurationException);
                Object var13_19 = null;
                if (null == inputStream) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
                Object var13_20 = null;
                if (null == inputStream) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
                Object var13_21 = null;
                if (null == inputStream) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                Object var13_22 = null;
                if (null == inputStream) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            if (null == inputStream) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getName() {
        return NbBundle.getMessage(RegisterAction.class, (String)"LBL_RegisterAction");
    }

    protected String iconResource() {
        return "org/netbeans/modules/j2ee/sun/ide/resources/jms.gif";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void updateGFRegistrationStatus(File file) {
        block20: {
            PrintWriter printWriter;
            FileInputStream fileInputStream;
            block18: {
                if (!file.canWrite()) {
                    return;
                }
                LOG.log(Level.INFO, "Update file: " + file);
                fileInputStream = null;
                printWriter = null;
                fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                File file2 = File.createTempFile("nbt", null, file.getParentFile());
                printWriter = new PrintWriter(file2, "UTF-8");
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2 = string;
                    if (string.contains("NOT_REGISTERED")) {
                        string2 = string.replace("NOT_REGISTERED", "REGISTERED");
                    } else if (string.contains("ASK_FOR_REGISTRATION")) {
                        string2 = string.replace("ASK_FOR_REGISTRATION", "DONT_ASK_FOR_REGISTRATION");
                    }
                    printWriter.println(string2);
                }
                printWriter.flush();
                file.delete();
                boolean bl = file2.renameTo(file);
                LOG.log(Level.FINE, "Did rename succeed: " + bl);
                Object var8_9 = null;
                if (null == fileInputStream) break block18;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != printWriter) {
                printWriter.close();
            }
            break block20;
            {
                catch (IOException iOException) {
                    LOG.log(Level.INFO, "Cannot update: " + file, iOException);
                    Object var8_10 = null;
                    if (null != fileInputStream) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    if (null != printWriter) {
                        printWriter.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (null != fileInputStream) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (null != printWriter) {
                    printWriter.close();
                }
                throw throwable;
            }
        }
    }

    static void register(final RegistrationData registrationData, final String string, final File file) {
        RP.post(new Runnable(){

            public void run() {
                LOG.log(Level.FINE, "Product registration");
                URL uRL = NbConnectionSupport.getRegistrationURL((String)registrationData.getRegistrationURN(), (String)string);
                LOG.log(Level.FINE, "POST registration data to:" + uRL);
                boolean bl = NbConnectionSupport.postRegistrationData((URL)uRL, (RegistrationData)registrationData);
                if (bl) {
                    LOG.log(Level.FINE, "Open browser with:" + uRL);
                    try {
                        RegisterAction.updateGFRegistrationStatus(file);
                        RegisterAction.openBrowser(uRL);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, "Error: Cannot open browser", iOException);
                    }
                }
            }
        });
    }

    private static void openBrowser(URL uRL) throws IOException {
        if (BrowserSupport.isSupported()) {
            try {
                BrowserSupport.browse((URI)uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                InternalError internalError = new InternalError("Error in registering: " + uRISyntaxException.getMessage());
                internalError.initCause(uRISyntaxException);
                throw internalError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.log(Level.FINE, "Cannot open browser:", illegalArgumentException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOG.log(Level.FINE, "Cannot open browser:", unsupportedOperationException);
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
    }

    static class RepositoryServiceTag {
        private Element tagData;
        private String instanceURN;
        private String productName;
        private String productVersion;
        private String productURN;
        private String productParentURN;
        private String productDefinedInstID;
        private String productVendor;
        private String container;
        private String source;
        private String platformArch;
        private String productParent;
        public static final String PRODUCT_NAME = "product_name";
        public static final String PRODUCT_VERSION = "product_version";
        public static final String PRODUCT_URN = "product_urn";
        public static final String PRODUCT_PARENT_URN = "product_parent_urn";
        public static final String PRODUCT_PARENT = "product_parent";
        public static final String PRODUCT_DEFINED_INST_ID = "product_defined_inst_id";
        public static final String PLATFORM_ARCH = "platform_arch";
        public static final String CONTAINER = "container";
        public static final String SOURCE = "source";
        public static final String INSTANCE_URN = "instance_urn";
        public static final String PRODUCT_VENDOR = "product_vendor";
        public static final String STATUS = "status";
        public static final String REGISTRATION_STATUS = "registration_status";
        public static final String SERVICE_TAG = "service_tag";
        private final int MAX_URN_LEN = 255;
        private final int MAX_PRODUCT_NAME_LEN = 255;
        private final int MAX_PRODUCT_VERSION_LEN = 63;
        private final int MAX_PRODUCT_PARENT_LEN = 255;
        private final int MAX_PRODUCT_VENDOR_LEN = 63;
        private final int MAX_PLATFORM_ARCH_LEN = 63;
        private final int MAX_CONTAINER_LEN = 63;
        private final int MAX_SOURCE_LEN = 63;

        public RepositoryServiceTag(Element element) {
            this.instanceURN = this.getValue(element, INSTANCE_URN);
            this.tagData = element;
            if (this.instanceURN == null) {
                this.instanceURN = "urn:st:" + UUID.randomUUID().toString();
            }
            this.productName = this.getValue(element, PRODUCT_NAME);
            this.productVersion = this.getValue(element, PRODUCT_VERSION);
            this.productURN = this.getValue(element, PRODUCT_URN);
            this.productParentURN = this.getValue(element, PRODUCT_PARENT_URN);
            this.productParent = this.getValue(element, PRODUCT_PARENT);
            this.productDefinedInstID = this.getValue(element, PRODUCT_DEFINED_INST_ID);
            this.platformArch = this.getValue(element, PLATFORM_ARCH);
            this.productVendor = this.getValue(element, PRODUCT_VENDOR);
            this.container = this.getValue(element, CONTAINER);
            this.source = this.getValue(element, SOURCE);
        }

        private String getValue(Element element, String string) {
            NodeList nodeList = element.getElementsByTagName(string);
            if (nodeList.getLength() > 0) {
                return ((Element)nodeList.item(0)).getTextContent();
            }
            return null;
        }

        public String getInstanceURN() {
            return Utils.truncate((String)this.instanceURN, (int)255);
        }

        public String getProductName() {
            return Utils.truncate((String)this.productName, (int)255);
        }

        public String getProductURN() {
            return Utils.truncate((String)this.productURN, (int)255);
        }

        public String getProductVersion() {
            return Utils.truncate((String)this.productVersion, (int)63);
        }

        public String getProductParentURN() {
            return Utils.truncate((String)this.productParentURN, (int)255);
        }

        public String getProductDefinedInstID() {
            return Utils.truncate((String)this.productDefinedInstID, (int)255);
        }

        public String getContainer() {
            return Utils.truncate((String)this.container, (int)63);
        }

        public String getSource() {
            return Utils.truncate((String)this.source, (int)63);
        }

        public String getProductVendor() {
            return Utils.truncate((String)this.productVendor, (int)63);
        }

        public String getPlatformArch() {
            if (this.platformArch == null || this.platformArch.length() == 0) {
                this.platformArch = System.getProperty("os.arch");
            }
            return Utils.truncate((String)this.platformArch, (int)63);
        }

        public String getProductParent() {
            return Utils.truncate((String)this.productParent, (int)255);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RepositoryReader {
        private static final String REGISTRATION_REMINDER_TAG = "registration_reminder";
        private static final String REGISTRY_TAG = "registry";
        private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        private DocumentBuilder documentBuilder;
        private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
        private Transformer transformer;
        private File registrationFile = null;
        private Document document = null;
        private Element registryElement = null;

        public RepositoryReader(File file) throws ParserConfigurationException, TransformerConfigurationException, SAXException, IOException {
            this.registrationFile = file;
            try {
                LOG.fine("RepositoryReader created for file " + file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            this.transformer = this.transformerFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            this.loadOrCreateDocument();
        }

        public List<RepositoryServiceTag> getRepositoryServiceTags() {
            ArrayList<RepositoryServiceTag> arrayList = new ArrayList<RepositoryServiceTag>();
            if (this.document != null) {
                NodeList nodeList = this.document.getElementsByTagName("service_tag");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    arrayList.add(new RepositoryServiceTag(element));
                }
            }
            return arrayList;
        }

        public String getInstanceURN(String string) {
            NodeList nodeList = this.document.getElementsByTagName("service_tag");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string2 = this.getSubElementValue(element, "product_urn");
                if (!string.equals(string2)) continue;
                return this.getSubElementValue(element, "instance_urn");
            }
            return null;
        }

        private String getSubElementValue(Element element, String string) {
            NodeList nodeList = element.getElementsByTagName(string);
            if (nodeList.getLength() > 0) {
                return ((Element)nodeList.item(0)).getTextContent();
            }
            return null;
        }

        private synchronized void loadOrCreateDocument() throws SAXException, IOException {
            if (this.document == null && this.registrationFile.exists()) {
                this.document = this.documentBuilder.parse(this.registrationFile);
                this.registryElement = this.findRegistryElement();
            }
        }

        private Element findRegistryElement() {
            Element element = null;
            NodeList nodeList = this.document.getElementsByTagName(REGISTRY_TAG);
            if (nodeList.getLength() > 0) {
                element = (Element)nodeList.item(0);
            }
            return element;
        }
    }
}

