/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;

public class CallStackFrame {
    private final GdbDebugger debugger;
    private final int lineNumber;
    private final String func;
    private final String file;
    private final String fullname;
    private final int frameNumber;
    private final String address;
    private LocalVariable[] cachedLocalVariables = null;
    private Logger log = Logger.getLogger("gdb.logger");

    public CallStackFrame(GdbDebugger gdbDebugger, String string, String string2, String string3, String string4, String string5, int n) {
        this.debugger = gdbDebugger;
        this.func = string;
        this.file = string2;
        this.fullname = string3;
        this.address = string5;
        this.frameNumber = n;
        int n2 = -1;
        if (string4 != null) {
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
        } else {
            n2 = -1;
        }
        this.lineNumber = n2;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFunctionName() {
        return this.func;
    }

    public String getFileName() {
        return this.file;
    }

    public String getFullname() {
        return this.fullname == null ? null : this.debugger.getPathMap().getLocalPath(this.fullname);
    }

    public String getAddr() {
        return this.address;
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public void popFrame() {
        this.debugger.getGdbProxy().exec_finish();
    }

    public LocalVariable[] getLocalVariables() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        assert (!SwingUtilities.isEventDispatchThread());
        if (this.cachedLocalVariables == null) {
            List<GdbVariable> list = this.debugger.getLocalVariables();
            int n = list.size();
            LocalVariable[] localVariableArray = new LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                localVariableArray[i] = new AbstractVariable(list.get(i));
            }
            this.cachedLocalVariables = localVariableArray;
            return localVariableArray;
        }
        return this.cachedLocalVariables;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

