/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.IOManager;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class DebuggerOutput
extends LazyActionsManagerListener
implements PropertyChangeListener {
    private static Set managers = new HashSet();
    private GdbDebugger debugger;
    private IOManager ioManager;
    private ContextProvider contextProvider;

    public DebuggerOutput(ContextProvider contextProvider) {
        Object object;
        this.contextProvider = contextProvider;
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        if (DebuggerManager.getDebuggerManager().getSessions().length == 1) {
            object = managers.iterator();
            while (object.hasNext()) {
                ((IOManager)object.next()).close();
            }
            managers = new HashSet();
        }
        object = NbBundle.getBundle(IOManager.class).getString("CTL_DebuggerConsole_Title");
        this.ioManager = new IOManager((String)object);
        managers.add(this.ioManager);
        this.debugger.addPropertyChangeListener("state", this);
    }

    protected synchronized void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        this.debugger = null;
        this.ioManager = null;
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = this;
        synchronized (object) {
            if (this.debugger == null) {
                return;
            }
            string = this.debugger.getState();
        }
        if (string.equals("state_starting")) {
            this.print("CTL_Launching", new String[0], null);
        } else if (string.equals("state_running")) {
            this.print("CTL_Debugger_running", new String[0], null);
        } else if (string.equals("state_exited")) {
            this.print("CTL_Debugger_finished", new String[0], null);
        } else if (string.equals("state_none")) {
            this.print("CTL_Debugger_finished", null, null);
            if (this.ioManager != null) {
                this.ioManager.closeStream();
            }
        } else if (string.equals("state_stopped")) {
            object = this.debugger.getSignal();
            if (object != null) {
                this.print("CTL_Debugger_stopped_by_signal", new String[]{object}, null);
            } else {
                this.print("CTL_Debugger_stopped", new String[0], null);
            }
        }
    }

    public void actionPerformed(Object object, boolean bl) {
        if (bl) {
            if (object == ActionsManager.ACTION_CONTINUE) {
                this.print("CTL_Continue", null, null);
            } else if (object == ActionsManager.ACTION_STEP_INTO) {
                this.print("CTL_Step_Into", null, null);
            } else if (object == ActionsManager.ACTION_STEP_OUT) {
                this.print("CTL_Step_Out", null, null);
            } else if (object == ActionsManager.ACTION_STEP_OVER) {
                this.print("CTL_Step_Over", null, null);
            }
        }
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String string, String[] stringArray, IOManager.Line line) {
        IOManager iOManager;
        String string2 = stringArray == null ? NbBundle.getMessage(DebuggerOutput.class, (String)string) : new MessageFormat(NbBundle.getMessage(DebuggerOutput.class, (String)string)).format(stringArray);
        DebuggerOutput debuggerOutput = this;
        synchronized (debuggerOutput) {
            iOManager = this.ioManager;
            if (iOManager == null) {
                return;
            }
        }
        iOManager.println(string2, line);
    }
}

