/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BreakpointImpl
implements PropertyChangeListener {
    private static final String BPSTATE_UNVALIDATED = "BpState_Unvalidated";
    protected static final String BPSTATE_REVALIDATE = "BpState_Revalidate";
    private static final String BPSTATE_VALIDATION_PENDING = "BpState_ValidationPending";
    private static final String BPSTATE_VALIDATION_FAILED = "BpState_ValidationFailed";
    private static final String BPSTATE_VALIDATED = "BpState_Validated";
    private static final String BPSTATE_DELETION_PENDING = "BpState_DeletionPending";
    protected final GdbDebugger debugger;
    private final GdbBreakpoint breakpoint;
    private String state = "BpState_Unvalidated";
    private String err = null;
    private int breakpointNumber = -1;
    private boolean runWhenValidated = false;

    protected BreakpointImpl(GdbBreakpoint gdbBreakpoint, GdbDebugger gdbDebugger) {
        this.debugger = gdbDebugger;
        this.breakpoint = gdbBreakpoint;
    }

    public void completeValidation(Map<String, String> map) {
        String string;
        if (this.getState().equals(BPSTATE_DELETION_PENDING)) {
            return;
        }
        String string2 = string = map != null ? map.get("number") : null;
        if (string != null) {
            int n;
            String string3;
            this.breakpointNumber = Integer.parseInt(string);
            this.setState(BPSTATE_VALIDATED);
            if (!this.breakpoint.isEnabled()) {
                this.enable(false);
            }
            if ((string3 = this.breakpoint.getCondition()).length() > 0) {
                this.requestCondition(string3);
            }
            if ((n = this.breakpoint.getSkipCount()) > 0) {
                this.requestBreakAfter(n);
            }
            if (this instanceof FunctionBreakpointImpl) {
                try {
                    this.breakpoint.setURL(map.get("fullname"));
                    this.breakpoint.setLineNumber(Integer.parseInt(map.get("line")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.breakpoint.setValid();
            this.debugger.getBreakpointList().put(this.breakpointNumber, this);
        } else {
            this.breakpoint.setInvalid(this.err);
            this.setState(BPSTATE_VALIDATION_FAILED);
        }
    }

    public void addError(String string) {
        this.err = this.err != null ? this.err + string : string;
    }

    protected String getState() {
        return this.state;
    }

    protected void setState(String string) {
        if (!string.equals(this.state) && (string.equals(BPSTATE_UNVALIDATED) || string.equals(BPSTATE_REVALIDATE) || string.equals(BPSTATE_VALIDATION_PENDING) || string.equals(BPSTATE_VALIDATION_FAILED) || string.equals(BPSTATE_VALIDATED) || string.equals(BPSTATE_DELETION_PENDING))) {
            this.state = string;
            if (string.equals(BPSTATE_UNVALIDATED)) {
                this.breakpointNumber = -1;
            }
        }
    }

    final void set() {
        this.breakpoint.setDebugger(this.debugger);
        this.breakpoint.addPropertyChangeListener(this);
        this.update();
    }

    protected abstract String getBreakpointCommand();

    protected void setRequests() {
        String string = this.getState();
        if (this.debugger.getState().equals("state_running") && !string.equals(BPSTATE_REVALIDATE)) {
            this.debugger.setSilentStop();
            this.setRunWhenValidated(true);
        }
        if (string.equals(BPSTATE_UNVALIDATED) || string.equals(BPSTATE_REVALIDATE)) {
            if (string.equals(BPSTATE_REVALIDATE) && this.breakpointNumber > 0) {
                this.requestDelete();
            }
            this.setState(BPSTATE_VALIDATION_PENDING);
            int n = this.debugger.getGdbProxy().break_insert(this.getBreakpoint().getSuspend(), this.getBreakpoint().isTemporary(), this.getBreakpointCommand(), this.getBreakpoint().getThreadID());
            this.debugger.addPendingBreakpoint(n, this);
        } else if (this.breakpointNumber > 0) {
            if (string.equals(BPSTATE_DELETION_PENDING)) {
                this.requestDelete();
            } else if (string.equals(BPSTATE_VALIDATED)) {
                this.enable(this.getBreakpoint().isEnabled());
            }
            if (this.isRunWhenValidated()) {
                this.debugger.setRunning();
                this.setRunWhenValidated(false);
            }
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.debugger.getGdbProxy().break_enable(this.breakpointNumber);
        } else {
            this.debugger.getGdbProxy().break_disable(this.breakpointNumber);
        }
    }

    protected void suspend() {
        this.requestDelete();
        this.setState(BPSTATE_UNVALIDATED);
        this.setRequests();
    }

    void fixed() {
        this.update();
    }

    final void update() {
        if (!this.debugger.getState().equals("state_none")) {
            this.setRequests();
        }
    }

    protected final void setValidity(Breakpoint.VALIDITY vALIDITY, String string) {
        if (this.breakpoint instanceof ChangeListener) {
            ((ChangeListener)((Object)this.breakpoint)).stateChanged(new ValidityChangeEvent(vALIDITY, string));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("condition")) {
            this.requestCondition(propertyChangeEvent.getNewValue().toString());
        } else if (string.equals("skipCount")) {
            this.requestBreakAfter((Integer)propertyChangeEvent.getNewValue());
        } else if (string.equals("enabled")) {
            this.update();
        } else if (string.equals("suspend")) {
            this.suspend();
        } else if (string.equals("lineNumber") && this.getState().equals(BPSTATE_VALIDATED) && !(this.getBreakpoint() instanceof FunctionBreakpoint)) {
            this.setState(BPSTATE_REVALIDATE);
            this.update();
        } else if (string.equals("functionName") && this.getState().equals(BPSTATE_VALIDATED)) {
            this.setState(BPSTATE_REVALIDATE);
            this.update();
        } else if (string.equals("address") && this.getState().equals(BPSTATE_VALIDATED)) {
            this.setState(BPSTATE_REVALIDATE);
            this.update();
        }
    }

    private void requestCondition(String string) {
        this.debugger.getGdbProxy().break_condition(this.breakpointNumber, string);
    }

    private void requestBreakAfter(int n) {
        this.debugger.getGdbProxy().break_after(this.breakpointNumber, n);
    }

    private void requestDelete() {
        this.debugger.getGdbProxy().break_delete(this.breakpointNumber);
    }

    protected final void remove() {
        this.breakpoint.removePropertyChangeListener(this);
        this.setState(BPSTATE_DELETION_PENDING);
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
        if (this.breakpointNumber > 0) {
            this.debugger.getBreakpointList().remove(this.breakpointNumber);
        }
        this.update();
    }

    public GdbBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public void setRunWhenValidated(boolean bl) {
        this.runWhenValidated = bl;
    }

    public boolean isRunWhenValidated() {
        return this.runWhenValidated;
    }

    private static final class ValidityChangeEvent
    extends ChangeEvent {
        private String reason;

        public ValidityChangeEvent(Breakpoint.VALIDITY vALIDITY, String string) {
            super(vALIDITY);
            this.reason = string;
        }

        public String toString() {
            return this.reason;
        }
    }
}

