/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.Field;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.WatchesTreeModel;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.util.RequestProcessor;

public class GdbWatchVariable
extends AbstractVariable
implements PropertyChangeListener {
    private Watch watch;
    private WatchesTreeModel model;
    private long creationTime;
    private static Logger log = Logger.getLogger("gdb.logger.watches");

    public GdbWatchVariable(WatchesTreeModel watchesTreeModel, Watch watch) {
        this.model = watchesTreeModel;
        this.watch = watch;
        this.name = watch.getExpression();
        this.creationTime = System.currentTimeMillis();
        this.fields = new Field[0];
        this.type = null;
        this.value = null;
        this.ovalue = null;
        this.tinfo = null;
        this.derefValue = null;
        if (this.getDebugger() != null) {
            this.getDebugger().addPropertyChangeListener(this);
        }
        watch.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Watch getWatch() {
        return this.watch;
    }

    public void remove() {
        this.watch.remove();
        this.getDebugger().removePropertyChangeListener(this);
    }

    public boolean equals(Object object) {
        return object instanceof GdbWatchVariable && this.creationTime == ((GdbWatchVariable)object).creationTime && this.getFullName(true).equals(((GdbWatchVariable)object).getFullName(true));
    }

    public int hashCode() {
        return this.name.hashCode() + (int)(this.creationTime & 0xFFFFFFFFFFFFFFFFL);
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        log.fine("GWV.propertyChange: Property change for " + propertyChangeEvent.getPropertyName());
        final String string = propertyChangeEvent.getPropertyName();
        if (string.equals("currentThread") || string.equals("currentCallStackFrame") || string.equals("expression")) {
            final GdbWatchVariable gdbWatchVariable = this;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (string.equals("expression")) {
                        GdbWatchVariable.this.resetVariable();
                    }
                    GdbWatchVariable.this.type = GdbWatchVariable.this.getDebugger().requestWhatis(GdbWatchVariable.this.watch.getExpression());
                    if (GdbWatchVariable.this.type != null && GdbWatchVariable.this.type.length() > 0) {
                        GdbWatchVariable.this.value = GdbWatchVariable.this.getDebugger().evaluate(GdbWatchVariable.this.watch.getExpression());
                        String string2 = GdbWatchVariable.this.getTypeInfo().getResolvedType(gdbWatchVariable);
                        if (GdbUtils.isPointer(string2)) {
                            GdbWatchVariable.this.derefValue = GdbWatchVariable.this.getDebugger().evaluate('*' + GdbWatchVariable.this.watch.getExpression());
                        }
                    } else {
                        GdbWatchVariable.this.type = "";
                        GdbWatchVariable.this.value = "";
                    }
                    GdbWatchVariable.this.setModifiedValue(GdbWatchVariable.this.value);
                    GdbWatchVariable.this.model.fireTableValueChanged(propertyChangeEvent.getSource(), null);
                }
            });
        } else if (propertyChangeEvent.getPropertyName().equals("valueChanged")) {
            super.propertyChange(propertyChangeEvent);
        }
    }

    public String getName() {
        return this.watch.getExpression();
    }

    public String getType() {
        if (this.type == null || this.type.length() == 0) {
            this.type = this.getDebugger().requestWhatis(this.watch.getExpression());
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() {
        GdbWatchVariable gdbWatchVariable = this;
        synchronized (gdbWatchVariable) {
            if (this.value == null || this.value.length() == 0) {
                this.value = this.getDebugger().evaluate(this.watch.getExpression());
            }
        }
        return super.getValue();
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setValueAt(String string) {
        super.setValue(string);
    }
}

