/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.utils.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class MemoryViewTopComponent
extends TopComponent {
    private static MemoryViewTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/gdb/resources/memory.png";
    private static final String PREFERRED_ID = "MemoryViewTopComponent";
    private JPanel fakePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextArea taResult;
    private JTextField tfAddress;
    private JTextField tfLength;

    private MemoryViewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"CTL_MemoryViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"HINT_MemoryViewTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.taResult.setFont(new Font("Monospaced", 0, this.taResult.getFont().getSize()));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.taResult = new JTextArea();
        this.fakePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfAddress = new JTextField();
        this.jLabel2 = new JLabel();
        this.tfLength = new JTextField();
        this.taResult.setEditable(false);
        this.jScrollPane1.setViewportView(this.taResult);
        GroupLayout groupLayout = new GroupLayout((Container)this.fakePanel);
        this.fakePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 420, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 2, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.jLabel1.text"));
        this.tfAddress.setText(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.tfAddress.text"));
        this.tfAddress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoryViewTopComponent.this.tfAddressActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.jLabel2.text"));
        this.tfLength.setText(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.tfLength.text"));
        this.tfLength.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoryViewTopComponent.this.tfLengthActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.fakePanel, -1, -1, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.tfAddress, -2, 90, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.tfLength, -2, 90, -2).addContainerGap(95, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 432, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.fakePanel, -2, -1, -2).add(0, 0, 0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.tfLength, -2, 21, -2).add((Component)this.tfAddress, -2, 21, -2).add((Component)this.jLabel1)).add(2, 2, 2).add((Component)this.jScrollPane1, -1, 240, Short.MAX_VALUE)));
    }

    private void tfAddressActionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    private void tfLengthActionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    private void update() {
        int n;
        this.taResult.setText("");
        GdbProxy gdbProxy = GdbContext.getCurrentGdb();
        if (gdbProxy == null) {
            return;
        }
        CommandBuffer commandBuffer = new CommandBuffer(gdbProxy);
        String string = this.tfAddress.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = this.tfLength.getText();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n < 1) {
            return;
        }
        gdbProxy.data_read_memory(commandBuffer, string, (n - 1) / 16 + 1);
        String string3 = commandBuffer.waitForCompletion();
        if (commandBuffer.getState() == 4) {
            this.taResult.setText(commandBuffer.getError());
        } else {
            Map<String, String> map = GdbUtils.createMapFromString(string3);
            String string4 = map.get("memory");
            List<String> list = GdbUtils.createListOfValues(string4);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string5 : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                Map<String, String> map2 = GdbUtils.createMapFromString(string5);
                stringBuilder.append(map2.get("addr"));
                stringBuilder.append("  ");
                stringBuilder.append(this.prepareHex(map2.get("data")));
                stringBuilder.append(" ");
                stringBuilder.append(map2.get("ascii"));
            }
            this.taResult.append(stringBuilder.toString());
            this.taResult.setCaretPosition(0);
        }
    }

    private String prepareHex(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.indexOf(34);
        while (n2 != -1 && (n = string.indexOf(34, n2 + 1)) != -1) {
            String string2 = string.substring(n2 + 1, n);
            if (string2.startsWith("0x")) {
                string2 = string2.substring(2);
            }
            stringBuilder.append(string2.toUpperCase() + " ");
            n2 = string.indexOf(34, n + 1);
        }
        return stringBuilder.toString();
    }

    public static synchronized MemoryViewTopComponent getDefault() {
        if (instance == null) {
            instance = new MemoryViewTopComponent();
        }
        return instance;
    }

    public static synchronized MemoryViewTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(MemoryViewTopComponent.class.getName()).warning("Cannot find MemoryViewTopComponent component. It will not be located properly in the window system.");
            return MemoryViewTopComponent.getDefault();
        }
        if (topComponent instanceof MemoryViewTopComponent) {
            return (MemoryViewTopComponent)topComponent;
        }
        Logger.getLogger(MemoryViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'MemoryViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return MemoryViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return MemoryViewTopComponent.getDefault();
        }
    }
}

