/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.RegisterValue;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class RegistersTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static RegistersTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/gdb/resources/registers.png";
    private static final String PREFERRED_ID = "RegistersTopComponent";
    private final RegisterTableModel model = new RegisterTableModel();
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private static final Comparator REGISTER_COMPARATOR;

    private RegistersTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(RegistersTopComponent.class, (String)"CTL_RegistersTopComponent"));
        this.setToolTipText(NbBundle.getMessage(RegistersTopComponent.class, (String)"HINT_RegistersTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.jScrollPane1.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.jTable1.setDefaultRenderer(RegisterValue.class, new RegisterCellRendererForValue());
        this.model.refresh();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        this.jTable1.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1, "Center");
    }

    public static synchronized RegistersTopComponent getDefault() {
        if (instance == null) {
            instance = new RegistersTopComponent();
        }
        return instance;
    }

    public static synchronized RegistersTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(RegistersTopComponent.class.getName()).warning("Cannot find RegistersTopComponent component. It will not be located properly in the window system.");
            return RegistersTopComponent.getDefault();
        }
        if (topComponent instanceof RegistersTopComponent) {
            return (RegistersTopComponent)topComponent;
        }
        Logger.getLogger(RegistersTopComponent.class.getName()).warning("There seem to be multiple components with the 'RegistersTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return RegistersTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        GdbContext.getInstance().addPropertyChangeListener("Registers", this);
    }

    public void componentClosed() {
        GdbContext.getInstance().removePropertyChangeListener("Registers", this);
    }

    protected void componentShowing() {
        this.model.refresh();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.model.refresh();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        REGISTER_COMPARATOR = new Comparator<RegisterValue>(){

            @Override
            public int compare(RegisterValue registerValue, RegisterValue registerValue2) {
                return registerValue.getName().compareTo(registerValue2.getName());
            }
        };
    }

    private static class RegisterCellRendererForValue
    extends DefaultTableCellRenderer.UIResource {
        private RegisterCellRendererForValue() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RegisterValue registerValue;
            this.setEnabled(jTable == null || jTable.isEnabled());
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof RegisterValue && (registerValue = (RegisterValue)object).isModified()) {
                super.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }
    }

    private static class RegisterTableModel
    extends AbstractTableModel {
        private final List<RegisterValue> values = new ArrayList<RegisterValue>();
        public static final int COLUMN_REGISTER = 0;
        public static final int COLUMN_VALUE = 1;
        private final String[] columnNames = new String[]{NbBundle.getMessage(RegistersTopComponent.class, (String)"LBL_REGUSAGE_REGISTER"), NbBundle.getMessage(RegistersTopComponent.class, (String)"LBL_REGUSAGE_VALUE")};
        private final Class[] types = new Class[]{String.class, RegisterValue.class};

        private RegisterTableModel() {
        }

        public Class getColumnClass(int n) {
            return this.types[n];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.values.size();
        }

        public Object getValueAt(int n, int n2) {
            RegisterValue registerValue = this.values.get(n);
            switch (n2) {
                case 0: {
                    return registerValue.getName();
                }
                case 1: {
                    return registerValue;
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        private void refresh() {
            this.values.clear();
            Collection collection = (Collection)GdbContext.getInstance().getProperty("Registers");
            if (collection != null) {
                this.values.addAll(collection);
            }
            Collections.sort(this.values, REGISTER_COMPARATOR);
            this.fireTableDataChanged();
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return RegistersTopComponent.getDefault();
        }
    }
}

