/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;

public class CommandBuffer {
    public static final int STATE_NONE = 0;
    public static final int STATE_WAITING = 1;
    public static final int STATE_COMMAND_TIMEDOUT = 2;
    public static final int STATE_OK = 3;
    public static final int STATE_ERROR = 4;
    private final int WAIT_TIME = 30000;
    private boolean timerOn = Boolean.getBoolean("gdb.proxy.timer");
    private final StringBuilder buf;
    private Integer token = null;
    private String err = null;
    private int state = 0;
    private final Object lock = new Object();
    protected static Logger log = Logger.getLogger("gdb.logger.cb");
    private final GdbProxy gdb;

    public CommandBuffer(GdbProxy gdbProxy) {
        this.buf = new StringBuilder();
        assert (gdbProxy != null);
        this.gdb = gdbProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitForCompletion() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                this.state = 1;
            }
            try {
                long l;
                long l2 = l = System.currentTimeMillis();
                while (this.state == 1) {
                    this.lock.wait(30000L);
                    l2 = System.currentTimeMillis();
                    if (l2 - l <= 30000L) continue;
                    if (this.state == 3) {
                        log.finest("CB.postAndWait[" + this.token + "]: Timed out after Done [" + this.toString() + "]");
                        continue;
                    }
                    this.state = 2;
                }
                if (this.state == 2) {
                    log.warning("CB.postAndWait[" + this.token + "]: Timeout at " + l2 + " on " + GdbUtils.threadId());
                } else if (log.isLoggable(Level.FINE)) {
                    if (this.state == 4 && !Thread.currentThread().getName().equals("ToolTip-Evaluator")) {
                        log.fine("CB.postAndWait[" + this.token + "]: Error wait of " + (l2 - l) + " ms on " + GdbUtils.threadId());
                    } else if (this.state == 3) {
                        log.fine("CB.postAndWait[" + this.token + "]: OK wait of " + (l2 - l) + " ms on " + GdbUtils.threadId());
                    }
                }
                this.gdb.removeCB(this.token);
                return this.toString();
            }
            catch (InterruptedException interruptedException) {
                this.gdb.removeCB(this.token);
                return "";
            }
        }
    }

    public Integer getID() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setID(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.token = n;
            this.gdb.putCB(this.token, this);
        }
    }

    public int getState() {
        return this.state;
    }

    public void append(String string) {
        this.buf.append(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        String string = this.timerOn && log.isLoggable(Level.FINEST) ? Long.toString(System.currentTimeMillis()) + ':' : "";
        Object object = this.lock;
        synchronized (object) {
            this.state = 3;
            this.lock.notifyAll();
            log.finest("CB.done[" + string + this.token + "]: Released lock on " + GdbUtils.threadId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String string) {
        String string2 = this.timerOn && log.isLoggable(Level.FINEST) ? Long.toString(System.currentTimeMillis()) + ':' : "";
        Object object = this.lock;
        synchronized (object) {
            this.err = string;
            this.state = 4;
            log.finest("CB.error[" + string2 + this.token + "]: Releasing lock on " + GdbUtils.threadId());
            this.lock.notifyAll();
        }
    }

    public String getError() {
        if (this.state == 4 && this.err != null) {
            return this.err;
        }
        return null;
    }

    public boolean timedOut() {
        return this.state == 2;
    }

    public String toString() {
        return this.buf.toString();
    }
}

