/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.netbeans.modules.xml.schema.abe.nodes.ABEAbstractNode;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.XAMUtils;

public abstract class ABEBaseDropPanel
extends JPanel {
    protected static final long serialVersionUID = 7526472295622776147L;
    protected InstanceUIContext context;
    protected boolean firstTimeRename = false;
    boolean selected;
    public static final String PROP_ACTIVE = "active";
    public static final String PROP_SELECTED = "SELECTED";
    public static final String PROP_COMPONENT_REMOVED = "COMPONENT_REMOVED";
    private boolean active;

    public ABEBaseDropPanel(InstanceUIContext instanceUIContext) {
        this.context = instanceUIContext;
        this.context.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("shutdown")) {
                    ABEBaseDropPanel.this.fireComponentRemoved();
                    ABEBaseDropPanel.this.context.removePropertyChangeListener(this);
                }
            }
        });
        this.initialize();
        this.initKeyList();
    }

    protected void fireComponentRemoved() {
        this.firePropertyChange(PROP_COMPONENT_REMOVED, " ", this);
    }

    private void initKeyList() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ABEBaseDropPanel.this.context.getFocusTraversalManager().isFocusChangeEvent(keyEvent)) {
                    ABEBaseDropPanel.this.context.getFocusTraversalManager().handleEvent(keyEvent, ABEBaseDropPanel.this);
                }
                if (keyEvent.getKeyCode() == 525) {
                    ABEBaseDropPanel.this.context.getMultiComponentActionManager().showPopupMenu(keyEvent, ABEBaseDropPanel.this);
                    return;
                }
            }
        });
    }

    public boolean isWritable() {
        return XAMUtils.isWritable((Model)this.context.getAXIModel());
    }

    private void initialize() {
        this.setDropTarget(new DropTarget(this, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                if (!ABEBaseDropPanel.this.isWritable()) {
                    return;
                }
                ABEBaseDropPanel.this.setActive(true);
                ABEBaseDropPanel.this.dragEnter(dropTargetDragEvent);
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
                if (!ABEBaseDropPanel.this.isWritable()) {
                    return;
                }
                ABEBaseDropPanel.this.setActive(false);
                ABEBaseDropPanel.this.dragExit(dropTargetEvent);
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                if (!ABEBaseDropPanel.this.isWritable()) {
                    return;
                }
                ABEBaseDropPanel.this.dragOver(dropTargetDragEvent);
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                if (!ABEBaseDropPanel.this.isWritable()) {
                    return;
                }
                ABEBaseDropPanel.this.setActive(false);
                ABEBaseDropPanel.this.drop(dropTargetDropEvent);
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                if (!ABEBaseDropPanel.this.isWritable()) {
                    return;
                }
                ABEBaseDropPanel.this.dropActionChanged(dropTargetDragEvent);
            }
        }));
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        if (bl != this.active) {
            boolean bl2 = this.active;
            this.active = bl;
            this.handleActive(bl);
            this.firePropertyChange(PROP_ACTIVE, bl2, this.active);
        }
    }

    protected void handleActive(boolean bl) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.rejectDrag();
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.rejectDrag();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.rejectDrop();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.rejectDrag();
    }

    public ABEAbstractNode getNBNode() {
        return null;
    }

    public AXIComponent getAXIComponent() {
        return null;
    }

    public abstract void accept(UIVisitor var1);

    public void setSelected(boolean bl) {
        if (bl == this.selected) {
            return;
        }
        this.firePropertyChange(PROP_SELECTED, this.selected, bl);
        this.selected = bl;
    }

    public ABEBaseDropPanel getUIComponentFor(AXIComponent aXIComponent) {
        if (this.getAXIComponent() == aXIComponent) {
            return this;
        }
        return null;
    }

    public ABEBaseDropPanel getChildUIComponentFor(AXIComponent aXIComponent) {
        return null;
    }

    public InstanceUIContext getContext() {
        return this.context;
    }
}

