/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIContainer;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.AutoSizingPanel;
import org.netbeans.modules.xml.schema.abe.CompositorPanel;
import org.netbeans.modules.xml.schema.abe.ContainerPanel;
import org.netbeans.modules.xml.schema.abe.ExpandCollapseButton;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.ModelEventMediator;
import org.netbeans.modules.xml.schema.abe.StartTagPanel;
import org.netbeans.modules.xml.schema.abe.TagPanel;
import org.netbeans.modules.xml.schema.abe.TweenerPanel;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.netbeans.modules.xml.schema.abe.nodes.ABEAbstractNode;
import org.netbeans.modules.xml.schema.abe.nodes.AnyElementNode;
import org.netbeans.modules.xml.schema.abe.nodes.ElementNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementPanel
extends ABEBaseDropPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    Component lastComponent = null;
    SpringLayout childCompositorPanelLayout;
    private ContainerPanel parentCompositorPanel;
    private AutoSizingPanel childCompositorPanel;
    private JPanel fadeinPanel;
    private AXIContainer axiContainer;
    private String name;
    private String annotation;
    private StartTagPanel startTag;
    private JPanel startTagPanel;
    private TweenerPanel tweenerPanel;
    private List<String> attributes = new ArrayList<String>();
    private ExpandCollapseButton expandButton;
    private ABEAbstractNode elementNode;

    public ElementPanel(InstanceUIContext instanceUIContext, AXIContainer aXIContainer, ContainerPanel containerPanel) {
        super(instanceUIContext);
        this.parentCompositorPanel = containerPanel;
        this.axiContainer = aXIContainer;
        this.initialize();
        this._setName(aXIContainer.getName());
        this.addElementListener();
        this.makeNBNode();
    }

    private void initialize() {
        this.initButton();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.startTag = this.getNewStartTagPanel(this, this.context);
        this.add((Component)this.startTag, "North");
        if (this.axiContainer.getCompositor() == null) {
            this.expandButton.setVisible(false);
        }
    }

    private void addElementListener() {
        this.axiContainer.addPropertyChangeListener((PropertyChangeListener)new ModelEventMediator(this, (AXIComponent)this.axiContainer){

            public void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("compositor")) {
                    if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                        ElementPanel.this.addCompositor((Compositor)propertyChangeEvent.getNewValue());
                    } else if (propertyChangeEvent.getNewValue() == null && propertyChangeEvent.getOldValue() != null) {
                        ElementPanel.this.removeCompositor((Compositor)propertyChangeEvent.getOldValue());
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("type")) {
                    ElementPanel.this.startTag.updateAttributes();
                }
            }
        });
    }

    private void initButton() {
        this.expandButton = new ExpandCollapseButton("+");
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElementPanel.this.handleExpandOrCollapse();
            }
        });
    }

    private void handleExpandOrCollapse() {
        if (!this.expandButton.isExpanded()) {
            this.expandChild();
        } else {
            this.collapseChild();
        }
    }

    public void expandChild() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (ElementPanel.this.expandButton.isExpanded()) {
                    ElementPanel.this.expandButton.setText("-");
                }
                ElementPanel.this.setCursor(new Cursor(3));
                try {
                    if (ElementPanel.this.fadeinPanel != null) {
                        ElementPanel.this.fadeinPanel.setVisible(true);
                    } else {
                        ElementPanel.this.createChild(null);
                        ElementPanel.this.setExpanded(true);
                    }
                }
                finally {
                    ElementPanel.this.setCursor(new Cursor(0));
                }
                ElementPanel.this.revalidate();
                ElementPanel.this.repaint();
            }
        });
    }

    public void collapseChild() {
        if (this.fadeinPanel != null) {
            this.fadeinPanel.setVisible(false);
            this.revalidate();
            this.repaint();
        }
    }

    private void createChild(Compositor compositor) {
        if (compositor != null) {
            CompositorPanel compositorPanel = new CompositorPanel(this.getUIContext(), compositor, this);
            this.append(compositorPanel);
            return;
        }
        for (AXIComponent aXIComponent : this.axiContainer.getChildren()) {
            if (!(aXIComponent instanceof Compositor)) continue;
            compositor = (Compositor)aXIComponent;
            CompositorPanel compositorPanel = new CompositorPanel(this.getUIContext(), compositor, this);
            this.append(compositorPanel);
        }
    }

    public void append(ContainerPanel containerPanel) {
        if (this.childCompositorPanel == null) {
            this.fadeinPanel = new JPanel();
            this.expandButton.setWatchForComponent(this.fadeinPanel);
            this.fadeinPanel.setOpaque(false);
            this.fadeinPanel.setLayout(new BorderLayout());
            this.fadeinPanel.add(Box.createHorizontalStrut((int)this.expandButton.getPreferredSize().getWidth()), "West");
            this.childCompositorPanel = new AutoSizingPanel(this.context);
            this.childCompositorPanel.setVerticalScaling(true);
            this.childCompositorPanel.setOpaque(false);
            this.childCompositorPanelLayout = new SpringLayout();
            this.childCompositorPanel.setLayout(this.childCompositorPanelLayout);
            this.fadeinPanel.add((Component)this.childCompositorPanel, "Center");
            this.childCompositorPanel.add(containerPanel);
            this.childCompositorPanelLayout.putConstraint("North", (Component)containerPanel, 0, "North", (Component)this.childCompositorPanel);
            this.childCompositorPanelLayout.putConstraint("West", (Component)containerPanel, 0, "West", (Component)this.childCompositorPanel);
            this.add((Component)this.fadeinPanel, "Center");
            this.lastComponent = containerPanel;
        } else {
            this.childCompositorPanel.add(containerPanel);
            this.childCompositorPanelLayout.putConstraint("North", (Component)containerPanel, 0, "South", this.lastComponent);
            this.childCompositorPanelLayout.putConstraint("West", (Component)containerPanel, 0, "West", (Component)this.childCompositorPanel);
            this.lastComponent = containerPanel;
        }
    }

    private void removeChild(CompositorPanel compositorPanel) {
        if (this.childCompositorPanel != null) {
            this.childCompositorPanel.remove(compositorPanel);
            if (this.childCompositorPanel.getComponents().length == 0) {
                this.fadeinPanel.removeAll();
                this.remove(this.fadeinPanel);
                this.fadeinPanel = null;
                this.childCompositorPanel = null;
                this.expandButton.setVisible(false);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void addCompositor(Compositor compositor) {
        this.createChild(compositor);
        this.expandButton.setVisible(true);
        this.setExpanded(false);
    }

    private void removeCompositor(Compositor compositor) {
        if (this.childCompositorPanel == null) {
            return;
        }
        for (Component component : this.childCompositorPanel.getComponents()) {
            CompositorPanel compositorPanel = (CompositorPanel)component;
            if (compositorPanel.getAXIParent().getPeer().isInDocumentModel() && compositorPanel.getAXIParent().getPeer() != compositor.getPeer()) continue;
            this.removeChild(compositorPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement() {
        AXIContainer aXIContainer = this.getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        if (aXIModel != null) {
            aXIModel.startTransaction();
            try {
                ((AXIComponent)this.getAXIContainer().getParent()).removeChild((AXIComponent)this.getAXIContainer());
            }
            finally {
                aXIModel.endTransaction();
            }
        }
    }

    public boolean isExpanded() {
        return this.fadeinPanel != null ? this.fadeinPanel.isVisible() : false;
    }

    public void setExpanded(boolean bl) {
        if (this.fadeinPanel != null) {
            this.fadeinPanel.setVisible(bl);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this._setName(string);
    }

    private void _setName(String string) {
        this.name = string;
        this.repaint();
    }

    public AXIContainer getAXIContainer() {
        return this.axiContainer;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String string) {
        this._setAnnotation(string);
    }

    private void _setAnnotation(String string) {
        this.annotation = string;
    }

    public TagPanel getStartTagPanel() {
        return this.startTag;
    }

    TweenerPanel getTweenerPanel() {
        return this.tweenerPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            n2 += dimension.height;
            int n3 = dimension.width;
            n = n < n3 ? n3 : n;
        }
        if (this.fadeinPanel != null && this.fadeinPanel.isVisible()) {
            n2 += 4;
            n += 10;
        }
        return new Dimension(n, n2);
    }

    List<String> getAttributes() {
        return this.attributes;
    }

    void addAttribute(String string) {
        this.attributes.add(string);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        if (this.context.getComponentSelectionManager().getSelectedComponentList().contains(this.startTag)) {
            this.drawBoundingBox(graphics2D);
        }
    }

    public InstanceUIContext getUIContext() {
        return this.context;
    }

    void showNameEditor(boolean bl) {
        this.startTag.showTagNameEditor(bl);
    }

    protected void makeNBNode() {
        this.elementNode = this.getAXIContainer() instanceof AnyElement ? new AnyElementNode((AbstractElement)((AnyElement)this.getAXIContainer()), this.context) : new ElementNode((AbstractElement)this.getAXIContainer(), this.context);
    }

    @Override
    public ABEAbstractNode getNBNode() {
        return this.elementNode;
    }

    protected StartTagPanel getNewStartTagPanel(ElementPanel elementPanel, InstanceUIContext instanceUIContext) {
        return new StartTagPanel(elementPanel, instanceUIContext);
    }

    ExpandCollapseButton getExpandButton() {
        return this.expandButton;
    }

    private void drawBoundingBox(Graphics2D graphics2D) {
        if (this.fadeinPanel == null || !this.fadeinPanel.isVisible()) {
            return;
        }
        if (this.childCompositorPanel == null || this.childCompositorPanel.getComponents().length < 1) {
            return;
        }
        this.startTag.getTagShape();
        Point point = this.startTag.getLeftNosePoint();
        Point point2 = this.startTag.getRightNosePoint();
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        graphics2D.setColor(InstanceDesignConstants.XP_ORANGE);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Rectangle rectangle = this.fadeinPanel.getBounds();
        Rectangle rectangle2 = this.getBounds();
        int n = point.x;
        int n2 = point.y;
        int n3 = point.x;
        int n4 = n2 + rectangle2.height - point.y - 2;
        graphics2D.drawLine(n, n2, n3, n4);
        n = n3;
        n2 = n4;
        n3 = rectangle.x + rectangle.width > point2.x ? rectangle.x + rectangle.width : point2.x + 5;
        n4 = n2;
        graphics2D.drawLine(n, n2, n3, n4);
        n = n3;
        n2 = n4;
        n3 = n;
        n4 = point2.y;
        graphics2D.drawLine(n - 1, n2, n3 - 1, n4);
        n = n3;
        n2 = n4;
        n3 = point2.x;
        n4 = point2.y;
        graphics2D.drawLine(n, n2, n3, n4);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    @Override
    public ABEBaseDropPanel getUIComponentFor(AXIComponent aXIComponent) {
        ABEBaseDropPanel aBEBaseDropPanel = super.getUIComponentFor(aXIComponent);
        if (aBEBaseDropPanel == this) {
            return this.startTag;
        }
        return null;
    }

    @Override
    public ABEBaseDropPanel getChildUIComponentFor(AXIComponent aXIComponent) {
        ABEBaseDropPanel aBEBaseDropPanel = null;
        if (aXIComponent instanceof AbstractAttribute) {
            aBEBaseDropPanel = this.startTag.getChildUIComponentFor(aXIComponent);
        } else {
            Component component;
            this.expandChild();
            if (this.childCompositorPanel == null) {
                return null;
            }
            this.expandButton.setText("-");
            Component[] componentArray = this.childCompositorPanel.getComponents();
            int n = componentArray.length;
            for (int i = 0; !(i >= n || (component = componentArray[i]) instanceof CompositorPanel && (aBEBaseDropPanel = ((ABEBaseDropPanel)component).getUIComponentFor(aXIComponent)) != null); ++i) {
            }
        }
        return aBEBaseDropPanel;
    }

    @Override
    public AXIComponent getAXIComponent() {
        return this.getAXIContainer();
    }

    @Override
    public void accept(UIVisitor uIVisitor) {
        uIVisitor.visit(this);
    }

    public ContainerPanel getParentContainerPanel() {
        return this.parentCompositorPanel;
    }
}

