/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.abe.HyperlinkLabel;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.NBGlassPaneAccessSupport;
import org.netbeans.modules.xml.schema.abe.TranslucentLabel;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.cookies.ViewComponentCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtilities {
    private static final String LOC_SIMPLE_TYPE = NbBundle.getMessage(UIUtilities.class, (String)"LBL_SIMPLE_TYPE");
    private static final String LOC_COMPLEX_TYPE = NbBundle.getMessage(UIUtilities.class, (String)"LBL_COMPLEX_TYPE");
    private static final String LOC_FROM = NbBundle.getMessage(UIUtilities.class, (String)"LBL_FROM");
    private static final String LOC_BELONGS_TO = NbBundle.getMessage(UIUtilities.class, (String)"LBL_INSTANCE_OF");
    static JLabel infoLabel;
    static JPanel glassReference;

    public static String standardizeString(String string) {
        string = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.replace(0, 1, string.substring(0, 1).toUpperCase());
        return new String(stringBuffer);
    }

    public static String getConstraintsString(String string, String string2) {
        int n;
        int n2;
        if (string == null) {
            n2 = 1;
        } else {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
        }
        if (string2 == null) {
            n = 1;
        } else if (string2.equalsIgnoreCase("unbounded")) {
            n = Integer.MAX_VALUE;
        } else {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
            }
        }
        if (n2 == n) {
            if (n == 1) {
                return "";
            }
            return "[" + n2 + ".." + n + "]";
        }
        if (n2 < n) {
            String string3 = n == Integer.MAX_VALUE ? "*" : "" + n;
            return "[" + n2 + ".." + string3 + "]";
        }
        return null;
    }

    public static JLabel getContentModelInfoLabel(AXIComponent aXIComponent, boolean bl, boolean bl2, final InstanceUIContext instanceUIContext) {
        ContentModel contentModel;
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setForeground(new Color(139, 139, 139));
        Font font = hyperlinkLabel.getFont();
        font = font.deriveFont(font.getStyle() | 0, font.getSize());
        hyperlinkLabel.setFont(font);
        if (aXIComponent instanceof Element) {
            String string;
            Element element = (Element)aXIComponent;
            AXIType aXIType = element.getType();
            if (element.isReference()) {
                try {
                    Element element2 = (Element)UIUtilities.getSuperDefn((AXIComponent)element);
                    while (element2.isReference()) {
                        element2 = element2.getReferent();
                    }
                    hyperlinkLabel.setText(element2.getName());
                    hyperlinkLabel.setIcon(UIUtilities.getImageIcon("element.png"));
                    hyperlinkLabel.setToolTipText(NbBundle.getMessage(UIUtilities.class, (String)"TTP_REFERENCE_TO_GE", (Object)element));
                    Element element3 = element2;
                    hyperlinkLabel.setHyperlinkClickHandler(new HyperlinkLabel.HyperlinkClickHandler((AbstractElement)element3){
                        final /* synthetic */ AbstractElement val$tmpaelm;
                        {
                            this.val$tmpaelm = abstractElement;
                        }

                        public void handleClick() {
                            UIUtilities.showDefinition(instanceUIContext, (AXIComponent)this.val$tmpaelm, false);
                        }
                    });
                    return hyperlinkLabel;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            if (aXIType == null) {
                return null;
            }
            String string2 = aXIType.getName();
            if (string2 == null) {
                hyperlinkLabel.setText(NbBundle.getMessage(UIUtilities.class, (String)"LBL_ANONYMOUS_TYPE"));
                return hyperlinkLabel;
            }
            hyperlinkLabel.setText(string2);
            String string3 = null;
            String string4 = string3 = aXIType instanceof Datatype ? LOC_SIMPLE_TYPE : LOC_COMPLEX_TYPE;
            if (bl2) {
                string = aXIType instanceof Datatype ? "simpletype.png" : "complextype.png";
                hyperlinkLabel.setIcon(UIUtilities.getImageIcon(string));
            }
            string = " " + LOC_BELONGS_TO + " " + string3 + ": " + string2 + " ";
            hyperlinkLabel.setToolTipText(string);
            if (aXIType instanceof ContentModel) {
                final ContentModel contentModel2 = (ContentModel)aXIType;
                hyperlinkLabel.setHyperlinkClickHandler(new HyperlinkLabel.HyperlinkClickHandler(){

                    public void handleClick() {
                        UIUtilities.showDefinition(instanceUIContext, (AXIComponent)contentModel2, false);
                    }
                });
            }
            return hyperlinkLabel;
        }
        if (!bl && (contentModel = aXIComponent.getContentModel()) != null) {
            String string = UIUtilities.getContentModelTypeString(contentModel.getType());
            String string5 = aXIComponent instanceof AbstractElement ? LOC_BELONGS_TO : LOC_FROM;
            String string6 = " " + string5 + " " + string + ": " + contentModel.getName() + " ";
            hyperlinkLabel.setToolTipText(string6);
            hyperlinkLabel.setText(contentModel.getName());
            if (bl2) {
                hyperlinkLabel.setIcon(UIUtilities.getContentModelTypeIcon(contentModel.getType()));
            }
            hyperlinkLabel.setHyperlinkClickHandler(new HyperlinkLabel.HyperlinkClickHandler(){

                public void handleClick() {
                    UIUtilities.showDefinition(instanceUIContext, (AXIComponent)contentModel, false);
                }
            });
            return hyperlinkLabel;
        }
        return null;
    }

    public static org.netbeans.modules.xml.xam.Component getSuperDefn(AXIComponent aXIComponent) {
        AXIComponent aXIComponent2 = aXIComponent.getOriginal();
        if (aXIComponent2 == aXIComponent) {
            Element element;
            if (aXIComponent2 instanceof Element && (element = (Element)aXIComponent2).isReference()) {
                return element.getReferent();
            }
            if (aXIComponent2 instanceof Attribute && (element = (Attribute)aXIComponent2).isReference()) {
                return element.getReferent();
            }
            return null;
        }
        return aXIComponent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDefinition(InstanceUIContext instanceUIContext, AXIComponent aXIComponent, boolean bl) {
        if (instanceUIContext != null) {
            UIUtilities.setBusyCursor(instanceUIContext);
            try {
                FileObject fileObject = (FileObject)aXIComponent.getModel().getSchemaModel().getModelSource().getLookup().lookup(FileObject.class);
                DataObject dataObject = null;
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    UIUtilities.setDefaultCursor(instanceUIContext);
                    return;
                }
                if (dataObject == null) {
                    return;
                }
                ViewComponentCookie viewComponentCookie = (ViewComponentCookie)dataObject.getCookie(ViewComponentCookie.class);
                if (viewComponentCookie != null) {
                    AXIComponent aXIComponent2 = aXIComponent;
                    if (bl) {
                        aXIComponent2 = (AXIComponent)UIUtilities.getSuperDefn(aXIComponent);
                    }
                    viewComponentCookie.view(ViewComponentCookie.View.SUPER, (org.netbeans.modules.xml.xam.Component)aXIComponent2, new Object[0]);
                }
            }
            finally {
                UIUtilities.setDefaultCursor(instanceUIContext);
            }
        }
    }

    public static String getContentModelTypeString(ContentModel.ContentModelType contentModelType) {
        switch (contentModelType) {
            case COMPLEX_TYPE: {
                return NbBundle.getMessage(UIUtilities.class, (String)"LBL_COMPLEX_TYPE");
            }
            case GROUP: {
                return NbBundle.getMessage(UIUtilities.class, (String)"LBL_GROUP");
            }
            case ATTRIBUTE_GROUP: {
                return NbBundle.getMessage(UIUtilities.class, (String)"LBL_ATTRIBUTE_GROUP");
            }
        }
        return "";
    }

    public static Icon getContentModelTypeIcon(ContentModel.ContentModelType contentModelType) {
        switch (contentModelType) {
            case COMPLEX_TYPE: {
                return new ImageIcon(UIUtilities.class.getResource("/org/netbeans/modules/xml/schema/abe/resources/complextype.png"));
            }
            case GROUP: {
                return new ImageIcon(UIUtilities.class.getResource("/org/netbeans/modules/xml/schema/abe/resources/group.png"));
            }
            case ATTRIBUTE_GROUP: {
                return new ImageIcon(UIUtilities.class.getResource("/org/netbeans/modules/xml/schema/abe/resources/attributeGroup.png"));
            }
        }
        return null;
    }

    public static Icon getImageIcon(String string) {
        return new ImageIcon(UIUtilities.class.getResource("/org/netbeans/modules/xml/schema/abe/resources/" + string));
    }

    public static void scrollViewTo(Component component, InstanceUIContext instanceUIContext) {
        if (!instanceUIContext.getTopComponent().isShowing()) {
            return;
        }
        JViewport jViewport = instanceUIContext.getInstanceDesignerScrollPane().getViewport();
        Rectangle rectangle = component.getBounds();
        rectangle = SwingUtilities.convertRectangle(component.getParent(), rectangle, jViewport);
        rectangle.height += 100;
        jViewport.scrollRectToVisible(rectangle);
    }

    public static AXIComponent findMatchingAXIComponent(SchemaComponent schemaComponent) {
        AXIComponent aXIComponent = null;
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaComponent.getModel());
        assert (aXIModel != null);
        if (aXIModel.getState() == Model.State.VALID) {
            List<SchemaComponent> list = UIUtilities.findSchemaComponentsFromRoot(schemaComponent);
            aXIComponent = UIUtilities.findClosestAXIComponent(list, aXIModel);
        }
        return aXIComponent;
    }

    private static List<SchemaComponent> findSchemaComponentsFromRoot(SchemaComponent schemaComponent) {
        ArrayList<SchemaComponent> arrayList = new ArrayList<SchemaComponent>();
        arrayList.add(0, schemaComponent);
        SchemaComponent schemaComponent2 = schemaComponent;
        while (schemaComponent2.getParent() != schemaComponent2.getModel().getRootComponent()) {
            schemaComponent2 = (SchemaComponent)schemaComponent2.getParent();
            arrayList.add(0, schemaComponent2);
        }
        return arrayList;
    }

    private static AXIComponent findClosestAXIComponent(List<SchemaComponent> list, AXIModel aXIModel) {
        assert (!list.isEmpty());
        SchemaComponent schemaComponent = list.remove(0);
        AXIComponent aXIComponent = UIUtilities.findChildComponent(schemaComponent, (AXIComponent)aXIModel.getRoot());
        if (aXIComponent != null) {
            for (SchemaComponent schemaComponent2 : list) {
                AXIComponent aXIComponent2 = UIUtilities.findChildComponent(schemaComponent2, aXIComponent);
                if (aXIComponent2 == null) continue;
                aXIComponent = aXIComponent2;
            }
        }
        return aXIComponent;
    }

    private static AXIComponent findChildComponent(SchemaComponent schemaComponent, AXIComponent aXIComponent) {
        AXIComponent aXIComponent2 = null;
        for (AXIComponent aXIComponent3 : aXIComponent.getChildren()) {
            if (aXIComponent3.getPeer() != schemaComponent) continue;
            aXIComponent2 = aXIComponent3;
        }
        return aXIComponent2;
    }

    public static void showBulbMessage(String string, InstanceUIContext instanceUIContext) {
        UIUtilities.showBulbMessageFor(string, instanceUIContext, null);
    }

    public static void showBulbMessageFor(String string, InstanceUIContext instanceUIContext, Component component) {
        UIUtilities.showMessage(UIUtilities.getImageIcon("bulb.png"), null, null, string, instanceUIContext, null, component);
    }

    public static void showErrorMessage(String string, InstanceUIContext instanceUIContext) {
        UIUtilities.showErrorMessageFor(string, instanceUIContext, null);
    }

    public static void showErrorMessageFor(String string, InstanceUIContext instanceUIContext, Component component) {
        UIUtilities.showMessage(UIUtilities.getImageIcon("error.png"), Color.RED, null, string, instanceUIContext, null, component);
    }

    public static void showErrorMessage(String string, InstanceUIContext instanceUIContext, JPanel jPanel) {
        UIUtilities.showErrorMessageFor(string, instanceUIContext, jPanel, null);
    }

    public static void showErrorMessageFor(String string, InstanceUIContext instanceUIContext, JPanel jPanel, Component component) {
        UIUtilities.showMessage(UIUtilities.getImageIcon("error.png"), Color.RED, null, string, instanceUIContext, jPanel, component);
    }

    public static void showMessage(Icon icon, Color color, String string, InstanceUIContext instanceUIContext) {
        UIUtilities.showMessageFor(icon, color, string, instanceUIContext, null);
    }

    public static void showMessageFor(Icon icon, Color color, String string, InstanceUIContext instanceUIContext, Component component) {
        UIUtilities.showMessage(icon, color, null, string, instanceUIContext, null, null);
    }

    protected static void showMessage(Icon icon, Color color, Color color2, String string, InstanceUIContext instanceUIContext, JPanel jPanel, Component component) {
        if (string == null) {
            return;
        }
        if (infoLabel != null && infoLabel.getParent() != null && infoLabel.getText().equals(string)) {
            return;
        }
        infoLabel = null;
        infoLabel = icon != null ? new TranslucentLabel(icon, 2) : new TranslucentLabel(" ", 2);
        Font font = infoLabel.getFont();
        font = font.deriveFont(font.getStyle() | 0, font.getSize());
        if (color != null) {
            infoLabel.setForeground(color);
        } else {
            infoLabel.setForeground(Color.black);
        }
        if (color2 != null) {
            infoLabel.setBackground(color2);
        } else {
            infoLabel.setBackground(InstanceDesignConstants.LIGHT_YELLOW);
        }
        infoLabel.setFont(font);
        infoLabel.setText(string);
        Component component2 = component != null ? component : instanceUIContext.getNamespacePanel();
        Rectangle rectangle = component2.getBounds();
        if (jPanel == null) {
            jPanel = NBGlassPaneAccessSupport.getNBGlassPane(instanceUIContext.getInstanceDesignerPanel());
        } else {
            glassReference = jPanel;
        }
        if (jPanel == null) {
            return;
        }
        rectangle = SwingUtilities.convertRectangle(component2.getParent(), rectangle, jPanel);
        jPanel.add(infoLabel);
        infoLabel.setOpaque(false);
        if (component != null) {
            rectangle.y -= 20;
            Dimension dimension = infoLabel.getPreferredSize();
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
        }
        infoLabel.setBounds(rectangle);
        jPanel.setVisible(true);
    }

    public static void hideGlassMessage(boolean bl) {
        if (infoLabel != null && glassReference != null) {
            glassReference.remove(infoLabel);
            glassReference.revalidate();
            glassReference.repaint();
        }
        if (bl) {
            NBGlassPaneAccessSupport.forceDisposeNBGlassPane();
        }
    }

    public static void hideGlassMessage() {
        UIUtilities.hideGlassMessage(true);
    }

    public static List<Point> getBrokenTapePoints(Point point, int n, int n2, int n3, boolean bl) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n4 = point.y;
        int n5 = n;
        int n6 = n4;
        boolean bl2 = true;
        arrayList.add(new Point(point.x, n6));
        n6 += n3;
        while (n6 < n5) {
            if (bl2) {
                if (bl) {
                    arrayList.add(new Point(point.x + n2, n6));
                } else {
                    arrayList.add(new Point(point.x - n2, n6));
                }
                bl2 = false;
            } else {
                if (bl) {
                    arrayList.add(new Point(point.x - n2, n6));
                } else {
                    arrayList.add(new Point(point.x + n2, n6));
                }
                bl2 = true;
            }
            n6 += n3;
        }
        arrayList.add(new Point(point.x, n));
        return arrayList;
    }

    public static String getUniqueName(String string, AXIComponent aXIComponent) {
        int n = 1;
        String string2 = null;
        String string3 = string;
        if (aXIComponent.getChildren().size() < 0) {
            return string;
        }
        while (string2 == null) {
            boolean bl = true;
            for (AXIComponent aXIComponent2 : aXIComponent.getChildren()) {
                if (aXIComponent2.toString().indexOf(string3) == -1) continue;
                string3 = string + n++;
                bl = false;
                break;
            }
            if (!bl) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public static void setBusyCursor(InstanceUIContext instanceUIContext) {
        if (instanceUIContext == null) {
            return;
        }
        JFrame jFrame = NBGlassPaneAccessSupport.getNBFRAME((Component)instanceUIContext.getTopComponent());
        if (jFrame == null) {
            return;
        }
        jFrame.setCursor(new Cursor(3));
    }

    public static void setDefaultCursor(InstanceUIContext instanceUIContext) {
        if (instanceUIContext == null) {
            return;
        }
        JFrame jFrame = NBGlassPaneAccessSupport.getNBFRAME((Component)instanceUIContext.getTopComponent());
        if (jFrame == null) {
            return;
        }
        jFrame.setCursor(new Cursor(0));
    }
}

