/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.palette;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import org.openide.nodes.Node;

public class DnDHelper {
    public static PaletteItem getDraggedPaletteItem(Transferable transferable) {
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            Class<?> clazz = dataFlavor.getRepresentationClass();
            Object object = null;
            try {
                object = transferable.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            if (!Node.class.isAssignableFrom(clazz)) continue;
            String string = ((Node)object).getName();
            return DnDHelper.getPaletteItem(string);
        }
        return PaletteItem.UNKNOWN;
    }

    public static PaletteItem getDraggedPaletteItem(DropTargetDragEvent dropTargetDragEvent) {
        return DnDHelper.getDraggedPaletteItem(dropTargetDragEvent.getTransferable());
    }

    public static PaletteItem getDraggedPaletteItem(DropTargetDropEvent dropTargetDropEvent) {
        return DnDHelper.getDraggedPaletteItem(dropTargetDropEvent.getTransferable());
    }

    private static PaletteItem getPaletteItem(String string) {
        if (string.equalsIgnoreCase("attribute")) {
            return PaletteItem.ATTRIBUTE;
        }
        if (string.equalsIgnoreCase("element")) {
            return PaletteItem.ELEMENT;
        }
        if (string.equalsIgnoreCase("sequence")) {
            return PaletteItem.SEQUENCE;
        }
        if (string.equalsIgnoreCase("choice")) {
            return PaletteItem.CHOICE;
        }
        if (string.equalsIgnoreCase("all")) {
            return PaletteItem.ALL;
        }
        if (string.equalsIgnoreCase("complextype")) {
            return PaletteItem.COMPLEXTYPE;
        }
        return PaletteItem.UNKNOWN;
    }

    public static boolean isCompositor(PaletteItem paletteItem) {
        switch (paletteItem) {
            case SEQUENCE: 
            case CHOICE: 
            case ALL: {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PaletteItem {
        ELEMENT,
        ATTRIBUTE,
        SEQUENCE,
        CHOICE,
        ALL,
        COMPLEXTYPE,
        UNKNOWN;

    }
}

