/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.PathSupport;
import com.sun.perseus.j2d.TextRenderingProperties;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Font;
import com.sun.perseus.model.ModelNode;
import org.w3c.dom.DOMException;

public class Glyph
extends ElementNode {
    public static final float DEFAULT_HORIZONTAL_ADVANCE_X = -1.0f;
    protected Path d;
    protected float horizontalAdvanceX = -1.0f;
    protected float computedHorizontalAdvanceX = -1.0f;
    protected float origin = 0.0f;
    protected float emSquareScale = 1.0f;
    protected String unicode;
    protected String[] glyphName;
    protected String localName = "glyph";

    public Glyph(DocumentNode ownerDocument) {
        this(ownerDocument, "glyph");
    }

    public Glyph(DocumentNode ownerDocument, String localName) {
        super(ownerDocument);
        if ("glyph" != localName && "missing-glyph" != localName) {
            throw new IllegalArgumentException("Illegal Glyph name : " + localName);
        }
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Glyph(doc, this.localName);
    }

    public void setEmSquareScale(float newEmSquareScale) {
        if (newEmSquareScale == this.emSquareScale) {
            return;
        }
        this.emSquareScale = newEmSquareScale;
    }

    public void setHorizontalAdvanceX(float newHorizontalAdvanceX) {
        if (newHorizontalAdvanceX == this.horizontalAdvanceX) {
            return;
        }
        this.horizontalAdvanceX = newHorizontalAdvanceX;
        if (newHorizontalAdvanceX == -1.0f && this.parent != null && this.parent instanceof Font) {
            this.computedHorizontalAdvanceX = ((Font)this.parent).getHorizontalAdvanceX();
            this.origin = ((Font)this.parent).getHorizontalOriginX();
        } else {
            this.computedHorizontalAdvanceX = newHorizontalAdvanceX;
        }
    }

    public void setParent(ModelNode parent) {
        super.setParent(parent);
        if (parent != null && parent instanceof Font) {
            if (this.horizontalAdvanceX == -1.0f) {
                this.computedHorizontalAdvanceX = ((Font)parent).getHorizontalAdvanceX();
            }
            this.origin = ((Font)parent).getHorizontalOriginX();
        } else {
            this.origin = 0.0f;
        }
    }

    protected void applyTransform(Transform tx) {
        tx.mScale(this.emSquareScale, -this.emSquareScale);
        tx.mTranslate(-this.origin, 0.0f);
    }

    protected void applyInverseTransform(Transform tx) {
        tx.mTranslate(this.origin, 0.0f);
        tx.mScale(1.0f / this.emSquareScale, -1.0f / this.emSquareScale);
    }

    public float getHorizontalAdvanceX() {
        return this.computedHorizontalAdvanceX;
    }

    public float getTextHorizontalAdvanceX() {
        return this.computedHorizontalAdvanceX * this.emSquareScale;
    }

    public Path getD() {
        return this.d;
    }

    public void setD(Path newD) {
        if (Glyph.equal(newD, this.d)) {
            return;
        }
        this.d = newD;
    }

    public String[] getGlyphName() {
        return this.glyphName;
    }

    public void setGlyphName(String[] glyphName) {
        if (Glyph.equal(glyphName, this.glyphName)) {
            return;
        }
        this.glyphName = glyphName;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public void setUnicode(String newUnicode) {
        if (Glyph.equal(newUnicode, this.unicode)) {
            return;
        }
        this.unicode = newUnicode;
    }

    public int getLength() {
        if (this.unicode == null) {
            return 1;
        }
        return this.unicode.length();
    }

    public int getCharAt(int i) {
        return this.unicode.charAt(i);
    }

    public boolean isHit(float[] pt, TextRenderingProperties trp) {
        Object strokedPath;
        if (this.d == null) {
            return false;
        }
        if (trp.getFill() != null && PathSupport.isHit(this.d, trp.getFillRule(), pt[0], pt[1])) {
            return true;
        }
        return trp.getStroke() != null && PathSupport.isStrokedPathHit(strokedPath = PathSupport.getStrokedPath(this.d, trp), trp.getFillRule(), pt[0], pt[1]);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        return Glyph.addShapeBBox(bbox, this.d, t);
    }

    boolean supportsTrait(String traitName) {
        if ("d" == traitName || "horiz-adv-x" == traitName || "glyph-name" == traitName || "unicode" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("d" == name) {
            if (this.d == null) {
                return "";
            }
            return this.d.toString();
        }
        if ("horiz-adv-x" == name) {
            return Float.toString(this.getHorizontalAdvanceX());
        }
        if ("unicode" == name) {
            if (this.unicode == null) {
                return "";
            }
            return this.unicode;
        }
        if ("glyph-name" == name) {
            return this.toStringTrait(this.getGlyphName());
        }
        return super.getTraitImpl(name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("d" == name) {
            this.checkWriteLoading(name);
            this.setD(this.parsePathTrait(name, value));
        } else if ("horiz-adv-x" == name) {
            this.checkWriteLoading(name);
            this.setHorizontalAdvanceX(this.parsePositiveFloatTrait(name, value));
        } else if ("unicode" == name) {
            this.checkWriteLoading(name);
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setUnicode(value);
        } else if ("glyph-name" == name) {
            this.checkWriteLoading(name);
            this.setGlyphName(this.parseStringArrayTrait(name, value, ","));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public String toString() {
        return "com.sun.perseus.model.Glyph[" + this.unicode + "]";
    }
}

