/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt_1_2.component.html;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.visualweb.faces.dt.util.ComponentBundle;
import org.netbeans.modules.visualweb.faces.dt_1_2.component.html.HtmlDataTableState;
import org.netbeans.modules.visualweb.propertyeditors.StandardUrlPanel;

public class HtmlDataTableCustomizerPagingPanel
extends JPanel {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(HtmlDataTableCustomizerPagingPanel.class);
    private static final int DEFAULT_PAGING_ROWS = 10;
    private Map inputDependents = new HashMap();
    private JCheckBox chkEnablePaging = new JCheckBox();
    private JTextField tfPageSize = new JTextField();
    private JLabel lblPageSize = new JLabel();
    private JLabel lblNav = new JLabel();
    private JComboBox comboNav = new JComboBox();
    private JCheckBox chkFirst = new JCheckBox();
    private JCheckBox chkPrevious = new JCheckBox();
    private JCheckBox chkNext = new JCheckBox();
    private JCheckBox chkLast = new JCheckBox();
    private JLabel lblLocation = new JLabel();
    private JComboBox comboLocation = new JComboBox();
    private JTextField tfFirst = new JTextField();
    private JTextField tfPrevious = new JTextField();
    private JTextField tfNext = new JTextField();
    private JTextField tfLast = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel fillerPanel = new JPanel();
    private HtmlDataTableState table;
    private JButton btnBrowseFirst = new JButton();
    private JButton btnBrowsePrevious = new JButton();
    private JButton btnBrowseNext = new JButton();
    private JButton btnBrowseLast = new JButton();
    private JLabel lblAlign = new JLabel();
    private JComboBox comboAlign = new JComboBox();
    private String previousComboNavSelection;

    HtmlDataTableCustomizerPagingPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setTable(HtmlDataTableState htmlDataTableState) {
        this.table = htmlDataTableState;
        this.initState();
    }

    private void jbInit() throws Exception {
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HtmlDataTableCustomizerPagingPanel.this.chk_stateChanged(changeEvent);
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HtmlDataTableCustomizerPagingPanel.this.pagingPanelActionPerformed(actionEvent);
            }
        };
        this.chkEnablePaging.addChangeListener(changeListener);
        this.chkEnablePaging.setText(bundle.getMessage("enablePaging"));
        this.lblPageSize.setText(bundle.getMessage("pageSize"));
        this.tfPageSize.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                HtmlDataTableCustomizerPagingPanel.this.tfPageSize_changed(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                HtmlDataTableCustomizerPagingPanel.this.tfPageSize_changed(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                HtmlDataTableCustomizerPagingPanel.this.tfPageSize_changed(documentEvent);
            }
        });
        this.lblNav.setText(bundle.getMessage("pageNavControls"));
        this.comboNav.setMinimumSize(new Dimension(30, 24));
        this.comboNav.addItem(HtmlDataTableState.BUTTON_TEXT);
        this.comboNav.addItem(HtmlDataTableState.BUTTON_IMAGE);
        this.comboNav.addItem(HtmlDataTableState.BUTTON_NONE);
        this.comboNav.addActionListener(actionListener);
        this.chkFirst.addChangeListener(changeListener);
        this.chkFirst.setText(bundle.getMessage("firstPage"));
        this.chkPrevious.addChangeListener(changeListener);
        this.chkPrevious.setText(bundle.getMessage("prevPage"));
        this.chkNext.addChangeListener(changeListener);
        this.chkNext.setText(bundle.getMessage("nextPage"));
        this.chkLast.addChangeListener(changeListener);
        this.chkLast.setText(bundle.getMessage("lastPage"));
        this.tfFirst.setColumns(20);
        this.tfPrevious.setColumns(20);
        this.tfNext.setColumns(20);
        this.tfLast.setColumns(20);
        this.lblLocation.setText(bundle.getMessage("position"));
        this.comboLocation.setMinimumSize(new Dimension(30, 24));
        this.comboLocation.addItem(HtmlDataTableState.TOP);
        this.comboLocation.addItem(HtmlDataTableState.BOTTOM);
        this.comboLocation.addItem(HtmlDataTableState.TOP_AND_BOTTOM);
        this.lblAlign.setText(bundle.getMessage("align"));
        this.comboAlign.setMinimumSize(new Dimension(30, 24));
        this.comboAlign.addItem(HtmlDataTableState.ALIGN_LEFT);
        this.comboAlign.addItem(HtmlDataTableState.ALIGN_CENTER);
        this.comboAlign.addItem(HtmlDataTableState.ALIGN_RIGHT);
        String string = bundle.getMessage("browseEllipse");
        this.btnBrowseFirst.setText(string);
        this.btnBrowseFirst.addActionListener(actionListener);
        this.btnBrowsePrevious.setText(string);
        this.btnBrowsePrevious.addActionListener(actionListener);
        this.btnBrowseNext.setText(string);
        this.btnBrowseNext.addActionListener(actionListener);
        this.btnBrowseLast.setText(string);
        this.btnBrowseLast.addActionListener(actionListener);
        this.inputDependents.put(this.chkEnablePaging, new JComponent[]{this.lblPageSize, this.tfPageSize, this.comboNav});
        this.inputDependents.put(this.comboNav, new JComponent[]{this.chkFirst, this.tfFirst, this.btnBrowseFirst, this.chkPrevious, this.tfPrevious, this.btnBrowsePrevious, this.chkNext, this.tfNext, this.btnBrowseNext, this.chkLast, this.tfLast, this.btnBrowseLast, this.lblLocation, this.comboLocation, this.lblAlign, this.comboAlign});
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.chkEnablePaging, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 2, 8), 0, 0));
        this.add((Component)this.lblPageSize, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 22, 4, 8), 0, 0));
        this.add((Component)this.tfPageSize, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 22, 8, 8), 0, 0));
        this.add((Component)this.lblNav, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 22, 16, 4), 0, 0));
        this.add((Component)this.comboNav, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 4, 16, 4), 0, 0));
        this.add((Component)this.chkFirst, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 32, 8, 4), 0, 0));
        this.add((Component)this.tfFirst, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 8, 4), 0, 0));
        this.add((Component)this.btnBrowseFirst, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 8, 8), 0, 0));
        this.add((Component)this.chkPrevious, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 32, 8, 4), 0, 0));
        this.add((Component)this.tfPrevious, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 8, 4), 0, 0));
        this.add((Component)this.btnBrowsePrevious, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 8, 8), 0, 0));
        this.add((Component)this.chkNext, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 32, 8, 4), 0, 0));
        this.add((Component)this.tfNext, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 8, 4), 0, 0));
        this.add((Component)this.btnBrowseNext, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 8, 8), 0, 0));
        this.add((Component)this.chkLast, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 32, 8, 4), 0, 0));
        this.add((Component)this.tfLast, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 8, 4), 0, 0));
        this.add((Component)this.btnBrowseLast, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 8, 8), 0, 0));
        this.add((Component)this.lblLocation, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 35, 8, 4), 0, 0));
        this.add((Component)this.comboLocation, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 8, 4), 0, 0));
        this.add((Component)this.lblAlign, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 35, 8, 4), 0, 0));
        this.add((Component)this.comboAlign, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 8, 4), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(0, 10, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void pagingPanelActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.comboNav) {
            boolean bl;
            String string = (String)this.comboNav.getSelectedItem();
            boolean bl2 = bl = HtmlDataTableState.BUTTON_TEXT.equals(string) || HtmlDataTableState.BUTTON_IMAGE.equals(string);
            if (!(!bl || this.chkFirst.isSelected() || this.chkPrevious.isSelected() || this.chkNext.isSelected() || this.chkLast.isSelected())) {
                this.chkFirst.setSelected(true);
                this.chkPrevious.setSelected(true);
                this.chkNext.setSelected(true);
                this.chkLast.setSelected(true);
            }
            if (HtmlDataTableState.BUTTON_NONE.equals(this.previousComboNavSelection) || HtmlDataTableState.BUTTON_TEXT.equals(this.previousComboNavSelection)) {
                this.table.paging.firstButtonText = this.tfFirst.getText();
                this.table.paging.previousButtonText = this.tfPrevious.getText();
                this.table.paging.nextButtonText = this.tfNext.getText();
                this.table.paging.lastButtonText = this.tfLast.getText();
            } else if (HtmlDataTableState.BUTTON_IMAGE.equals(this.previousComboNavSelection)) {
                this.table.paging.firstButtonUrl = this.tfFirst.getText();
                this.table.paging.previousButtonUrl = this.tfPrevious.getText();
                this.table.paging.nextButtonUrl = this.tfNext.getText();
                this.table.paging.lastButtonUrl = this.tfLast.getText();
            }
            if (HtmlDataTableState.BUTTON_IMAGE.equals(string)) {
                this.tfFirst.setText(this.table.paging.firstButtonUrl);
                this.tfPrevious.setText(this.table.paging.previousButtonUrl);
                this.tfNext.setText(this.table.paging.nextButtonUrl);
                this.tfLast.setText(this.table.paging.lastButtonUrl);
            } else {
                this.tfFirst.setText(this.table.paging.firstButtonText);
                this.tfPrevious.setText(this.table.paging.previousButtonText);
                this.tfNext.setText(this.table.paging.nextButtonText);
                this.tfLast.setText(this.table.paging.lastButtonText);
            }
            this.setDependentsEnabled(this.comboNav);
            this.previousComboNavSelection = string;
        } else {
            JButton[] jButtonArray = new JButton[]{this.btnBrowseFirst, this.btnBrowsePrevious, this.btnBrowseNext, this.btnBrowseLast};
            JTextField[] jTextFieldArray = new JTextField[]{this.tfFirst, this.tfPrevious, this.tfNext, this.tfLast};
            for (int i = 0; i < jButtonArray.length; ++i) {
                if (actionEvent.getSource() != jButtonArray[i]) continue;
                StandardUrlPanel standardUrlPanel = new StandardUrlPanel();
                standardUrlPanel.setDesignProperty(null);
                standardUrlPanel.setDesignContext(this.table.getTableBean().getDesignContext());
                standardUrlPanel.initialize();
                URLDialog uRLDialog = new URLDialog(this.getParentFrame(this), standardUrlPanel);
                uRLDialog.show();
                jTextFieldArray[i].setText(uRLDialog.getUrlString());
                standardUrlPanel = null;
                uRLDialog = null;
                break;
            }
        }
    }

    void initState() {
        this.chkEnablePaging.setSelected(this.table.paging.rows > 0);
        this.tfPageSize.setText(this.table.paging.rows > 0 ? String.valueOf(this.table.paging.rows) : String.valueOf(10));
        this.comboNav.setSelectedItem(this.table.paging.navigation);
        this.previousComboNavSelection = this.table.paging.navigation;
        this.chkFirst.setSelected(this.table.paging.firstButton);
        this.tfFirst.setText(HtmlDataTableState.BUTTON_IMAGE.equals(this.table.paging.navigation) ? this.table.paging.firstButtonUrl : this.table.paging.firstButtonText);
        this.chkPrevious.setSelected(this.table.paging.previousButton);
        this.tfPrevious.setText(HtmlDataTableState.BUTTON_IMAGE.equals(this.table.paging.navigation) ? this.table.paging.previousButtonUrl : this.table.paging.previousButtonText);
        this.chkNext.setSelected(this.table.paging.nextButton);
        this.tfNext.setText(HtmlDataTableState.BUTTON_IMAGE.equals(this.table.paging.navigation) ? this.table.paging.nextButtonUrl : this.table.paging.nextButtonText);
        this.chkLast.setSelected(this.table.paging.lastButton);
        this.tfLast.setText(HtmlDataTableState.BUTTON_IMAGE.equals(this.table.paging.navigation) ? this.table.paging.lastButtonUrl : this.table.paging.lastButtonText);
        if (this.table.paging.navOnTop && this.table.paging.navOnBottom) {
            this.comboLocation.setSelectedItem(HtmlDataTableState.TOP_AND_BOTTOM);
        } else if (this.table.paging.navOnTop) {
            this.comboLocation.setSelectedItem(HtmlDataTableState.TOP);
        } else if (this.table.paging.navOnBottom) {
            this.comboLocation.setSelectedItem(HtmlDataTableState.BOTTOM);
        }
        this.comboAlign.setSelectedItem(this.table.paging.align);
        this.setDependentsEnabled(this.chkEnablePaging);
    }

    private int getPagingRows() {
        int n = 0;
        if (this.chkEnablePaging.isSelected()) {
            try {
                n = Integer.parseInt(this.tfPageSize.getText().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    void saveState() {
        String string;
        this.table.paging.rows = this.getPagingRows();
        this.table.paging.navigation = string = (String)this.comboNav.getSelectedItem();
        String string2 = (String)this.comboLocation.getSelectedItem();
        this.table.paging.navOnTop = string2.equals(HtmlDataTableState.TOP) || string2.equals(HtmlDataTableState.TOP_AND_BOTTOM);
        this.table.paging.navOnBottom = string2.equals(HtmlDataTableState.BOTTOM) || string2.equals(HtmlDataTableState.TOP_AND_BOTTOM);
        this.table.paging.align = (String)this.comboAlign.getSelectedItem();
        this.table.paging.firstButton = this.chkFirst.isSelected();
        this.table.paging.previousButton = this.chkPrevious.isSelected();
        this.table.paging.nextButton = this.chkNext.isSelected();
        this.table.paging.lastButton = this.chkLast.isSelected();
        if (HtmlDataTableState.BUTTON_NONE.equals(string) || HtmlDataTableState.BUTTON_TEXT.equals(string)) {
            this.table.paging.firstButtonText = this.tfFirst.getText();
            this.table.paging.previousButtonText = this.tfPrevious.getText();
            this.table.paging.nextButtonText = this.tfNext.getText();
            this.table.paging.lastButtonText = this.tfLast.getText();
        } else if (HtmlDataTableState.BUTTON_IMAGE.equals(string)) {
            this.table.paging.firstButtonUrl = this.tfFirst.getText();
            this.table.paging.previousButtonUrl = this.tfPrevious.getText();
            this.table.paging.nextButtonUrl = this.tfNext.getText();
            this.table.paging.lastButtonUrl = this.tfLast.getText();
        }
    }

    private void chk_stateChanged(ChangeEvent changeEvent) {
        this.setDependentsEnabled((JComponent)changeEvent.getSource());
    }

    private void tfPageSize_changed(DocumentEvent documentEvent) {
        this.setDependentsEnabled(this.chkEnablePaging);
    }

    private void setDependentsEnabled(JComponent jComponent) {
        JComponent[] jComponentArray = (JComponent[])this.inputDependents.get(jComponent);
        if (jComponentArray == null) {
            return;
        }
        boolean bl = false;
        String string = null;
        if (jComponent instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)jComponent;
            bl = jCheckBox.isEnabled() && jCheckBox.isSelected();
        } else if (jComponent == this.comboNav) {
            string = (String)this.comboNav.getSelectedItem();
            bl = this.comboNav.isEnabled() && (HtmlDataTableState.BUTTON_TEXT.equals(string) || HtmlDataTableState.BUTTON_IMAGE.equals(string));
        }
        for (int i = 0; i < jComponentArray.length; ++i) {
            boolean bl2 = bl;
            if (jComponent == this.chkEnablePaging && jComponentArray[i] != this.lblPageSize && jComponentArray[i] != this.tfPageSize) {
                boolean bl3 = bl2 = bl2 && this.getPagingRows() > 0;
            }
            if (jComponent == this.comboNav && (jComponentArray[i].equals(this.btnBrowseFirst) || jComponentArray[i].equals(this.btnBrowsePrevious) || jComponentArray[i].equals(this.btnBrowseNext) || jComponentArray[i].equals(this.btnBrowseLast))) {
                bl2 = bl2 && HtmlDataTableState.BUTTON_IMAGE.equals(string);
            }
            jComponentArray[i].setEnabled(bl2);
            if (jComponentArray[i] instanceof JTextField) {
                jComponentArray[i].setBackground(bl2 ? SystemColor.text : SystemColor.control);
            }
            this.setDependentsEnabled(jComponentArray[i]);
        }
    }

    private Frame getParentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private class URLDialog
    extends JDialog {
        private JButton btnOk;
        private JButton btnCancel;
        private StandardUrlPanel urlPanel;
        private String urlString;

        public URLDialog(Frame frame, StandardUrlPanel standardUrlPanel) {
            super(frame, bundle.getMessage("urlDlgTitle"), true);
            this.urlPanel = standardUrlPanel;
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    URLDialog.this.dialogActionPerformed(actionEvent);
                }
            };
            JPanel jPanel = new JPanel();
            ((FlowLayout)jPanel.getLayout()).setAlignment(2);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
            jPanel.add(jPanel2);
            this.btnOk = new JButton(bundle.getMessage("okCaps"));
            this.btnCancel = new JButton(bundle.getMessage("cancel"));
            this.btnOk.addActionListener(actionListener);
            this.btnCancel.addActionListener(actionListener);
            jPanel2.add(this.btnOk);
            jPanel2.add(this.btnCancel);
            this.getContentPane().add((Component)standardUrlPanel);
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            this.setResizable(true);
            this.setLocationRelativeTo(frame);
        }

        public void dialogActionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.btnOk) {
                Object object = this.urlPanel.getPropertyValue();
                if (object == null) {
                    this.urlString = null;
                }
                this.urlString = object instanceof String ? (String)object : object.toString();
                this.dispose();
            } else if (actionEvent.getSource() == this.btnCancel) {
                this.dispose();
            }
        }

        public String getUrlString() {
            return this.urlString;
        }
    }
}

