/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

public class CodeUncommentAction
extends ExtKit.UncommentAction {
    public CodeUncommentAction() {
        super("");
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            Caret caret = jTextComponent.getCaret();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            if (tokenHierarchy == null) {
                return;
            }
            final TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            try {
                if (caret.isSelectionVisible()) {
                    final int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                    final int n2 = jTextComponent.getSelectionEnd();
                    baseDocument.runAtomicAsUser(new Runnable(){

                        public void run() {
                            try {
                                int n4 = n2 > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) == n2 ? n2 - 1 : n2;
                                int n22 = Utilities.getRowCount((BaseDocument)baseDocument, (int)n, (int)n4);
                                ArrayList<String> arrayList = new ArrayList<String>(n22);
                                int n3 = n;
                                for (int i = n22; i > 0; --i) {
                                    arrayList.add(CodeUncommentAction.this.getRealMimeType(tokenSequence, n3));
                                    n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3, (int)1);
                                }
                                n3 = n;
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    CodeUncommentAction.this.modifyLine(baseDocument, (String)iterator.next(), n3);
                                    n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3, (int)1);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                jTextComponent.getToolkit().beep();
                            }
                        }
                    });
                } else {
                    final int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                    final String string = this.getRealMimeType(tokenSequence, n);
                    baseDocument.runAtomicAsUser(new Runnable(){

                        public void run() {
                            try {
                                CodeUncommentAction.this.modifyLine(baseDocument, string, n);
                            }
                            catch (BadLocationException badLocationException) {
                                jTextComponent.getToolkit().beep();
                            }
                        }
                    });
                }
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    private String getRealMimeType(TokenSequence tokenSequence, int n) {
        while (true) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) break;
            n = tokenSequence.offset();
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) break;
            tokenSequence = tokenSequence2;
        }
        return tokenSequence.language().mimeType();
    }

    private void modifyLine(BaseDocument baseDocument, String string, int n) throws BadLocationException {
        Object object;
        Feature feature = null;
        try {
            object = LanguagesManager.getDefault().getLanguage(string);
            feature = ((Language)object).getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        if (feature != null) {
            CharSequence charSequence;
            int n2;
            int n3;
            object = (String)feature.getValue("prefix");
            if (object == null) {
                return;
            }
            String string2 = (String)feature.getValue("suffix");
            if (string2 != null && (n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) != -1) {
                n2 = string2.length();
                if (n3 - Utilities.getRowStart((BaseDocument)baseDocument, (int)n) >= n2 && CharSequenceUtilities.textEquals((CharSequence)(charSequence = DocumentUtilities.getText((Document)baseDocument, (int)(n3 - n2 + 1), (int)n2)), (CharSequence)string2)) {
                    baseDocument.remove(n3 - n2 + 1, n2);
                }
            }
            if ((n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) != -1) {
                n2 = ((String)object).length();
                if (Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3) - n3 >= ((String)object).length() && CharSequenceUtilities.textEquals((CharSequence)(charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n3, (int)n2)), (CharSequence)object)) {
                    baseDocument.remove(n3, n2);
                }
            }
        }
    }
}

