/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class GoToDeclarationAction
extends BaseAction {
    public GoToDeclarationAction() {
        super(NbBundle.getBundle(GoToDeclarationAction.class).getString("LBL_GoToDeclaration"));
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        Line line;
        Line.Set set;
        File file;
        JTextComponent jTextComponent2 = this.getTextComponent(null);
        if (jTextComponent2 == null) {
            return;
        }
        ASTNode aSTNode = this.getASTNode(jTextComponent2);
        if (aSTNode == null) {
            return;
        }
        NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent2.getDocument();
        int n = jTextComponent2.getCaretPosition();
        ASTPath aSTPath = aSTNode.findPath(n);
        DatabaseContext databaseContext = DatabaseManager.getRoot((ASTNode)aSTPath.getRoot());
        if (databaseContext == null) {
            return;
        }
        DatabaseItem databaseItem = databaseContext.getDatabaseItem(aSTPath.getLeaf().getOffset());
        if (databaseItem == null) {
            return;
        }
        if (databaseItem instanceof DatabaseUsage) {
            databaseItem = ((DatabaseUsage)databaseItem).getDefinition();
        }
        int n2 = databaseItem.getOffset();
        DataObject dataObject = null;
        Object object = null;
        URL uRL = ((DatabaseDefinition)databaseItem).getSourceFileUrl();
        if (uRL == null) {
            dataObject = NbEditorUtilities.getDataObject((Document)nbEditorDocument);
            object = nbEditorDocument;
        } else {
            file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            if (file != null && file.exists()) {
                file = FileUtil.normalizeFile((File)file);
                set = FileUtil.toFileObject((File)file);
                try {
                    dataObject = DataObject.find((FileObject)set);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObjectNotFoundException.printStackTrace();
                }
                if (dataObject != null) {
                    line = dataObject.getNodeDelegate();
                    EditorCookie editorCookie = (EditorCookie)line.getCookie(EditorCookie.class);
                    try {
                        object = editorCookie.openDocument();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        if (dataObject == null) {
            return;
        }
        file = (LineCookie)dataObject.getCookie(LineCookie.class);
        set = file.getLineSet();
        line = set.getCurrent(NbDocument.findLineNumber((StyledDocument)object, (int)n2));
        int n3 = NbDocument.findLineColumn((StyledDocument)object, (int)n2);
        line.show(2, n3);
    }

    public boolean isEnabled() {
        JTextComponent jTextComponent = this.getTextComponent(null);
        if (jTextComponent == null) {
            return false;
        }
        ASTNode aSTNode = this.getASTNode(jTextComponent);
        if (aSTNode == null) {
            return false;
        }
        int n = jTextComponent.getCaretPosition();
        ASTPath aSTPath = aSTNode.findPath(n);
        if (aSTPath == null) {
            return false;
        }
        DatabaseContext databaseContext = DatabaseManager.getRoot((ASTNode)aSTPath.getRoot());
        if (databaseContext == null) {
            return false;
        }
        DatabaseItem databaseItem = databaseContext.getDatabaseItem(aSTPath.getLeaf().getOffset());
        return databaseItem != null;
    }

    private ASTNode getASTNode(JTextComponent jTextComponent) {
        return ParserManagerImpl.getImpl((Document)((NbEditorDocument)jTextComponent.getDocument())).getAST();
    }
}

