/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper;

import com.nwoods.jgo.JGoGlobal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mapper.basicmapper.BasicMapperController;
import org.netbeans.modules.soa.mapper.basicmapper.BasicMapperModel;
import org.netbeans.modules.soa.mapper.basicmapper.BasicMapperRule;
import org.netbeans.modules.soa.mapper.basicmapper.BasicViewManager;
import org.netbeans.modules.soa.mapper.basicmapper.BasicViewModel;
import org.netbeans.modules.soa.mapper.basicmapper.MapperLink;
import org.netbeans.modules.soa.mapper.basicmapper.literal.BasicLiteralEditListener;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicAccumulatingMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicField;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicFieldNode;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicMethoid;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.palette.BasicMapperPalette;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperGroupNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperListener;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicController;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperLiteralUpdateEventInfo;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperRule;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewManager;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdaterFactory;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IField;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteView;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;

public class BasicMapper
extends JPanel
implements IBasicMapper {
    private static final Logger LOGGER = Logger.getLogger(BasicMapper.class.getName());
    private boolean painted = false;
    private JSplitPane leftSpliter;
    private IBasicController mMapperController;
    private IBasicMapperRule mMapperRule;
    private IPaletteView mPalette;
    private IBasicViewManager mViewManager;
    private JSplitPane rightSpliter;
    private float mInitRightDivLocWeight = 0.25f;
    private float mInitLeftDivLocWeight = 0.25f;
    private boolean mIsEnableMapping = true;
    private BasicLiteralEditListener mLiteralEditListener;

    public BasicMapper() {
        this.initializeInstances();
        this.leftSpliter = new JSplitPane(1);
        this.rightSpliter = new JSplitPane(1);
        this.rightSpliter.setRightComponent(this.getMapperViewManager().getDestView().getViewComponent());
        this.rightSpliter.setLeftComponent(this.leftSpliter);
        this.leftSpliter.setRightComponent(this.getMapperViewManager().getCanvasView().getViewComponent());
        this.leftSpliter.setLeftComponent(this.getMapperViewManager().getSourceView().getViewComponent());
        this.leftSpliter.setDividerSize(6);
        this.rightSpliter.setDividerSize(6);
        this.leftSpliter.setBorder(null);
        this.rightSpliter.setBorder(null);
        this.rightSpliter.setResizeWeight(1.0);
        this.leftSpliter.setResizeWeight(0.0);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.rightSpliter, "Center");
        this.setPalette(new BasicMapperPalette(this.getMapperViewManager()));
    }

    public static IBasicMapper newInstance() {
        return new BasicMapper();
    }

    public IBasicController getMapperController() {
        return this.mMapperController;
    }

    public IBasicMapperModel getMapperModel() {
        return this.getMapperViewManager().getMapperModel();
    }

    public IBasicMapperRule getMapperRule() {
        return this.mMapperRule;
    }

    public IBasicViewManager getMapperViewManager() {
        return this.mViewManager;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getMapperViewManager().getSourceView().getTree().setEnabled(bl);
        this.getMapperViewManager().getDestView().getTree().setEnabled(bl);
        this.getMapperViewManager().getCanvasView().getCanvas().getUIComponent().setEnabled(bl);
        if (this.getMapperViewManager().getPaletteView() != null) {
            this.getMapperViewManager().getPaletteView().getPaletteComponent().setEnabled(bl);
        }
    }

    public boolean isMappingEnable() {
        return this.mIsEnableMapping;
    }

    public void setMappingEnable(boolean bl) {
        this.mIsEnableMapping = bl;
        this.getMapperViewManager().getCanvasView().setIsMapable(bl);
        this.getMapperViewManager().getSourceView().setIsMapable(bl);
        this.getMapperViewManager().getDestView().setIsMapable(bl);
    }

    public void setMapperModel(IBasicMapperModel iBasicMapperModel) {
        ((BasicViewManager)this.getMapperViewManager()).setMapperModel(iBasicMapperModel);
    }

    public IBasicMapperModel createDefaultMapperModel() {
        BasicMapperModel basicMapperModel = new BasicMapperModel();
        IBasicViewModel iBasicViewModel = this.createDefaultViewModel();
        basicMapperModel.setSelectedViewModel(iBasicViewModel);
        return basicMapperModel;
    }

    public IBasicViewModel createDefaultViewModel() {
        return new BasicViewModel();
    }

    public void setMapperRule(IBasicMapperRule iBasicMapperRule) {
        if (this.mMapperRule != null) {
            this.removeMapperListener(this.mMapperRule);
        }
        this.mMapperRule = iBasicMapperRule;
        this.addMapperListener(this.mMapperRule);
    }

    public IPaletteView getPalette() {
        return this.mPalette;
    }

    public void setPalette(IPaletteView iPaletteView) {
        if (this.mPalette != null) {
            this.remove(this.mPalette.getViewComponent());
        }
        this.mPalette = iPaletteView;
        if (this.mPalette != null) {
            this.add(this.mPalette.getViewComponent(), "North");
            ((BasicViewManager)this.getMapperViewManager()).setPaletteView(this.mPalette);
            this.mPalette.getPaletteComponent().setEnabled(this.isEnabled());
        }
    }

    public IMapperLink createLink(IMapperNode iMapperNode, IMapperNode iMapperNode2) {
        MapperLink mapperLink = new MapperLink(iMapperNode, iMapperNode2);
        return mapperLink;
    }

    public void connectLink(IMapperLink iMapperLink) {
        if (iMapperLink.getStartNode() != null) {
            iMapperLink.getStartNode().addLink(iMapperLink);
        }
        if (iMapperLink.getEndNode() != null) {
            iMapperLink.getEndNode().addLink(iMapperLink);
        }
    }

    public IField createField(String string, String string2, String string3, Object object, boolean bl, boolean bl2, ILiteralUpdater iLiteralUpdater) {
        return new BasicField(string, string2, string3, object, bl, bl2, iLiteralUpdater);
    }

    public IFieldNode createFieldNode(IField iField) {
        return new BasicFieldNode(iField);
    }

    public IMethoidNode createMethoidNode(IMethoid iMethoid) {
        BasicMethoidNode basicMethoidNode = null;
        basicMethoidNode = iMethoid.isAccumulative() ? new BasicAccumulatingMethoidNode(iMethoid) : new BasicMethoidNode(iMethoid);
        return basicMethoidNode;
    }

    public IMapperEvent createMapperEvent(Object object, Object object2, String string, String string2) {
        return MapperUtilities.getMapperEvent(object, object2, string, string2);
    }

    public IMethoid createMethoid(Icon icon, String string, String string2, Object object, IField iField, List list, List list2, boolean bl, boolean bl2) {
        return new BasicMethoid(icon, string, string2, object, iField, list, list2, bl, bl2);
    }

    public IMapperTreeNode createMapperTreeNode(TreePath treePath, boolean bl) {
        if (bl) {
            return this.getMapperViewManager().getSourceView().getMapperTreeNode(treePath);
        }
        return this.getMapperViewManager().getDestView().getMapperTreeNode(treePath);
    }

    public void addLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        IMapperNode iMapperNode2 = iMapperLink.getEndNode();
        this.connectLink(iMapperLink);
        if (this.getMapperViewManager().getMapperModel() != null && this.getMapperViewManager().getMapperModel().getSelectedViewModel() != null) {
            IMapperNode iMapperNode3;
            IBasicViewModel iBasicViewModel = this.getMapperViewManager().getMapperModel().getSelectedViewModel();
            if (iMapperNode != null) {
                iMapperNode3 = iMapperNode;
                while (iMapperNode3.getGroupNode() != null) {
                    iMapperNode3 = iMapperNode3.getGroupNode();
                }
                if (!iBasicViewModel.containsNode(iMapperNode3)) {
                    this.addNode(iMapperNode3);
                }
            }
            if (iMapperNode2 != null) {
                iMapperNode3 = iMapperNode2;
                while (iMapperNode3.getGroupNode() != null) {
                    iMapperNode3 = iMapperNode3.getGroupNode();
                }
                if (!iBasicViewModel.containsNode(iMapperNode3)) {
                    this.addNode(iMapperNode3);
                }
            }
        }
        this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent(this, iMapperLink, "MapperEvt.LinkAdded", "New Link added to mapper"));
    }

    public void addNode(IMapperNode iMapperNode) {
        if (this.getMapperViewManager().getMapperModel() != null && this.getMapperViewManager().getMapperModel().getSelectedViewModel() != null) {
            IBasicViewModel iBasicViewModel = this.getMapperViewManager().getMapperModel().getSelectedViewModel();
            iBasicViewModel.addNode(iMapperNode);
            this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent(this, iMapperNode, "MapperEvt.NodeAdded", "New Node added to mapper"));
        }
    }

    public void removeLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        IMapperNode iMapperNode2 = iMapperLink.getEndNode();
        if (iMapperNode != null) {
            iMapperNode.removeLink(iMapperLink);
        }
        if (iMapperNode2 != null) {
            iMapperNode2.removeLink(iMapperLink);
        }
        if (this.getMapperViewManager().getMapperModel() != null && this.getMapperViewManager().getMapperModel().getSelectedViewModel() != null) {
            IBasicViewModel iBasicViewModel = this.getMapperViewManager().getMapperModel().getSelectedViewModel();
            if (iMapperNode instanceof IMapperTreeNode && iMapperNode.getLinkCount() == 0) {
                iBasicViewModel.removeNode(iMapperNode);
            }
            if (iMapperNode2 instanceof IMapperTreeNode && iMapperNode2.getLinkCount() == 0) {
                iBasicViewModel.removeNode(iMapperNode2);
            }
        }
        this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent(this, iMapperLink, "MapperEvt.LinkDel", "Link removed from mapper"));
    }

    public void removeNode(IMapperNode iMapperNode) {
        IBasicViewModel iBasicViewModel;
        if (this.getMapperViewManager().getMapperModel() != null && this.getMapperViewManager().getMapperModel().getSelectedViewModel() != null && (iBasicViewModel = this.getMapperViewManager().getMapperModel().getSelectedViewModel()).containsNode(iMapperNode)) {
            this.removeNodeLinks(iMapperNode);
            iBasicViewModel.removeNode(iMapperNode);
            this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent(this, iMapperNode, "MapperEvt.NodeDel", "Node removed from mapper"));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.painted = true;
    }

    public void doLayout() {
        super.doLayout();
        if (!this.painted && this.getWidth() > 0) {
            int n = this.getWidth();
            int n2 = 0;
            int n3 = 0;
            if (this.mInitLeftDivLocWeight == 1.0f) {
                n2 = n;
                n3 = n;
            } else if (this.mInitRightDivLocWeight != 1.0f) {
                n2 = (int)((float)n * (1.0f - this.mInitRightDivLocWeight));
                n3 = (int)((float)n * this.mInitLeftDivLocWeight);
            }
            LOGGER.fine("leftSpliter divider=" + n3);
            LOGGER.fine("rightSpliter divider=" + n2);
            this.rightSpliter.setDividerLocation(n2);
            this.leftSpliter.setDividerLocation(n3);
        }
    }

    public void setInitialDestTreeViewableWeight(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Initial dest tree viewable weight cannot lesser than 0.0");
        }
        if (f > 1.0f) {
            throw new IllegalArgumentException("Initial dest tree viewable weight cannot greater than 1.0");
        }
        this.mInitRightDivLocWeight = f;
    }

    public void setInitialSourceTreeViewableWeight(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Initial source tree viewable weight cannot lesser than zero");
        }
        if (f > 1.0f) {
            throw new IllegalArgumentException("Initial source tree viewable weight cannot greater than 1.0");
        }
        this.mInitLeftDivLocWeight = f;
    }

    public float getInitialDestTreeViewableWeight() {
        return this.mInitRightDivLocWeight;
    }

    public float getInitialSourceTreeViewableWeight() {
        return this.mInitRightDivLocWeight;
    }

    public IBasicMapperRule createDefaultMapperRule() {
        return new BasicMapperRule(this);
    }

    public Component getVisualMapper() {
        return this;
    }

    public void addMapperListener(IMapperListener iMapperListener) {
        this.mMapperController.addMapperListener(iMapperListener);
    }

    public void removeMapperListener(IMapperListener iMapperListener) {
        this.mMapperController.removeMapperListener(iMapperListener);
    }

    public IMapperLink copyDirectedChain(IMapperLink iMapperLink, IBasicViewModel iBasicViewModel) {
        return this.copyDirectedChain(iMapperLink, iBasicViewModel, new HashMap());
    }

    public IMapperNode copyDirectedChain(IMapperNode iMapperNode, IBasicViewModel iBasicViewModel) {
        return this.copyDirectedChain(iMapperNode, iBasicViewModel, new HashMap());
    }

    protected IMapperLink copyDirectedChain(IMapperLink iMapperLink, IBasicViewModel iBasicViewModel, Map map) {
        if (map.containsKey(iMapperLink)) {
            return (IMapperLink)map.get(iMapperLink);
        }
        MapperLink mapperLink = new MapperLink();
        map.put(iMapperLink, mapperLink);
        IMapperNode iMapperNode = this.copyDirectedChain(iMapperLink.getStartNode(), iBasicViewModel, map);
        IMapperNode iMapperNode2 = this.copyDirectedChain(iMapperLink.getEndNode(), iBasicViewModel, map);
        mapperLink.setStartNode(iMapperNode);
        mapperLink.setEndNode(iMapperNode2);
        iMapperNode.addLink(mapperLink);
        iMapperNode2.addLink(mapperLink);
        return mapperLink;
    }

    public IMapperNode copyDirectedChain(IMapperNode iMapperNode, IBasicViewModel iBasicViewModel, Map map) {
        if (map.containsKey(iMapperNode)) {
            return (IMapperNode)map.get(iMapperNode);
        }
        IMapperNode iMapperNode2 = null;
        if (iMapperNode instanceof IMapperTreeNode) {
            iMapperNode2 = this.cloneMapperTreeNode((IMapperTreeNode)iMapperNode, iBasicViewModel, map);
        } else if (iMapperNode instanceof IFieldNode) {
            iMapperNode2 = this.cloneFieldNode((IFieldNode)iMapperNode, iBasicViewModel, map);
        } else if (iMapperNode instanceof IMethoidNode) {
            iMapperNode2 = this.cloneMethoidNode((IMethoidNode)iMapperNode, iBasicViewModel, map);
        }
        return iMapperNode2;
    }

    protected IFieldNode cloneFieldNode(IFieldNode iFieldNode, IBasicViewModel iBasicViewModel, Map map) {
        IMapperGroupNode iMapperGroupNode = iFieldNode.getGroupNode();
        IMapperGroupNode iMapperGroupNode2 = (IMapperGroupNode)this.copyDirectedChain(iMapperGroupNode, iBasicViewModel, map);
        return (IFieldNode)map.get(iFieldNode);
    }

    protected IMapperNode cloneMethoidNode(IMethoidNode iMethoidNode, IBasicViewModel iBasicViewModel, Map map) {
        IMethoidNode iMethoidNode2 = (IMethoidNode)iMethoidNode.clone();
        map.put(iMethoidNode, iMethoidNode2);
        iBasicViewModel.addNode(iMethoidNode2);
        IMapperNode iMapperNode = iMethoidNode2.getFirstNode();
        IMapperNode iMapperNode2 = iMethoidNode.getFirstNode();
        while (iMapperNode2 != null && iMapperNode != null) {
            map.put(iMapperNode2, iMapperNode);
            iMapperNode = iMethoidNode2.getNextNode(iMapperNode);
            iMapperNode2 = iMethoidNode.getNextNode(iMapperNode2);
        }
        iMapperNode2 = iMethoidNode.getFirstNode();
        while (iMapperNode2 != null) {
            List list = iMapperNode2.getLinks();
            for (int i = 0; i < list.size(); ++i) {
                this.copyDirectedChain((IMapperLink)list.get(i), iBasicViewModel, map);
            }
            iMapperNode2 = iMethoidNode.getNextNode(iMapperNode2);
        }
        return iMethoidNode2;
    }

    protected IMapperTreeNode cloneMapperTreeNode(IMapperTreeNode iMapperTreeNode, IBasicViewModel iBasicViewModel, Map map) {
        IMapperTreeNode iMapperTreeNode2 = (IMapperTreeNode)iMapperTreeNode.clone();
        iBasicViewModel.addNode(iMapperTreeNode2);
        map.put(iMapperTreeNode, iMapperTreeNode2);
        return iMapperTreeNode2;
    }

    public void moveDirectedChain(IMapperLink iMapperLink, IBasicViewModel iBasicViewModel, IBasicViewModel iBasicViewModel2) {
        this.moveDirectedChain(iMapperLink, iBasicViewModel, iBasicViewModel2, new HashMap());
    }

    public void moveDirectedChain(IMapperLink iMapperLink, IBasicViewModel iBasicViewModel, IBasicViewModel iBasicViewModel2, Map map) {
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        IMapperNode iMapperNode2 = iMapperLink.getEndNode();
        iMapperNode.removeLink(iMapperLink);
        iMapperNode2.removeLink(iMapperLink);
        if (!map.containsKey(iMapperNode)) {
            this.moveDirectedChain(iMapperNode, iBasicViewModel, iBasicViewModel2, map);
        }
        if ((iMapperNode = (IMapperNode)map.get(iMapperNode)) != null) {
            iMapperLink.setStartNode(iMapperNode);
            iMapperNode.addLink(iMapperLink);
        }
        if (!map.containsKey(iMapperNode2)) {
            this.moveDirectedChain(iMapperNode2, iBasicViewModel, iBasicViewModel2, map);
        }
        if ((iMapperNode2 = (IMapperNode)map.get(iMapperNode2)) != null) {
            iMapperLink.setEndNode(iMapperNode2);
            iMapperNode2.addLink(iMapperLink);
        }
    }

    public void moveDirectedChain(IMapperNode iMapperNode, IBasicViewModel iBasicViewModel, IBasicViewModel iBasicViewModel2) {
        this.moveDirectedChain(iMapperNode, iBasicViewModel, iBasicViewModel2, new HashMap());
    }

    public void moveDirectedChain(IMapperNode iMapperNode, IBasicViewModel iBasicViewModel, IBasicViewModel iBasicViewModel2, Map map) {
        if (iMapperNode instanceof IMapperTreeNode && iMapperNode.getLinkCount() <= 0 && iBasicViewModel.containsNode(iMapperNode)) {
            iBasicViewModel.removeNode(iMapperNode);
        }
        if (map.containsKey(iMapperNode)) {
            return;
        }
        if (iMapperNode instanceof IMapperTreeNode) {
            IMapperNode iMapperNode2 = iMapperNode.getLinkCount() <= 0 ? iMapperNode : (IMapperTreeNode)iMapperNode.clone();
            map.put(iMapperNode, iMapperNode2);
            iBasicViewModel2.addNode(iMapperNode2);
        } else if (iMapperNode instanceof IFieldNode) {
            this.moveDirectedChain(iMapperNode.getGroupNode(), iBasicViewModel, iBasicViewModel2, map);
        } else if (iMapperNode instanceof IMethoidNode) {
            IMethoidNode iMethoidNode = (IMethoidNode)iMapperNode;
            IMapperNode iMapperNode3 = iMethoidNode.getFirstNode();
            while (iMapperNode3 != null) {
                map.put(iMapperNode3, iMapperNode3);
                List list = iMapperNode3.getLinks();
                for (int i = 0; i < list.size(); ++i) {
                    IMapperLink iMapperLink = (IMapperLink)list.get(i);
                    this.moveDirectedChain(iMapperLink, iBasicViewModel, iBasicViewModel2, map);
                }
                iMapperNode3 = iMethoidNode.getNextNode(iMapperNode3);
            }
            map.put(iMethoidNode, iMethoidNode);
            if (iBasicViewModel.containsNode(iMethoidNode)) {
                iBasicViewModel.removeNode(iMethoidNode);
            }
            if (!iBasicViewModel2.containsNode(iMethoidNode)) {
                iBasicViewModel2.addNode(iMethoidNode);
            }
        }
    }

    public void addObjectsToModel(Collection collection, IBasicViewModel iBasicViewModel) {
        for (Object object : collection) {
            if (object instanceof IMapperLink) {
                this.connectLink((IMapperLink)object);
                continue;
            }
            if (!(object instanceof IMapperNode)) continue;
            while (((IMapperNode)object).getGroupNode() != null) {
                object = ((IMapperNode)object).getGroupNode();
            }
            iBasicViewModel.addNode((IMapperNode)object);
        }
    }

    public void removeDirectedChain(IMapperLink iMapperLink, IBasicViewModel iBasicViewModel) {
        this.removeDirectedChain(iMapperLink, iBasicViewModel, new ArrayList());
    }

    public void close() {
        this.mMapperController.releaseControl();
        if (this.mPalette != null) {
            this.mPalette.close();
        }
        if (JGoGlobal.getComponent() == this.mViewManager.getCanvasView().getCanvas()) {
            JGoGlobal.setComponent(null);
        }
    }

    protected void removeDirectedChain(IMapperLink iMapperLink, IBasicViewModel iBasicViewModel, List list) {
        if (!list.contains(iMapperLink)) {
            list.add(iMapperLink);
        }
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        IMapperNode iMapperNode2 = iMapperLink.getEndNode();
        iMapperNode.removeLink(iMapperLink);
        iMapperNode2.removeLink(iMapperLink);
        this.removeDirectedChain(iMapperNode, iBasicViewModel, list);
        this.removeDirectedChain(iMapperNode2, iBasicViewModel, list);
    }

    public void removeDirectedChain(IMapperNode iMapperNode, IBasicViewModel iBasicViewModel) {
        this.removeDirectedChain(iMapperNode, iBasicViewModel, new ArrayList());
    }

    protected void removeDirectedChain(IMapperNode iMapperNode, IBasicViewModel iBasicViewModel, List list) {
        if (iMapperNode.getGroupNode() != null) {
            this.removeDirectedChain(iMapperNode.getGroupNode(), iBasicViewModel, list);
            List list2 = iMapperNode.getLinks();
            for (int i = 0; i < list2.size(); ++i) {
                this.removeDirectedChain((IMapperLink)list2.get(i), iBasicViewModel, list);
            }
        } else if (iMapperNode instanceof IMapperGroupNode) {
            if (iBasicViewModel.containsNode(iMapperNode)) {
                iBasicViewModel.removeNode(iMapperNode);
                list.add(iMapperNode);
                IMapperNode iMapperNode2 = ((IMapperGroupNode)iMapperNode).getFirstNode();
                while (iMapperNode2 != null) {
                    this.removeDirectedChain(iMapperNode2, iBasicViewModel, list);
                    iMapperNode2 = ((IMapperGroupNode)iMapperNode).getNextNode(iMapperNode2);
                }
            }
        } else if (iMapperNode instanceof IMapperTreeNode) {
            if (!list.contains(iMapperNode)) {
                list.add(iMapperNode);
            }
            if (iMapperNode.getLinkCount() == 0) {
                iBasicViewModel.removeNode(iMapperNode);
            }
        }
    }

    protected void removeGroupNodeLinks(IMapperGroupNode iMapperGroupNode) {
        IMapperNode iMapperNode = iMapperGroupNode.getFirstNode();
        while (iMapperNode != null) {
            this.removeNodeLinks(iMapperNode);
            iMapperNode = iMapperGroupNode.getNextNode(iMapperNode);
        }
    }

    protected void removeNodeLinks(IMapperNode iMapperNode) {
        if (iMapperNode instanceof IMapperGroupNode) {
            this.removeGroupNodeLinks((IMapperGroupNode)iMapperNode);
        }
        List list = iMapperNode.getLinks();
        for (int i = 0; i < list.size(); ++i) {
            this.removeLink((IMapperLink)list.get(i));
        }
    }

    private synchronized void initializeInstances() {
        this.mViewManager = new BasicViewManager();
        this.setMapperModel(this.createDefaultMapperModel());
        this.mMapperController = new BasicMapperController(this.getMapperViewManager());
        this.setMapperRule(this.createDefaultMapperRule());
    }

    public void setLiteralUpdaterFactory(ILiteralUpdaterFactory iLiteralUpdaterFactory) {
        Object object;
        if (this.mPalette instanceof BasicMapperPalette) {
            object = (BasicMapperPalette)this.mPalette;
            ((BasicMapperPalette)object).setLiteralUpdaterFactory(iLiteralUpdaterFactory);
        }
        if (this.mLiteralEditListener == null) {
            object = this.getMapperViewManager().getCanvasView();
            this.mLiteralEditListener = new BasicLiteralEditListener(this);
            object.getCanvas().addCanvasMouseListener(this.mLiteralEditListener);
        }
    }

    public void updateFieldLiteral(IBasicMapperLiteralUpdateEventInfo iBasicMapperLiteralUpdateEventInfo) {
        this.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent(this, iBasicMapperLiteralUpdateEventInfo, "BasicMapperEvt.NodeDel", "Field literal set: " + iBasicMapperLiteralUpdateEventInfo.getFieldNode()));
    }

    static {
        JGoGlobal.setup();
    }
}

