/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.literal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import org.netbeans.modules.soa.mapper.basicmapper.literal.AbstractLiteralEditor;
import org.netbeans.modules.soa.mapper.basicmapper.literal.NumberField;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;

public class StrictNumericLiteralEditor
extends AbstractLiteralEditor {
    private NumberField mEditorComponent = new NumberField(2);

    public StrictNumericLiteralEditor(Window window, IBasicMapper iBasicMapper, IFieldNode iFieldNode, ILiteralUpdater iLiteralUpdater) {
        super(window, iBasicMapper, iFieldNode, iLiteralUpdater);
        this.mEditorComponent.setHorizontalAlignment(4);
        this.mEditorComponent.setText(iFieldNode.getLiteralName());
        this.initializeLiteralComponent(iBasicMapper.getMapperViewManager().getCanvasView(), this.mEditorComponent, this.mEditorComponent);
        if (this.mIsLiteralMethoid) {
            this.mEditorComponent.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        } else {
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(1, 2, 1, 1));
            this.mEditorComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), compoundBorder));
        }
        int n = this.mEditorComponent.getText().length();
        this.mEditorComponent.setCaretPosition(n);
        this.mEditorComponent.moveCaretPosition(0);
        this.getContentPane().add(this.mEditorComponent);
        this.mEditorComponent.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "up");
        this.mEditorComponent.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "down");
        this.mEditorComponent.getActionMap().put("up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StrictNumericLiteralEditor.this.modifyFieldValue(1);
            }
        });
        this.mEditorComponent.getActionMap().put("down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StrictNumericLiteralEditor.this.modifyFieldValue(-1);
            }
        });
    }

    private void modifyFieldValue(int n) {
        String string = this.mEditorComponent.getText();
        ILiteralUpdater.LiteralSubTypeInfo literalSubTypeInfo = this.mUpdateListener.getLiteralSubType(string);
        if (literalSubTypeInfo != null) {
            Number number = null;
            try {
                number = NumberFormat.getInstance().parse(string);
            }
            catch (ParseException parseException) {
                return;
            }
            long l = number.longValue();
            this.mEditorComponent.setText(String.valueOf(l += (long)n));
        }
    }

    protected Dimension getInitialSize() {
        Dimension dimension = this.mCanvasFieldNode.getBounding().getSize();
        return new Dimension(dimension.width, dimension.height);
    }

    protected String updateLiteral() {
        String string = this.mEditorComponent.getText();
        if (string.length() >= 1) {
            return string;
        }
        return null;
    }
}

