/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.tree;

import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mapper.basicmapper.tree.AbstractMapperTree;
import org.netbeans.modules.soa.mapper.basicmapper.tree.BasicMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;

public class DestTree
extends AbstractMapperTree {
    public DestTree() {
        this(null);
    }

    public DestTree(TreeModel treeModel) {
        super(treeModel);
        this.initialize();
    }

    public IMapperTreeNode createMapperTreeNode(TreePath treePath) {
        return this.newMapperTreeNode(treePath);
    }

    protected IMapperTreeNode newMapperTreeNode(TreePath treePath) {
        return new BasicMapperTreeNode(this, treePath, false, true);
    }

    public boolean contains(IMapperTreeNode iMapperTreeNode) {
        return iMapperTreeNode.isDestTreeNode();
    }

    public Point getTreeNodePoint(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        int n = rectangle.y + rectangle.height / 2;
        int n2 = rectangle.x;
        return new Point(n2, n);
    }

    protected void drawNode(Graphics graphics, IMapperTreeNode iMapperTreeNode) {
        if (iMapperTreeNode.getLinkCount() <= 0) {
            return;
        }
        List list = iMapperTreeNode.getLinks();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((IMapperLink)list.get(i)).getEndNode().equals(iMapperTreeNode)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        TreePath treePath = iMapperTreeNode.getPath();
        Rectangle rectangle = this.getShowingPathRectBound(treePath);
        if (rectangle == null) {
            return;
        }
        Point point = this.getTreeNodePoint(rectangle);
        if (point == null) {
            return;
        }
        boolean bl2 = !rectangle.equals(this.getTree().getPathBounds(treePath));
        this.drawLine(iMapperTreeNode, bl2, graphics, 0, point.y, rectangle.x, point.y);
        int n = point.x - 8;
        this.drawArrow(iMapperTreeNode, graphics, point.x, point.y, n, point.y);
        int n2 = this.getScrollerPane().getViewport().getViewPosition().y;
        iMapperTreeNode.setX(point.x);
        iMapperTreeNode.setY(point.y - n2);
    }

    private void drawArrow(IMapperTreeNode iMapperTreeNode, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.getDrawColor(iMapperTreeNode));
        Polygon polygon = new Polygon();
        polygon.addPoint(n3, n4 - 3);
        polygon.addPoint(n, n2);
        polygon.addPoint(n3, n4 + 3);
        graphics.fillPolygon(polygon);
        graphics.setColor(color);
    }

    private void initialize() {
        this.getTree().setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.getScrollerPane().setPreferredSize(new Dimension(250, 100));
    }

    protected void highlightSingleLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        JGoObject jGoObject = (JGoObject)this.getViewManager().getCanvasView().getCanvas().getCanvasNodeByDataObject(iMapperNode);
        if (jGoObject != null) {
            ((JGoView)this.getViewManager().getCanvasView().getCanvas()).scrollRectToVisible(jGoObject.getBoundingRect());
        } else if (iMapperNode instanceof IMapperTreeNode) {
            IMapperTreeNode iMapperTreeNode = (IMapperTreeNode)iMapperNode;
            this.scrollToSingleTreeNode(iMapperTreeNode);
            this.highlightSingleTreeNode(iMapperTreeNode);
        }
    }

    protected void unHighlightSingleLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getStartNode();
        if (iMapperNode instanceof IMapperTreeNode) {
            IMapperTreeNode iMapperTreeNode = (IMapperTreeNode)iMapperNode;
            this.unHighlightSingleTreeNode(iMapperTreeNode);
        }
    }

    private void highlightSingleTreeNode(IMapperTreeNode iMapperTreeNode) {
        iMapperTreeNode.setHighlightLink(true);
        this.getViewManager().getSourceView().getTree().repaint();
    }

    private void unHighlightSingleTreeNode(IMapperTreeNode iMapperTreeNode) {
        iMapperTreeNode.setHighlightLink(false);
        this.getViewManager().getSourceView().getTree().repaint();
    }

    private void scrollToSingleTreeNode(IMapperTreeNode iMapperTreeNode) {
        this.getViewManager().getSourceView().getTree().scrollPathToVisible(iMapperTreeNode.getPath());
    }
}

