/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstChildrenSupport
implements GroovyCodeVisitor {
    private List<ASTNode> children = new ArrayList<ASTNode>();

    public List<ASTNode> children() {
        return this.children;
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) {
        List list = blockStatement.getStatements();
        for (Statement statement : list) {
            this.children.add(statement);
        }
    }

    @Override
    public void visitForLoop(ForStatement forStatement) {
        this.children.add(forStatement.getCollectionExpression());
        this.children.add(forStatement.getLoopBlock());
    }

    @Override
    public void visitWhileLoop(WhileStatement whileStatement) {
        this.children.add(whileStatement.getBooleanExpression());
        this.children.add(whileStatement.getLoopBlock());
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement doWhileStatement) {
        this.children.add(doWhileStatement.getLoopBlock());
        this.children.add(doWhileStatement.getBooleanExpression());
    }

    @Override
    public void visitIfElse(IfStatement ifStatement) {
        this.children.add(ifStatement.getBooleanExpression());
        this.children.add(ifStatement.getIfBlock());
        this.children.add(ifStatement.getElseBlock());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement expressionStatement) {
        this.children.add(expressionStatement.getExpression());
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        this.children.add(returnStatement.getExpression());
    }

    @Override
    public void visitAssertStatement(AssertStatement assertStatement) {
        this.children.add(assertStatement.getBooleanExpression());
        this.children.add(assertStatement.getMessageExpression());
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement tryCatchStatement) {
        this.children.add(tryCatchStatement.getTryStatement());
        List list = tryCatchStatement.getCatchStatements();
        for (CatchStatement catchStatement : list) {
            this.children.add(catchStatement);
        }
        this.children.add(tryCatchStatement.getFinallyStatement());
    }

    @Override
    public void visitSwitch(SwitchStatement switchStatement) {
        this.children.add(switchStatement.getExpression());
        List list = switchStatement.getCaseStatements();
        for (CaseStatement caseStatement : list) {
            this.children.add(caseStatement);
        }
        this.children.add(switchStatement.getDefaultStatement());
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        this.children.add(caseStatement.getExpression());
        this.children.add(caseStatement.getCode());
    }

    @Override
    public void visitBreakStatement(BreakStatement breakStatement) {
    }

    @Override
    public void visitContinueStatement(ContinueStatement continueStatement) {
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
        this.children.add(synchronizedStatement.getExpression());
        this.children.add(synchronizedStatement.getCode());
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        this.children.add(throwStatement.getExpression());
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        this.children.add(methodCallExpression.getObjectExpression());
        this.children.add(methodCallExpression.getMethod());
        this.children.add(methodCallExpression.getArguments());
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression staticMethodCallExpression) {
        this.children.add(staticMethodCallExpression.getArguments());
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression constructorCallExpression) {
        this.children.add(constructorCallExpression.getArguments());
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.children.add(binaryExpression.getLeftExpression());
        this.children.add(binaryExpression.getRightExpression());
    }

    @Override
    public void visitTernaryExpression(TernaryExpression ternaryExpression) {
        this.children.add(ternaryExpression.getBooleanExpression());
        this.children.add(ternaryExpression.getTrueExpression());
        this.children.add(ternaryExpression.getFalseExpression());
    }

    @Override
    public void visitShortTernaryExpression(ElvisOperatorExpression elvisOperatorExpression) {
        this.visitTernaryExpression(elvisOperatorExpression);
    }

    @Override
    public void visitPostfixExpression(PostfixExpression postfixExpression) {
        this.children.add(postfixExpression.getExpression());
    }

    @Override
    public void visitPrefixExpression(PrefixExpression prefixExpression) {
        this.children.add(prefixExpression.getExpression());
    }

    @Override
    public void visitBooleanExpression(BooleanExpression booleanExpression) {
        this.children.add(booleanExpression.getExpression());
    }

    @Override
    public void visitNotExpression(NotExpression notExpression) {
        this.children.add(notExpression.getExpression());
    }

    @Override
    public void visitClosureExpression(ClosureExpression closureExpression) {
        this.children.add(closureExpression.getCode());
    }

    @Override
    public void visitTupleExpression(TupleExpression tupleExpression) {
        this.visitListOfExpressions(tupleExpression.getExpressions());
    }

    @Override
    public void visitListExpression(ListExpression listExpression) {
        this.visitListOfExpressions(listExpression.getExpressions());
    }

    @Override
    public void visitArrayExpression(ArrayExpression arrayExpression) {
        this.visitListOfExpressions(arrayExpression.getExpressions());
        this.visitListOfExpressions(arrayExpression.getSizeExpression());
    }

    @Override
    public void visitMapExpression(MapExpression mapExpression) {
        this.visitListOfExpressions(mapExpression.getMapEntryExpressions());
    }

    @Override
    public void visitMapEntryExpression(MapEntryExpression mapEntryExpression) {
        this.children.add(mapEntryExpression.getKeyExpression());
        this.children.add(mapEntryExpression.getValueExpression());
    }

    @Override
    public void visitRangeExpression(RangeExpression rangeExpression) {
        this.children.add(rangeExpression.getFrom());
        this.children.add(rangeExpression.getTo());
    }

    @Override
    public void visitSpreadExpression(SpreadExpression spreadExpression) {
        this.children.add(spreadExpression.getExpression());
    }

    @Override
    public void visitSpreadMapExpression(SpreadMapExpression spreadMapExpression) {
        this.children.add(spreadMapExpression.getExpression());
    }

    @Override
    public void visitMethodPointerExpression(MethodPointerExpression methodPointerExpression) {
        this.children.add(methodPointerExpression.getExpression());
        this.children.add(methodPointerExpression.getMethodName());
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression unaryMinusExpression) {
        this.children.add(unaryMinusExpression.getExpression());
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression unaryPlusExpression) {
        this.children.add(unaryPlusExpression.getExpression());
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression bitwiseNegationExpression) {
        this.children.add(bitwiseNegationExpression.getExpression());
    }

    @Override
    public void visitCastExpression(CastExpression castExpression) {
        this.children.add(castExpression.getExpression());
    }

    @Override
    public void visitConstantExpression(ConstantExpression constantExpression) {
    }

    @Override
    public void visitClassExpression(ClassExpression classExpression) {
    }

    @Override
    public void visitVariableExpression(VariableExpression variableExpression) {
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        this.visitBinaryExpression(declarationExpression);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        this.children.add(propertyExpression.getObjectExpression());
        this.children.add(propertyExpression.getProperty());
    }

    @Override
    public void visitAttributeExpression(AttributeExpression attributeExpression) {
        this.children.add(attributeExpression.getObjectExpression());
        this.children.add(attributeExpression.getProperty());
    }

    @Override
    public void visitFieldExpression(FieldExpression fieldExpression) {
    }

    @Override
    public void visitRegexExpression(RegexExpression regexExpression) {
    }

    @Override
    public void visitGStringExpression(GStringExpression gStringExpression) {
        this.visitListOfExpressions(gStringExpression.getStrings());
        this.visitListOfExpressions(gStringExpression.getValues());
    }

    private void visitListOfExpressions(List list) {
        if (list == null) {
            return;
        }
        for (Expression expression : list) {
            if (expression instanceof SpreadExpression) {
                Expression expression2 = ((SpreadExpression)expression).getExpression();
                this.children.add(expression2);
                continue;
            }
            this.children.add(expression);
        }
    }

    @Override
    public void visitCatchStatement(CatchStatement catchStatement) {
        this.children.add(catchStatement.getCode());
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression argumentListExpression) {
        this.visitTupleExpression(argumentListExpression);
    }

    @Override
    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        this.visitListOfExpressions(closureListExpression.getExpressions());
    }
}

