/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.gsf.api.ParserResult;
import org.openide.util.Enumerations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstNodeAdapter
implements ParserResult.AstTreeNode {
    private final Logger LOG = Logger.getLogger(AstNodeAdapter.class.getName());
    private static final boolean HIDE_NEWLINE_NODES = false;
    private final ASTNode node;
    private final AstNodeAdapter parent;
    private AstNodeAdapter[] children;
    private BaseDocument doc;

    public AstNodeAdapter(AstNodeAdapter astNodeAdapter, ASTNode aSTNode, BaseDocument baseDocument) {
        this.parent = astNodeAdapter;
        this.node = aSTNode;
        this.doc = baseDocument;
        this.LOG.setLevel(Level.OFF);
    }

    private void ensureChildrenInitialized() {
        if (this.children != null) {
            return;
        }
        this.children = new AstNodeAdapter[0];
        List<ASTNode> list = AstUtilities.children(this.node);
        this.children = new AstNodeAdapter[list.size()];
        int n = 0;
        for (ASTNode aSTNode : list) {
            this.children[n++] = new AstNodeAdapter(this, aSTNode, this.doc);
        }
    }

    private void addChildren(List<AstNodeAdapter> list, ASTNode aSTNode) {
        List<ASTNode> list2 = AstUtilities.children(aSTNode);
        for (ASTNode aSTNode2 : list2) {
            list.add(new AstNodeAdapter(this, aSTNode2, this.doc));
        }
    }

    public TreeNode getChildAt(int n) {
        this.ensureChildrenInitialized();
        return this.children[n];
    }

    public int getChildCount() {
        this.ensureChildrenInitialized();
        return this.children.length;
    }

    public TreeNode getParent() {
        this.ensureChildrenInitialized();
        return this.parent;
    }

    public int getIndex(TreeNode treeNode) {
        this.LOG.log(Level.FINEST, "getIndex(), TreeNode : {0}", treeNode.toString());
        this.ensureChildrenInitialized();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        this.LOG.log(Level.FINEST, "getAllowsChildren()");
        this.ensureChildrenInitialized();
        return this.children.length > 0;
    }

    public boolean isLeaf() {
        this.ensureChildrenInitialized();
        this.LOG.log(Level.FINEST, "------------------------------------------------------");
        this.LOG.log(Level.FINEST, "isLeaf(), Name: {0}", this.node.getClass().getSimpleName());
        this.LOG.log(Level.FINEST, "isLeaf(), children: {0}", this.children.length);
        this.LOG.log(Level.FINEST, "------------------------------------------------------");
        return this.children.length == 0;
    }

    public Enumeration children() {
        this.ensureChildrenInitialized();
        return Enumerations.array((Object[])this.children);
    }

    private String getArtifactName(ASTNode aSTNode) {
        if (aSTNode instanceof ClassNode) {
            return ((ClassNode)aSTNode).getName();
        }
        if (aSTNode instanceof MethodNode) {
            return ((MethodNode)aSTNode).getName();
        }
        if (aSTNode instanceof VariableExpression) {
            return ((VariableExpression)aSTNode).getName();
        }
        if (aSTNode instanceof ModuleNode) {
            return ((ModuleNode)aSTNode).getDescription();
        }
        if (aSTNode instanceof ConstantExpression) {
            return ((ConstantExpression)aSTNode).getText();
        }
        return "";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.node.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append(this.getArtifactName(this.node));
        stringBuilder.append("]");
        stringBuilder.append(" (");
        stringBuilder.append(this.getStartOffset());
        stringBuilder.append("-");
        stringBuilder.append(this.getEndOffset());
        stringBuilder.append(") ");
        this.LOG.log(Level.FINEST, "toString() node: {0}", stringBuilder.toString());
        return stringBuilder.toString();
    }

    private void printLineNumbers() {
        this.LOG.log(Level.FINEST, "Line   : {0}", this.node.getLineNumber());
        this.LOG.log(Level.FINEST, "Column : {0}", this.node.getColumnNumber());
    }

    public int getStartOffset() {
        int n;
        this.printLineNumbers();
        int n2 = this.node.getLineNumber();
        if (n2 < 1) {
            n2 = 1;
        }
        if ((n = this.node.getColumnNumber()) < 1) {
            n = 1;
        }
        return AstUtilities.getOffset(this.doc, n2, n);
    }

    public int getEndOffset() {
        int n;
        this.printLineNumbers();
        int n2 = this.node.getLastLineNumber();
        if (n2 < 1) {
            n2 = 1;
        }
        if ((n = this.node.getLastColumnNumber()) < 1) {
            n = 1;
        }
        return AstUtilities.getOffset(this.doc, n2, n);
    }

    public Object getAstNode() {
        return this.node;
    }
}

