/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditorOptions;
import org.netbeans.modules.gsf.api.KeystrokeHandler;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BracketCompleter
implements KeystrokeHandler {
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("groovy.cont.comment");
    private static final TokenId[] STRING_TOKENS = new TokenId[]{GroovyTokenId.STRING_LITERAL, GroovyTokenId.STRING_END};
    private static final TokenId[] REGEXP_TOKENS = new TokenId[]{GroovyTokenId.REGEXP_LITERAL, GroovyTokenId.REGEXP_END};
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;

    public boolean isInsertMatchingEnabled(BaseDocument baseDocument) {
        EditorOptions editorOptions = EditorOptions.get((String)"text/x-groovy");
        if (editorOptions != null) {
            return editorOptions.getMatchBrackets();
        }
        return true;
    }

    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        boolean bl;
        int n2;
        int n3;
        String string;
        boolean bl2;
        int n4;
        int n5;
        Token<? extends GroovyTokenId> token;
        boolean bl3;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        boolean bl4 = this.isInsertMatchingEnabled(baseDocument);
        int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n7 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n6 == n && n7 == n) {
            return -1;
        }
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        Token token2 = tokenSequence.token();
        TokenId tokenId = token2.id();
        boolean[] blArray = new boolean[1];
        int[] nArray = new int[1];
        boolean bl5 = bl3 = bl4 && BracketCompleter.isEndMissing(baseDocument, n, false, blArray, null, nArray);
        if (bl3) {
            boolean bl6 = blArray[0];
            int n8 = nArray[0];
            int n9 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
            StringBuilder stringBuilder = new StringBuilder();
            if (n > n9) {
                stringBuilder.append("\n");
                stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n8));
            } else {
                String string2 = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n9) - n);
                stringBuilder.append(string2);
                stringBuilder.append("\n");
                stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n8));
                baseDocument.remove(n, string2.length());
            }
            if (bl6) {
                stringBuilder.append("}");
            }
            int n10 = n;
            baseDocument.insertString(n10, stringBuilder.toString(), null);
            caret.setDot(n10);
            return -1;
        }
        if (tokenId == GroovyTokenId.ERROR && (token = ((Object)token2.text()).toString()).startsWith("/*") && tokenSequence.offset() == Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) {
            int n11 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n11));
            stringBuilder.append(" * ");
            int n12 = stringBuilder.length() + 1;
            stringBuilder.append("\n");
            stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n11));
            stringBuilder.append(" */");
            baseDocument.insertString(n, stringBuilder.toString(), null);
            caret.setDot(n);
            return n + n12;
        }
        if (tokenId == GroovyTokenId.REGEXP_LITERAL || tokenId == GroovyTokenId.REGEXP_END && n < tokenSequence.offset() + tokenSequence.token().length()) {
            token = tokenId != GroovyTokenId.REGEXP_LITERAL || n > tokenSequence.offset() ? "\\n\\" : "\\";
            baseDocument.insertString(n, (String)token, null);
            caret.setDot(n + token.length());
            return n + 1 + token.length();
        }
        if ((tokenId == GroovyTokenId.RBRACE || tokenId == GroovyTokenId.RBRACKET) && n > 0 && (token = LexUtilities.getToken(baseDocument, n - 1)) != null) {
            GroovyTokenId groovyTokenId = (GroovyTokenId)token.id();
            if (tokenId == GroovyTokenId.RBRACE && groovyTokenId == GroovyTokenId.LBRACE || tokenId == GroovyTokenId.RBRACKET && groovyTokenId == GroovyTokenId.LBRACKET) {
                int n13 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n");
                stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n13));
                n5 = n;
                baseDocument.insertString(n5, stringBuilder.toString(), null);
                caret.setDot(n5);
            }
        }
        if (tokenId == GroovyTokenId.WHITESPACE && (n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) != -1 && n < n4) {
            tokenSequence.move(n4);
            if (tokenSequence.moveNext() && (tokenId = tokenSequence.token().id()) == GroovyTokenId.LINE_COMMENT) {
                n = n4;
            }
        }
        if (tokenId == GroovyTokenId.BLOCK_COMMENT && n > tokenSequence.offset() && ((bl2 = (string = baseDocument.getText(n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n), (n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1) - n3)).startsWith("/*")) || string.startsWith("*"))) {
            int n14;
            int n15;
            n5 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                ++n5;
            }
            stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n5));
            stringBuilder.append("*");
            int n16 = bl2 ? n3 + 2 : n3 + 1;
            string = baseDocument.getText(n16, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n16) - n16);
            for (n15 = 0; n15 < string.length() && ((n14 = string.charAt(n15)) == 32 || n14 == 9); ++n15) {
                stringBuilder.append((char)n14);
            }
            n15 = n;
            if (n == n3 && n15 > 0) {
                n15 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                n14 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n) + stringBuilder.length();
                baseDocument.insertString(n15, stringBuilder.toString(), null);
                caret.setDot(n14);
                return n14;
            }
            baseDocument.insertString(n15, stringBuilder.toString(), null);
            caret.setDot(n15);
            return n15 + stringBuilder.length() + 1;
        }
        boolean bl7 = bl = tokenId == GroovyTokenId.LINE_COMMENT;
        if (tokenId == GroovyTokenId.EOL && tokenSequence.movePrevious() && tokenSequence.token().id() == GroovyTokenId.LINE_COMMENT) {
            bl = true;
        }
        if (bl) {
            Token<? extends GroovyTokenId> token3;
            int n17;
            Token<? extends GroovyTokenId> token4;
            int n18;
            boolean bl8 = false;
            int n19 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            boolean bl9 = false;
            n5 = 0;
            int n20 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n20 > 0 && (n18 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)(n20 - 1))) != -1 && (token4 = LexUtilities.getToken(baseDocument, n18)) != null && token4.id() == GroovyTokenId.LINE_COMMENT) {
                bl9 = true;
            }
            if ((n18 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n)) < baseDocument.getLength() && (n17 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)(n18 + 1))) != -1 && (token3 = LexUtilities.getToken(baseDocument, n17)) != null && token3.id() == GroovyTokenId.LINE_COMMENT) {
                n5 = 1;
            }
            if (bl9 || n5 != 0 || n > tokenSequence.offset() && n < tokenSequence.offset() + tokenSequence.token().length()) {
                Token<? extends GroovyTokenId> token5;
                int n21;
                int n22;
                Token<? extends GroovyTokenId> token6;
                if (tokenSequence.offset() + token2.length() > n + 1) {
                    String string3 = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) - n);
                    if (string3.trim().length() != 0) {
                        bl8 = true;
                    }
                } else if (CONTINUE_COMMENTS && (token6 = LexUtilities.getToken(baseDocument, n19)).id() == GroovyTokenId.LINE_COMMENT) {
                    bl8 = true;
                }
                if (!bl8 && (n22 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1) < baseDocument.getLength() && (n21 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n22)) != -1 && (token5 = LexUtilities.getToken(baseDocument, n21)) != null && token5.id() == GroovyTokenId.LINE_COMMENT) {
                    bl8 = true;
                }
            }
            if (bl8) {
                int n23;
                int n24;
                int n25 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n25));
                stringBuilder.append("//");
                int n26 = n19 + 2;
                String string4 = baseDocument.getText(n26, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n26) - n26);
                for (n24 = 0; n24 < string4.length() && ((n23 = string4.charAt(n24)) == 32 || n23 == 9); ++n24) {
                    stringBuilder.append((char)n23);
                }
                n24 = n;
                if (n == n19 && n24 > 0) {
                    n24 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    n23 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n) + stringBuilder.length();
                    baseDocument.insertString(n24, stringBuilder.toString(), null);
                    caret.setDot(n23);
                    return n23;
                }
                baseDocument.insertString(n24, stringBuilder.toString(), null);
                caret.setDot(n24);
                return n24 + stringBuilder.length() + 1;
            }
        }
        return -1;
    }

    static boolean isEndMissing(BaseDocument baseDocument, int n, boolean bl, boolean[] blArray, int[] nArray, int[] nArray2) throws BadLocationException {
        int n2 = baseDocument.getLength();
        if (nArray != null) {
            nArray[0] = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        }
        int n3 = LexUtilities.getBeginEndLineBalance(baseDocument, n, true);
        int n4 = LexUtilities.getLineBalance(baseDocument, n, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE);
        if (n3 == 1 || n4 == 1) {
            int n5 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
            boolean bl2 = n4 > 0;
            int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1;
            while (n6 < n2) {
                if (!(Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n6) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n6) || LexUtilities.isCommentOnlyLine(baseDocument, n6))) {
                    int n7 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n6);
                    if (n7 > n5) {
                        bl2 = false;
                        break;
                    }
                    if (n7 != n5 || !bl2 || LexUtilities.getLineBalance(baseDocument, n6, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE) >= 0) break;
                    bl2 = false;
                    break;
                }
                n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n6) + 1;
            }
            if (blArray != null) {
                blArray[0] = bl2;
            }
            if (nArray2 != null) {
                nArray2[0] = n5;
            }
            return bl2;
        }
        return false;
    }

    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenSequence<? extends GroovyTokenId> tokenSequence;
        TokenSequence<? extends GroovyTokenId> tokenSequence2;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (!this.isInsertMatchingEnabled(baseDocument)) {
            return false;
        }
        if (jTextComponent.getSelectionStart() != -1) {
            String string;
            char c2;
            if (GsfUtilities.isCodeTemplateEditing((Document)baseDocument)) {
                int n2 = jTextComponent.getSelectionStart();
                if (n2 < (c2 = jTextComponent.getSelectionEnd())) {
                    jTextComponent.setSelectionStart(n2);
                    jTextComponent.setSelectionEnd(n2);
                    n = n2;
                    caret.setDot(n);
                    baseDocument.remove(n2, c2 - n2);
                }
            } else if ((c == '\"' || c == '\'' || c == '(' || c == '{' || c == '[' || c == '/') && (string = jTextComponent.getSelectedText()) != null && string.length() > 0 && (c2 = (char)string.charAt(0)) != c) {
                int n3 = jTextComponent.getSelectionStart();
                int n4 = jTextComponent.getSelectionEnd();
                tokenSequence2 = LexUtilities.getPositionedSequence(baseDocument, n3);
                if (tokenSequence2 != null && tokenSequence2.token().id() != GroovyTokenId.STRING_LITERAL) {
                    char c3 = string.charAt(string.length() - 1);
                    if (string.length() > 1 && (c2 == '\"' || c2 == '\'' || c2 == '(' || c2 == '{' || c2 == '[' || c2 == '/') && c3 == this.matching(c2)) {
                        baseDocument.remove(n4 - 1, 1);
                        baseDocument.insertString(n4 - 1, "" + this.matching(c), null);
                        baseDocument.remove(n3, 1);
                        baseDocument.insertString(n3, "" + c, null);
                        jTextComponent.getCaret().setDot(n4);
                    } else {
                        baseDocument.remove(n3, n4 - n3);
                        baseDocument.insertString(n3, c + string + this.matching(c), null);
                        jTextComponent.getCaret().setDot(n3 + string.length() + 2);
                    }
                    return true;
                }
            }
        }
        if ((tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n)) == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        TokenId[] tokenIdArray = null;
        tokenSequence2 = null;
        if (c == '\"' || c == '\'') {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = GroovyTokenId.STRING_BEGIN;
        } else if (tokenId == GroovyTokenId.ERROR) {
            tokenSequence.movePrevious();
            TokenSequence<? extends GroovyTokenId> tokenSequence3 = tokenSequence.token().id();
            if (tokenSequence3 == GroovyTokenId.STRING_BEGIN) {
                tokenIdArray = STRING_TOKENS;
                tokenSequence2 = tokenSequence3;
            } else if (tokenSequence3 == GroovyTokenId.REGEXP_BEGIN) {
                tokenIdArray = REGEXP_TOKENS;
                tokenSequence2 = GroovyTokenId.REGEXP_BEGIN;
            }
        } else if (tokenId == GroovyTokenId.STRING_BEGIN && n == tokenSequence.offset() + 1) {
            if (!Character.isLetter(c)) {
                tokenIdArray = STRING_TOKENS;
                tokenSequence2 = tokenId;
            }
        } else if (tokenId == GroovyTokenId.STRING_BEGIN && n == tokenSequence.offset() + 2 || tokenId == GroovyTokenId.STRING_END) {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = GroovyTokenId.STRING_BEGIN;
        } else if (tokenId == GroovyTokenId.REGEXP_BEGIN && n == tokenSequence.offset() + 2 || tokenId == GroovyTokenId.REGEXP_END) {
            tokenIdArray = REGEXP_TOKENS;
            tokenSequence2 = GroovyTokenId.REGEXP_BEGIN;
        }
        if (tokenIdArray != null) {
            boolean bl = this.completeQuote(baseDocument, n, caret, c, tokenIdArray, (TokenId)tokenSequence2);
            if (bl) {
                caret.setDot(n + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenSequence<? extends GroovyTokenId> tokenSequence;
        this.isAfter = true;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (this.previousAdjustmentOffset != -1) {
            if (n == this.previousAdjustmentOffset && (tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n)) != null) {
                tokenSequence.move(n);
                if (tokenSequence.moveNext() && tokenSequence.offset() < n) {
                    GsfUtilities.setLineIndentation((BaseDocument)baseDocument, (int)n, (int)this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (c) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                tokenSequence = LexUtilities.getToken(baseDocument, n);
                if (tokenSequence == null) {
                    return true;
                }
                TokenId tokenId = tokenSequence.id();
                if (tokenId == GroovyTokenId.ANY_OPERATOR) {
                    int n2 = tokenSequence.length();
                    String string = ((Object)tokenSequence.text()).toString();
                    if (n2 == 2 && "[]".equals(string) || "[]=".equals(string)) {
                        this.skipClosingBracket(baseDocument, caret, c, GroovyTokenId.RBRACKET);
                        return true;
                    }
                }
                if (tokenId == GroovyTokenId.IDENTIFIER && tokenSequence.length() == 1 || tokenId == GroovyTokenId.LBRACKET || tokenId == GroovyTokenId.RBRACKET || tokenId == GroovyTokenId.LBRACE || tokenId == GroovyTokenId.RBRACE || tokenId == GroovyTokenId.LPAREN || tokenId == GroovyTokenId.RPAREN) {
                    if (c == ']') {
                        this.skipClosingBracket(baseDocument, caret, c, GroovyTokenId.RBRACKET);
                    } else if (c == ')') {
                        this.skipClosingBracket(baseDocument, caret, c, GroovyTokenId.RPAREN);
                    } else if (c == '}') {
                        this.skipClosingBracket(baseDocument, caret, c, GroovyTokenId.RBRACE);
                    } else if (c == '[' || c == '(' || c == '{') {
                        this.completeOpeningBracket(baseDocument, n, caret, c);
                    }
                }
                if (c == '}') {
                    this.reindent(baseDocument, n, GroovyTokenId.RBRACE, caret);
                    break;
                }
                if (c != ']') break;
                this.reindent(baseDocument, n, GroovyTokenId.RBRACKET, caret);
                break;
            }
            case ';': {
                BracketCompleter.moveSemicolon(baseDocument, n, caret);
                break;
            }
            case '/': {
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
                if (tokenSequence == null) break;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId == GroovyTokenId.LINE_COMMENT && n == tokenSequence.offset() + 1 && n + 1 < baseDocument.getLength() && baseDocument.getText(n + 1, 1).charAt(0) == '/') {
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                    return true;
                }
                if (tokenId != GroovyTokenId.REGEXP_BEGIN && tokenId != GroovyTokenId.REGEXP_END) break;
                TokenId[] tokenIdArray = REGEXP_TOKENS;
                GroovyTokenId groovyTokenId = GroovyTokenId.REGEXP_BEGIN;
                boolean bl = this.completeQuote(baseDocument, n, caret, c, tokenIdArray, groovyTokenId);
                if (bl) {
                    caret.setDot(n + 1);
                }
                return bl;
            }
        }
        return true;
    }

    private void reindent(BaseDocument baseDocument, int n, TokenId tokenId, Caret caret) throws BadLocationException {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == tokenId) {
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (tokenSequence.offset() > n2) {
                    return;
                }
                OffsetRange offsetRange = tokenId == GroovyTokenId.RBRACE ? LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE) : (tokenId == GroovyTokenId.RBRACKET ? LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET) : LexUtilities.findBegin(baseDocument, tokenSequence));
                if (offsetRange != OffsetRange.NONE) {
                    int n3 = offsetRange.getStart();
                    int n4 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n3);
                    this.previousAdjustmentIndent = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n);
                    GsfUtilities.setLineIndentation((BaseDocument)baseDocument, (int)n, (int)n4);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    public OffsetRange findMatching(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return OffsetRange.NONE;
            }
            Token token = tokenSequence.token();
            if (token == null) {
                return OffsetRange.NONE;
            }
            TokenId tokenId = token.id();
            if (tokenId == GroovyTokenId.WHITESPACE) {
                tokenSequence.move(++n);
                if (tokenSequence.moveNext() && tokenSequence.offset() <= n) {
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
            }
            if (tokenId == GroovyTokenId.STRING_BEGIN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.STRING_BEGIN, GroovyTokenId.STRING_END);
            }
            if (tokenId == GroovyTokenId.STRING_END) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.STRING_BEGIN, GroovyTokenId.STRING_END);
            }
            if (tokenId == GroovyTokenId.REGEXP_BEGIN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.REGEXP_BEGIN, GroovyTokenId.REGEXP_END);
            }
            if (tokenId == GroovyTokenId.REGEXP_END) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.REGEXP_BEGIN, GroovyTokenId.REGEXP_END);
            }
            if (tokenId == GroovyTokenId.LPAREN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.LPAREN, GroovyTokenId.RPAREN);
            }
            if (tokenId == GroovyTokenId.RPAREN) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LPAREN, GroovyTokenId.RPAREN);
            }
            if (tokenId == GroovyTokenId.LBRACE) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE);
            }
            if (tokenId == GroovyTokenId.RBRACE) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE);
            }
            if (tokenId == GroovyTokenId.LBRACKET) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET);
            }
            if (tokenId == GroovyTokenId.RBRACKET) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET);
            }
        }
        return OffsetRange.NONE;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)document;
        switch (c) {
            case ' ': {
                TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
                if (tokenSequence == null || tokenSequence.token().id() != GroovyTokenId.LINE_COMMENT || tokenSequence.offset() != n - 2) break;
                baseDocument.remove(n - 2, 2);
                jTextComponent.getCaret().setDot(n - 2);
                return true;
            }
            case '(': 
            case '[': 
            case '{': {
                char c2 = LexUtilities.getTokenChar(baseDocument, n);
                if (!(c2 == ']' && LexUtilities.getTokenBalance(baseDocument, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET, n) != 0 || c2 == ')' && LexUtilities.getTokenBalance(baseDocument, GroovyTokenId.LPAREN, GroovyTokenId.RPAREN, n) != 0) && (c2 != '}' || LexUtilities.getTokenBalance(baseDocument, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE, n) == 0)) break;
                baseDocument.remove(n, 1);
                break;
            }
            case '/': {
                Object object = LexUtilities.getPositionedSequence(baseDocument, n);
                if (object != null && object.token().id() == GroovyTokenId.REGEXP_BEGIN && object.offset() == n - 1) {
                    baseDocument.remove(n - 1, 1);
                    jTextComponent.getCaret().setDot(n - 1);
                    return true;
                }
            }
            case '\"': 
            case '\'': 
            case '|': {
                Object object = baseDocument.getChars(n, 1);
                if (object == null || object[0] != c) break;
                baseDocument.remove(n, 1);
            }
        }
        return true;
    }

    private void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c, TokenId tokenId) throws BadLocationException {
        int n = caret.getDot();
        if (this.isSkipClosingBracket(baseDocument, n, tokenId)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument baseDocument, int n, TokenId tokenId) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return false;
        }
        Token token = tokenSequence.token();
        if (token != null && token.id() == tokenId) {
            int n2 = tokenId.ordinal();
            int n3 = n2 == GroovyTokenId.RPAREN.ordinal() ? GroovyTokenId.LPAREN.ordinal() : GroovyTokenId.LBRACKET.ordinal();
            tokenSequence.moveNext();
            Token token2 = tokenSequence.token();
            while (token2 != null && token2.id() == tokenId) {
                token = token2;
                if (!tokenSequence.moveNext()) break;
                token2 = tokenSequence.token();
            }
            int n4 = 0;
            int n5 = -1;
            Token token3 = token;
            tokenSequence.movePrevious();
            token = tokenSequence.token();
            boolean bl2 = false;
            while (!bl2 && token != null) {
                int n6 = ((GroovyTokenId)token.id()).ordinal();
                if (token.id() == GroovyTokenId.LPAREN || token.id() == GroovyTokenId.LBRACKET) {
                    if (n6 == n2 && ++n5 == 0) {
                        if (n4 != 0) {
                            n5 = 1;
                        }
                        bl2 = true;
                    }
                } else if (token.id() == GroovyTokenId.RPAREN || token.id() == GroovyTokenId.RBRACKET) {
                    if (n6 == n2) {
                        --n5;
                    }
                } else if (token.id() == GroovyTokenId.LBRACE) {
                    if (++n4 > 0) {
                        bl2 = true;
                    }
                } else if (token.id() == GroovyTokenId.RBRACE) {
                    --n4;
                }
                if (!tokenSequence.movePrevious()) break;
                token = tokenSequence.token();
            }
            if (n5 != 0) {
                bl = true;
            } else {
                n4 = 0;
                n5 = 1;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n7 = token3.offset(tokenHierarchy);
                tokenSequence.move(n7);
                tokenSequence.moveNext();
                token = tokenSequence.token();
                bl2 = false;
                while (!bl2 && token != null) {
                    if (token.id() == GroovyTokenId.LPAREN || token.id() == GroovyTokenId.LBRACKET) {
                        if (((GroovyTokenId)token.id()).ordinal() == n3) {
                            ++n5;
                        }
                    } else if (token.id() == GroovyTokenId.RPAREN || token.id() == GroovyTokenId.RBRACKET) {
                        if (((GroovyTokenId)token.id()).ordinal() == n2 && --n5 == 0) {
                            if (n4 != 0) {
                                n5 = -1;
                            }
                            bl2 = true;
                        }
                    } else if (token.id() == GroovyTokenId.LBRACE) {
                        ++n4;
                    } else if (token.id() == GroovyTokenId.RBRACE && --n4 < 0) {
                        bl2 = true;
                    }
                    if (!tokenSequence.movePrevious()) break;
                    token = tokenSequence.token();
                }
                bl = n5 == 0;
            }
        }
        return bl;
    }

    private void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (this.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + this.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    private boolean completeQuote(BaseDocument baseDocument, int n, Caret caret, char c, TokenId[] tokenIdArray, TokenId tokenId) throws BadLocationException {
        int n2;
        boolean bl;
        if (this.isEscapeSequence(baseDocument, n)) {
            return false;
        }
        if (baseDocument.getLength() < n) {
            return false;
        }
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token<? extends GroovyTokenId> token = tokenSequence.token();
        Token token2 = null;
        if (tokenSequence.movePrevious()) {
            token2 = tokenSequence.token();
        }
        boolean bl2 = bl = (n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) < n;
        if (token.id() == GroovyTokenId.BLOCK_COMMENT || token.id() == GroovyTokenId.LINE_COMMENT) {
            return false;
        }
        if (token.id() == GroovyTokenId.WHITESPACE && bl && n - 1 > 0 && (token = LexUtilities.getToken(baseDocument, n - 1)).id() == GroovyTokenId.LINE_COMMENT) {
            return false;
        }
        boolean bl3 = this.isQuoteCompletablePosition(baseDocument, n);
        boolean bl4 = false;
        TokenId tokenId2 = token.id();
        for (TokenId tokenId3 : tokenIdArray) {
            if (tokenId2 != tokenId3) continue;
            bl4 = true;
            break;
        }
        if (tokenId2 == GroovyTokenId.ERROR && token2 != null && token2.id() == tokenId) {
            bl4 = true;
        }
        if (tokenId2 == GroovyTokenId.EOL && token2 != null) {
            if (token2.id() == tokenId) {
                bl4 = true;
            } else if (token2.id() == GroovyTokenId.ERROR && tokenSequence.movePrevious() && tokenSequence.token().id() == tokenId) {
                bl4 = true;
            }
        }
        if (!bl4 && token.id() == GroovyTokenId.WHITESPACE && bl && n - 1 > 0) {
            token = LexUtilities.getToken(baseDocument, n - 1);
            boolean bl5 = bl4 = token.id() == GroovyTokenId.STRING_LITERAL;
        }
        if (bl4) {
            if (bl) {
                return false;
            }
            char c2 = baseDocument.getChars(n, 1)[0];
            if (c2 == c) {
                if (!this.isAfter) {
                    baseDocument.insertString(n, "" + c, null);
                } else if (n >= baseDocument.getLength() - 1 || baseDocument.getText(n + 1, 1).charAt(0) != c) {
                    return true;
                }
                baseDocument.remove(n, 1);
                return true;
            }
        }
        if (bl3 && !bl4 || bl) {
            baseDocument.insertString(n, "" + c + (this.isAfter ? "" : Character.valueOf(this.matching(c))), null);
            return true;
        }
        return false;
    }

    private boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private boolean isQuoteCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n == n2 || n2 == -1) {
            return false;
        }
        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)n2);
        if (n3 == -1) {
            return false;
        }
        char c = baseDocument.getChars(n3, 1)[0];
        return c == ')' || c == ',' || c == '+' || c == '}' || c == ';' || c == ']' || c == '/';
    }

    private char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return c;
    }

    public List<OffsetRange> findLogicalRanges(CompilationInfo compilationInfo, int n) {
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        if (moduleNode == null) {
            return Collections.emptyList();
        }
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return Collections.emptyList();
        }
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        try {
            Object object;
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument == null) {
                return arrayList;
            }
            AstPath astPath = new AstPath((ASTNode)moduleNode, n2, baseDocument);
            int n5 = baseDocument.getLength();
            TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
            if (tokenSequence != null) {
                int n6;
                int n7;
                object = tokenSequence.token();
                if (object != null && object.id() == GroovyTokenId.BLOCK_COMMENT) {
                    n7 = tokenSequence.offset();
                    n6 = n7 + object.length();
                    arrayList.add(new OffsetRange(n7, n6));
                } else if (object != null && object.id() == GroovyTokenId.LINE_COMMENT) {
                    int n8;
                    n7 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    if (LexUtilities.isCommentOnlyLine(baseDocument, n)) {
                        int n9;
                        arrayList.add(new OffsetRange(Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n7), Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n6) + 1));
                        int n10 = n7;
                        n8 = n6;
                        while (n7 > 0) {
                            n9 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n7 - 1));
                            if (n9 < 0 || !LexUtilities.isCommentOnlyLine(baseDocument, n9)) {
                                n7 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n7);
                                break;
                            }
                            n7 = n9;
                        }
                        while (true) {
                            if ((n9 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n6 + 1))) >= n5 || !LexUtilities.isCommentOnlyLine(baseDocument, n9)) break;
                            n6 = n9;
                        }
                        n6 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n6) + 1;
                        if (n10 > n7 || n8 < n6) {
                            arrayList.add(new OffsetRange(n7, n6));
                        }
                    } else {
                        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                        n8 = object.offset(tokenHierarchy);
                        arrayList.add(new OffsetRange(n8, n8 + object.length()));
                    }
                }
            }
            object = astPath.leafToRoot();
            OffsetRange offsetRange = OffsetRange.NONE;
            while (object.hasNext()) {
                ASTNode aSTNode = (ASTNode)object.next();
                OffsetRange offsetRange2 = AstUtilities.getRange(aSTNode, baseDocument);
                if (!offsetRange2.containsInclusive(n2) || offsetRange2.equals((Object)offsetRange) || (offsetRange2 = LexUtilities.getLexerOffsets(compilationInfo, offsetRange2)) == OffsetRange.NONE) continue;
                if (offsetRange2.getStart() < n3) {
                    arrayList.add(new OffsetRange(n3, n4));
                    arrayList.add(new OffsetRange(0, n5));
                    break;
                }
                arrayList.add(offsetRange2);
                offsetRange = offsetRange2;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return arrayList;
        }
        return arrayList;
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        if (bl && tokenSequence.offset() == n && !tokenSequence.movePrevious()) {
            return -1;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == GroovyTokenId.WHITESPACE) {
            int n2;
            if (bl && tokenSequence.offset() < n || !bl && tokenSequence.offset() > n) {
                return tokenSequence.offset();
            }
            while (tokenId == GroovyTokenId.WHITESPACE) {
                if (bl && !tokenSequence.movePrevious()) {
                    return -1;
                }
                if (!bl && !tokenSequence.moveNext()) {
                    return -1;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (bl ? (n2 = tokenSequence.offset() + token.length()) < n : (n2 = tokenSequence.offset()) > n) {
                return n2;
            }
        }
        if (tokenId == GroovyTokenId.IDENTIFIER || tokenId == GroovyTokenId.CONSTANT || tokenId == GroovyTokenId.GLOBAL_VAR) {
            char c;
            int n3;
            String string = ((Object)token.text()).toString();
            int n4 = string.length();
            int n5 = n - tokenSequence.offset();
            if (bl) {
                int n6 = n - 1 - tokenSequence.offset();
                if (n6 < 0) {
                    return -1;
                }
                if (n6 < n4 && Character.isUpperCase(string.charAt(n6))) {
                    for (int i = n6 - 1; i >= 0; --i) {
                        char c2 = string.charAt(i);
                        if (c2 == '_') {
                            return tokenSequence.offset() + i + 1;
                        }
                        if (Character.isUpperCase(c2)) continue;
                        return tokenSequence.offset() + i + 1;
                    }
                    return tokenSequence.offset();
                }
                for (int i = n6 - 1; i >= 0; --i) {
                    char c3 = string.charAt(i);
                    if (c3 == '_') {
                        return tokenSequence.offset() + i + 1;
                    }
                    if (!Character.isUpperCase(c3)) continue;
                    for (int j = i; j >= 0; --j) {
                        char c4 = string.charAt(j);
                        if (c4 == '_') {
                            return tokenSequence.offset() + j + 1;
                        }
                        if (Character.isUpperCase(c4)) continue;
                        return tokenSequence.offset() + j + 1;
                    }
                    return tokenSequence.offset();
                }
                return tokenSequence.offset();
            }
            int n7 = n5 + 1;
            if (n5 < 0 || n5 >= string.length()) {
                return -1;
            }
            if (Character.isUpperCase(string.charAt(n5))) {
                for (n3 = n7; n3 < n4 && Character.isUpperCase(c = string.charAt(n3)); ++n3) {
                    if (string.charAt(n3) == '_') {
                        return tokenSequence.offset() + n3;
                    }
                    ++n7;
                }
            }
            for (n3 = n7; n3 < n4; ++n3) {
                c = string.charAt(n3);
                if (c != '_' && !Character.isUpperCase(c)) continue;
                return tokenSequence.offset() + n3;
            }
        }
        return -1;
    }

    private static boolean moveSemicolon(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        int n3 = n;
        while (tokenSequence.moveNext() && tokenSequence.offset() < n2) {
            Token token = tokenSequence.token();
            GroovyTokenId groovyTokenId = (GroovyTokenId)token.id();
            if (groovyTokenId == GroovyTokenId.RPAREN) {
                n3 = tokenSequence.offset();
                continue;
            }
            if (groovyTokenId == GroovyTokenId.WHITESPACE) continue;
            return false;
        }
        if (BracketCompleter.isForLoopSemicolon(tokenSequence) || BracketCompleter.posWithinAnyQuote(baseDocument, n)) {
            return false;
        }
        baseDocument.remove(n, 1);
        baseDocument.insertString(n3, ";", null);
        caret.setDot(n3 + 1);
        return true;
    }

    private static boolean isForLoopSemicolon(TokenSequence<? extends GroovyTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        if (token == null || token.id() != GroovyTokenId.SEMI) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Token token2 = token = tokenSequence.movePrevious() ? tokenSequence.token() : null;
        while (token != null) {
            if (token.id() == GroovyTokenId.LPAREN) {
                if (n == 0) {
                    Token token3 = token = tokenSequence.movePrevious() ? tokenSequence.token() : null;
                    while (token != null && (token.id() == GroovyTokenId.WHITESPACE || token.id() == GroovyTokenId.BLOCK_COMMENT || token.id() == GroovyTokenId.LINE_COMMENT)) {
                        token = tokenSequence.movePrevious() ? tokenSequence.token() : null;
                    }
                    return token != null && token.id() == GroovyTokenId.LITERAL_for;
                }
                --n;
            } else if (token.id() == GroovyTokenId.RPAREN) {
                ++n;
            } else if (token.id() == GroovyTokenId.LBRACE) {
                if (n2 == 0) {
                    return false;
                }
                --n2;
            } else if (token.id() == GroovyTokenId.RBRACE) {
                ++n2;
            } else if (token.id() == GroovyTokenId.SEMI) {
                if (bl) {
                    return false;
                }
                bl = true;
            }
            token = tokenSequence.movePrevious() ? tokenSequence.token() : null;
        }
        return false;
    }

    private static boolean posWithinAnyQuote(BaseDocument baseDocument, int n) {
        Token token;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        return tokenSequence != null && (token = tokenSequence.token()) != null && token.id() == GroovyTokenId.STRING_LITERAL;
    }
}

