/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.Methods;
import org.netbeans.modules.groovy.editor.TypeVisitor;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.gsf.api.OffsetRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariableScopeVisitor
extends TypeVisitor {
    private final Set<ASTNode> occurrences = new HashSet<ASTNode>();
    private final ASTNode leafParent;

    public VariableScopeVisitor(SourceUnit sourceUnit, AstPath astPath, BaseDocument baseDocument, int n) {
        super(sourceUnit, astPath, baseDocument, n);
        this.leafParent = astPath.leafParent();
    }

    public Set<ASTNode> getOccurrences() {
        return this.occurrences;
    }

    @Override
    protected void visitParameters(Parameter[] parameterArray, Variable variable) {
        for (Parameter parameter : parameterArray) {
            if (!parameter.getName().equals(variable.getName())) continue;
            this.occurrences.add(parameter);
            break;
        }
    }

    @Override
    protected boolean isValidToken(Token<? extends GroovyTokenId> token) {
        return token.id() == GroovyTokenId.IDENTIFIER;
    }

    @Override
    public void visitVariableExpression(VariableExpression variableExpression) {
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(variableExpression.getName())) {
            this.occurrences.add(variableExpression);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)this.leafParent;
            if (variableExpression.getName().equals(propertyExpression.getPropertyAsString())) {
                this.occurrences.add(variableExpression);
                return;
            }
        }
        super.visitVariableExpression(variableExpression);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        VariableExpression variableExpression;
        MethodNode methodNode;
        OffsetRange offsetRange;
        if (this.leaf instanceof DeclarationExpression) {
            String string;
            DeclarationExpression declarationExpression2 = declarationExpression;
            DeclarationExpression declarationExpression3 = (DeclarationExpression)this.leaf;
            VariableExpression variableExpression2 = declarationExpression3.getVariableExpression();
            VariableExpression variableExpression3 = declarationExpression2.getVariableExpression();
            if (!variableExpression2.isDynamicTyped() && !variableExpression3.isDynamicTyped() && (string = variableExpression2.getType().getNameWithoutPackage()).equals(variableExpression3.getType().getNameWithoutPackage())) {
                AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(declarationExpression, string);
                this.occurrences.add(fakeASTNode);
            }
        } else if (this.leaf instanceof ClassExpression) {
            ClassExpression classExpression = (ClassExpression)this.leaf;
            VariableExpression variableExpression4 = declarationExpression.getVariableExpression();
            if (!variableExpression4.isDynamicTyped() && classExpression.getType().getName().equals(variableExpression4.getType().getName())) {
                AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(declarationExpression, classExpression.getType().getNameWithoutPackage());
                this.occurrences.add(fakeASTNode);
            }
        } else if (this.leaf instanceof ClassNode) {
            ClassNode classNode = (ClassNode)this.leaf;
            VariableExpression variableExpression5 = declarationExpression.getVariableExpression();
            if (!variableExpression5.isDynamicTyped() && classNode.getName().equals(variableExpression5.getType().getName())) {
                AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(declarationExpression, classNode.getNameWithoutPackage());
                this.occurrences.add(fakeASTNode);
            }
        } else if (this.leaf instanceof MethodNode && (offsetRange = VariableScopeVisitor.getMethodReturnType(methodNode = (MethodNode)this.leaf, this.doc, this.cursorOffset)) != OffsetRange.NONE && !(variableExpression = declarationExpression.getVariableExpression()).isDynamicTyped() && !methodNode.isDynamicReturnType() && variableExpression.getType().getName().equals(methodNode.getReturnType().getName())) {
            AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(declarationExpression, methodNode.getReturnType().getNameWithoutPackage());
            this.occurrences.add(fakeASTNode);
        }
        super.visitDeclarationExpression(declarationExpression);
    }

    @Override
    public void visitField(FieldNode fieldNode) {
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(fieldNode.getName())) {
            this.occurrences.add(fieldNode);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)this.leafParent;
            if (fieldNode.getName().equals(propertyExpression.getPropertyAsString())) {
                this.occurrences.add(fieldNode);
                return;
            }
        }
        super.visitField(fieldNode);
    }

    @Override
    public void visitMethod(MethodNode methodNode) {
        VariableScope variableScope = methodNode.getVariableScope();
        if (this.leaf instanceof Variable) {
            String string = ((Variable)((Object)this.leaf)).getName();
            if (variableScope != null && variableScope.getDeclaredVariable(string) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            String string = ((ConstantExpression)this.leaf).getText();
            if (variableScope != null && variableScope.getDeclaredVariable(string) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)this.leafParent;
            if (Methods.isSameMethod(methodNode, methodCallExpression)) {
                this.occurrences.add(methodNode);
            }
        } else if (this.leaf instanceof MethodNode) {
            MethodNode methodNode2 = (MethodNode)this.leaf;
            if (Methods.isSameMethod(methodNode, methodNode2)) {
                OffsetRange offsetRange = VariableScopeVisitor.getMethodReturnType(methodNode2, this.doc, this.cursorOffset);
                if (offsetRange != OffsetRange.NONE) {
                    AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(methodNode, methodNode.getReturnType().getNameWithoutPackage());
                    this.occurrences.add(fakeASTNode);
                } else {
                    this.occurrences.add(methodNode);
                }
            }
        } else if (this.leaf instanceof ClassExpression) {
            ClassExpression classExpression = (ClassExpression)this.leaf;
            if (methodNode.getReturnType().getName().equals(classExpression.getType().getName())) {
                String string = classExpression.getType().getNameWithoutPackage();
                AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(methodNode, string);
                this.occurrences.add(fakeASTNode);
            }
        } else if (this.leaf instanceof DeclarationExpression) {
            String string;
            DeclarationExpression declarationExpression = (DeclarationExpression)this.leaf;
            VariableExpression variableExpression = declarationExpression.getVariableExpression();
            if (!variableExpression.isDynamicTyped() && !methodNode.isDynamicReturnType() && (string = variableExpression.getType().getNameWithoutPackage()).equals(methodNode.getReturnType().getNameWithoutPackage())) {
                AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(methodNode, string);
                this.occurrences.add(fakeASTNode);
            }
        } else if (this.leaf instanceof ClassNode) {
            ClassNode classNode = (ClassNode)this.leaf;
            if (!methodNode.isDynamicReturnType() && classNode.getName().equals(methodNode.getReturnType().getName())) {
                AstUtilities.FakeASTNode fakeASTNode = new AstUtilities.FakeASTNode(methodNode, classNode.getNameWithoutPackage());
                this.occurrences.add(fakeASTNode);
            }
        }
        super.visitMethod(methodNode);
    }

    @Override
    public void visitConstructor(ConstructorNode constructorNode) {
        VariableScope variableScope = constructorNode.getVariableScope();
        if (this.leaf instanceof Variable) {
            String string = ((Variable)((Object)this.leaf)).getName();
            if (variableScope != null && variableScope.getDeclaredVariable(string) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            String string = ((ConstantExpression)this.leaf).getText();
            if (variableScope != null && variableScope.getDeclaredVariable(string) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstructorCallExpression) {
            ConstructorCallExpression constructorCallExpression = (ConstructorCallExpression)this.leaf;
            if (Methods.isSameConstructor(constructorNode, constructorCallExpression)) {
                this.occurrences.add(constructorNode);
            }
        } else if (this.leaf instanceof ConstructorNode && Methods.isSameConstructor(constructorNode, (ConstructorNode)this.leaf)) {
            this.occurrences.add(constructorNode);
        }
        super.visitConstructor(constructorNode);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        if (this.leaf instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)this.leaf;
            if (Methods.isSameMethod(methodNode, methodCallExpression) && VariableScopeVisitor.getMethodReturnType(methodNode, this.doc, this.cursorOffset) == OffsetRange.NONE) {
                this.occurrences.add(methodCallExpression);
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression && Methods.isSameMethod(methodCallExpression, (MethodCallExpression)this.leafParent)) {
            this.occurrences.add(methodCallExpression);
        }
        super.visitMethodCallExpression(methodCallExpression);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression constructorCallExpression) {
        if (this.leaf instanceof ConstructorNode) {
            ConstructorNode constructorNode = (ConstructorNode)this.leaf;
            if (Methods.isSameConstructor(constructorNode, constructorCallExpression)) {
                this.occurrences.add(constructorCallExpression);
            }
        } else if (this.leaf instanceof ConstructorCallExpression && Methods.isSameConstuctor(constructorCallExpression, (ConstructorCallExpression)this.leaf)) {
            this.occurrences.add(constructorCallExpression);
        }
        super.visitConstructorCallExpression(constructorCallExpression);
    }

    @Override
    public void visitClassExpression(ClassExpression classExpression) {
        MethodNode methodNode;
        OffsetRange offsetRange;
        if (this.leaf instanceof ClassNode) {
            ClassNode classNode = (ClassNode)this.leaf;
            if (classExpression.getType().getName().equals(classNode.getName())) {
                this.occurrences.add(classExpression);
            }
        } else if (this.leaf instanceof ClassExpression) {
            if (classExpression.getType().getName().equals(((ClassExpression)this.leaf).getText())) {
                this.occurrences.add(classExpression);
            }
        } else if (this.leaf instanceof DeclarationExpression) {
            DeclarationExpression declarationExpression = (DeclarationExpression)this.leaf;
            VariableExpression variableExpression = declarationExpression.getVariableExpression();
            if (!variableExpression.isDynamicTyped() && classExpression.getType().getName().equals(variableExpression.getType().getName())) {
                this.occurrences.add(classExpression);
            }
        } else if (this.leaf instanceof MethodNode && (offsetRange = VariableScopeVisitor.getMethodReturnType(methodNode = (MethodNode)this.leaf, this.doc, this.cursorOffset)) != OffsetRange.NONE) {
            this.occurrences.add(classExpression);
        }
        super.visitClassExpression(classExpression);
    }

    @Override
    public void visitClass(ClassNode classNode) {
        MethodNode methodNode;
        OffsetRange offsetRange;
        if (this.leaf instanceof ClassExpression) {
            if (classNode.getName().equals(((ClassExpression)this.leaf).getText())) {
                this.occurrences.add(classNode);
            }
        } else if (this.leaf instanceof ClassNode) {
            if (classNode.getName().equals(((ClassNode)this.leaf).getName())) {
                this.occurrences.add(classNode);
            }
        } else if (this.leaf instanceof DeclarationExpression) {
            DeclarationExpression declarationExpression = (DeclarationExpression)this.leaf;
            VariableExpression variableExpression = declarationExpression.getVariableExpression();
            if (!variableExpression.isDynamicTyped() && classNode.getName().equals(variableExpression.getType().getName())) {
                this.occurrences.add(classNode);
            }
        } else if (this.leaf instanceof MethodNode && (offsetRange = VariableScopeVisitor.getMethodReturnType(methodNode = (MethodNode)this.leaf, this.doc, this.cursorOffset)) != OffsetRange.NONE) {
            this.occurrences.add(classNode);
        }
        super.visitClass(classNode);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        Expression expression = propertyExpression.getProperty();
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(propertyExpression.getPropertyAsString())) {
            this.occurrences.add(expression);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyExpression2 = (PropertyExpression)this.leafParent;
            String string = propertyExpression.getPropertyAsString();
            if (string != null && string.equals(propertyExpression2.getPropertyAsString())) {
                this.occurrences.add(expression);
            }
        }
        super.visitPropertyExpression(propertyExpression);
    }

    private static final OffsetRange getMethodReturnType(MethodNode methodNode, BaseDocument baseDocument, int n) {
        OffsetRange offsetRange;
        int n2 = AstUtilities.getOffset(baseDocument, methodNode.getLineNumber(), methodNode.getColumnNumber());
        if (!methodNode.isDynamicReturnType() && (offsetRange = AstUtilities.getNextIdentifierByName(baseDocument, methodNode.getReturnType().getNameWithoutPackage(), n2)).containsInclusive(n)) {
            return offsetRange;
        }
        return OffsetRange.NONE;
    }
}

