/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import org.netbeans.modules.groovy.editor.completion.CodeCompleter;
import org.netbeans.modules.groovy.editor.completion.GroovyCompletionItem;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorItem
extends GroovyCompletionItem {
    private final String name;
    private static final String NEW_CSTR = "org/netbeans/modules/groovy/editor/resources/new_constructor_16.png";
    private boolean expand;
    private final String paramListString;
    private final List<CodeCompleter.ParamDesc> paramList;

    ConstructorItem(String string, String string2, List<CodeCompleter.ParamDesc> list, int n, CodeCompleter.CompletionRequest completionRequest, boolean bl) {
        super(null, n, completionRequest);
        this.name = string;
        this.expand = bl;
        this.paramListString = string2;
        this.paramList = list;
    }

    public String getLhsHtml(HtmlFormatter htmlFormatter) {
        if (this.expand) {
            return this.name + " - generate";
        }
        return this.name + "(" + this.paramListString + ")";
    }

    @Override
    public String getName() {
        if (this.expand) {
            return this.name + "()\n{\n}";
        }
        return this.name;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CONSTRUCTOR;
    }

    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        return null;
    }

    public ImageIcon getIcon() {
        if (newConstructorIcon == null) {
            newConstructorIcon = new ImageIcon(ImageUtilities.loadImage((String)NEW_CSTR));
        }
        return newConstructorIcon;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    @Override
    public ElementHandle getElement() {
        return null;
    }

    public boolean isSmart() {
        return true;
    }

    public String getCustomInsertTemplate() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getInsertPrefix());
        stringBuilder.append("(");
        int n = 1;
        for (CodeCompleter.ParamDesc paramDesc : this.paramList) {
            this.LOG.log(Level.FINEST, "-------------------------------------------------------------------");
            this.LOG.log(Level.FINEST, "paramDesc.fullTypeName : {0}", paramDesc.fullTypeName);
            this.LOG.log(Level.FINEST, "paramDesc.typeName     : {0}", paramDesc.typeName);
            this.LOG.log(Level.FINEST, "paramDesc.name         : {0}", paramDesc.name);
            stringBuilder.append("${");
            stringBuilder.append("groovy-cc-");
            stringBuilder.append(Integer.toString(n));
            stringBuilder.append(" default=\"");
            stringBuilder.append(paramDesc.name);
            stringBuilder.append("\"");
            stringBuilder.append("}");
            if (n < this.paramList.size()) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        stringBuilder.append(")");
        this.LOG.log(Level.FINEST, "Template returned : {0}", stringBuilder.toString());
        return stringBuilder.toString();
    }
}

