/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.swing.ImageIcon;
import org.netbeans.modules.groovy.editor.completion.CodeCompleter;
import org.netbeans.modules.groovy.editor.elements.GroovyElement;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.spi.DefaultCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GroovyCompletionItem
extends DefaultCompletionProposal {
    protected CodeCompleter.CompletionRequest request;
    protected GroovyElement element;
    final Logger LOG = Logger.getLogger(GroovyCompletionItem.class.getName());
    static ImageIcon groovyIcon;
    static ImageIcon javaIcon;
    static ImageIcon newConstructorIcon;

    GroovyCompletionItem(GroovyElement groovyElement, int n, CodeCompleter.CompletionRequest completionRequest) {
        this.element = groovyElement;
        this.anchorOffset = n;
        this.request = completionRequest;
        this.LOG.setLevel(Level.OFF);
    }

    public static Collection<Modifier> toModel(int n) {
        HashSet<Modifier> hashSet = new HashSet<Modifier>();
        if (java.lang.reflect.Modifier.isAbstract(n)) {
            hashSet.add(Modifier.ABSTRACT);
        }
        if (java.lang.reflect.Modifier.isFinal(n)) {
            hashSet.add(Modifier.FINAL);
        }
        if (java.lang.reflect.Modifier.isNative(n)) {
            hashSet.add(Modifier.NATIVE);
        }
        if (java.lang.reflect.Modifier.isStatic(n)) {
            hashSet.add(Modifier.STATIC);
        }
        if (java.lang.reflect.Modifier.isStrict(n)) {
            hashSet.add(Modifier.STRICTFP);
        }
        if (java.lang.reflect.Modifier.isSynchronized(n)) {
            hashSet.add(Modifier.SYNCHRONIZED);
        }
        if (java.lang.reflect.Modifier.isPrivate(n)) {
            hashSet.add(Modifier.PRIVATE);
        } else if (java.lang.reflect.Modifier.isProtected(n)) {
            hashSet.add(Modifier.PROTECTED);
        } else if (java.lang.reflect.Modifier.isPublic(n)) {
            hashSet.add(Modifier.PUBLIC);
        }
        return hashSet;
    }

    public String getName() {
        return this.element.getName();
    }

    public ElementHandle getElement() {
        this.LOG.log(Level.FINEST, "getElement() request.info : {0}", this.request.info);
        this.LOG.log(Level.FINEST, "getElement() element : {0}", this.element);
        return null;
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public Set<org.netbeans.modules.gsf.api.Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public String toString() {
        String string = ((Object)((Object)this)).getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(" + this.getKind() + "): " + this.getName();
    }
}

