/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.groovy.editor.completion.CodeCompleter;
import org.netbeans.modules.groovy.editor.completion.GroovyCompletionItem;
import org.netbeans.modules.groovy.editor.elements.ElementHandleSupport;
import org.netbeans.modules.groovy.editor.elements.KeywordElement;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeywordItem
extends GroovyCompletionItem {
    private static final String JAVA_KEYWORD = "org/netbeans/modules/groovy/editor/resources/duke.png";
    private final String keyword;
    private final String description;
    private final boolean isGroovy;

    KeywordItem(String string, String string2, int n, CodeCompleter.CompletionRequest completionRequest, boolean bl) {
        super(null, n, completionRequest);
        this.keyword = string;
        this.description = string2;
        this.isGroovy = bl;
    }

    @Override
    public String getName() {
        return this.keyword;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.KEYWORD;
    }

    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        if (this.description != null) {
            htmlFormatter.appendHtml(this.description);
            return htmlFormatter.getText();
        }
        return null;
    }

    public ImageIcon getIcon() {
        if (this.isGroovy) {
            if (groovyIcon == null) {
                groovyIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png"));
            }
            return groovyIcon;
        }
        if (javaIcon == null) {
            javaIcon = new ImageIcon(ImageUtilities.loadImage((String)JAVA_KEYWORD));
        }
        return javaIcon;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    @Override
    public ElementHandle getElement() {
        return ElementHandleSupport.createHandle(this.request.info, new KeywordElement(this.keyword));
    }
}

