/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class MakeMasterJNLP
extends Task {
    private FileSet files;
    private File target;
    private String masterPrefix = "";

    public FileSet createModules() throws BuildException {
        if (this.files != null) {
            throw new BuildException("modules can be created just once");
        }
        this.files = new FileSet();
        return this.files;
    }

    public void setDir(File t) {
        this.target = t;
    }

    public void setCodeBase(String p) {
        this.masterPrefix = p;
    }

    public void execute() throws BuildException {
        if (this.target == null) {
            throw new BuildException("Output dir must be provided");
        }
        if (this.files == null) {
            throw new BuildException("modules must be provided");
        }
        try {
            this.generateFiles();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateFiles() throws IOException, BuildException {
        for (String nm : this.files.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
            File jar = new File(this.files.getDir(this.getProject()), nm);
            if (!jar.canRead()) {
                throw new BuildException("Cannot read file: " + jar);
            }
            JarFile theJar = new JarFile(jar);
            String codenamebase = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module");
            if (codenamebase == null) {
                throw new BuildException("Not a NetBeans Module: " + jar);
            }
            int slash = codenamebase.indexOf(47);
            if (slash >= 0) {
                codenamebase = codenamebase.substring(0, slash);
            }
            String dashcnb = codenamebase.replace('.', '-');
            File n = new File(this.target, dashcnb + ".ref");
            FileWriter w = new FileWriter(n);
            w.write("    <extension name='" + codenamebase + "' href='" + this.masterPrefix + dashcnb + ".jnlp' />\n");
            w.close();
            theJar.close();
        }
    }
}

