/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.textsync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManager;
import org.netbeans.lib.editor.codetemplates.textsync.TextSync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextSyncGroup {
    private TextRegionManager manager;
    private List<TextSync> textSyncs;

    public TextSyncGroup(TextSync ... textSyncArray) {
        this.initTextSyncs(textSyncArray.length);
        for (TextSync textSync : textSyncArray) {
            this.addTextSync(textSync);
        }
    }

    public TextSyncGroup() {
        this.initTextSyncs(4);
    }

    private void initTextSyncs(int n) {
        this.textSyncs = new ArrayList<TextSync>(n);
    }

    public List<TextSync> textSyncs() {
        return Collections.unmodifiableList(this.textSyncs);
    }

    public void addTextSync(TextSync textSync) {
        if (textSync == null) {
            throw new IllegalArgumentException("textSync cannot be null");
        }
        if (textSync.textSyncGroup() != null) {
            throw new IllegalArgumentException("textSync " + textSync + " already assigned to group " + textSync.textSyncGroup());
        }
        this.textSyncs.add(textSync);
        textSync.setTextSyncGroup(this);
    }

    public void removeTextSync(TextSync textSync) {
        if (this.textSyncs.remove(textSync)) {
            textSync.setTextSyncGroup(null);
        }
    }

    List<TextSync> textSyncsModifiable() {
        return this.textSyncs;
    }

    public TextRegionManager textRegionManager() {
        return this.manager;
    }

    void setTextRegionManager(TextRegionManager textRegionManager) {
        this.manager = textRegionManager;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.textSyncs.size() * 50 + 2);
        stringBuilder.append('{');
        if (this.textSyncs.size() > 0) {
            stringBuilder.append(this.textSyncs.get(0));
        }
        for (int i = 1; i < this.textSyncs.size(); ++i) {
            stringBuilder.append(", ").append(this.textSyncs.get(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

