/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.api.input;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.netbeans.modules.extexecution.api.input.InputReader;
import org.netbeans.modules.extexecution.input.DefaultInputReader;
import org.netbeans.modules.extexecution.input.FileInputReader;
import org.openide.util.Parameters;

public final class InputReaders {
    private InputReaders() {
    }

    public static InputReader forReader(Reader reader) {
        return new DefaultInputReader(reader, true);
    }

    public static InputReader forStream(InputStream inputStream, Charset charset) {
        Parameters.notNull((CharSequence)"stream", (Object)inputStream);
        return InputReaders.forReader(new InputStreamReader(inputStream, charset));
    }

    public static InputReader forFile(File file, Charset charset) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        Parameters.notNull((CharSequence)"charset", (Object)charset);
        final FileInput fileInput = new FileInput(file, charset);
        return InputReaders.forFileInputProvider(new FileInput.Provider(){

            public FileInput getFileInput() {
                return fileInput;
            }
        });
    }

    public static InputReader forFileInputProvider(FileInput.Provider provider) {
        Parameters.notNull((CharSequence)"fileProvider", (Object)provider);
        return new FileInputReader(provider);
    }

    public static final class FileInput {
        private final File file;
        private final Charset charset;

        public FileInput(File file, Charset charset) {
            this.file = file;
            this.charset = charset;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public File getFile() {
            return this.file;
        }

        public static interface Provider {
            public FileInput getFileInput();
        }
    }
}

