/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.samples;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.samples.JavaEESamplesWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaEESamplesPanelVisual
extends JPanel
implements DocumentListener {
    private boolean withDB = false;
    private JavaEESamplesWizardPanel panel;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JTextArea infoDBLocation;
    private JLabel lblDBLocation;
    private JLabel lblDBName;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JTextField txtDBLocation;
    private JTextField txtDBName;

    public JavaEESamplesPanelVisual(JavaEESamplesWizardPanel javaEESamplesWizardPanel, boolean bl) {
        this.initComponents();
        this.panel = javaEESamplesWizardPanel;
        this.withDB = bl;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.txtDBName.getDocument().addDocumentListener(this);
        if (!bl) {
            this.txtDBName.setVisible(false);
            this.lblDBName.setVisible(false);
            this.txtDBLocation.setVisible(false);
            this.lblDBLocation.setVisible(false);
            this.infoDBLocation.setVisible(false);
        }
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.lblDBName = new JLabel();
        this.txtDBName = new JTextField();
        this.lblDBLocation = new JLabel();
        this.txtDBLocation = new JTextField();
        this.infoDBLocation = new JTextArea();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/samples/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)resourceBundle.getString("LBL_ProjectName"));
        this.projectNameTextField.setEditable(false);
        this.projectNameTextField.setEnabled(false);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)resourceBundle.getString("LBL_ProjectLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)resourceBundle.getString("LBL_Browse"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaEESamplesPanelVisual.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)resourceBundle.getString("LBL_ProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        this.createdFolderTextField.setEnabled(false);
        this.lblDBName.setLabelFor(this.txtDBName);
        Mnemonics.setLocalizedText((JLabel)this.lblDBName, (String)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_DBName"));
        this.lblDBLocation.setLabelFor(this.txtDBLocation);
        Mnemonics.setLocalizedText((JLabel)this.lblDBLocation, (String)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_DBLocation"));
        this.txtDBLocation.setEditable(false);
        this.txtDBLocation.setEnabled(false);
        this.infoDBLocation.setColumns(20);
        this.infoDBLocation.setEditable(false);
        this.infoDBLocation.setLineWrap(true);
        this.infoDBLocation.setRows(5);
        this.infoDBLocation.setText(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"CreateDatabasePanelVisual.infoTextArea.text"));
        this.infoDBLocation.setWrapStyleWord(true);
        this.infoDBLocation.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.infoDBLocation).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.createdFolderLabel).add((Component)this.lblDBName).add((Component)this.lblDBLocation)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtDBName, -1, 224, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 224, Short.MAX_VALUE).add((Component)this.txtDBLocation, -1, 224, Short.MAX_VALUE).add((Component)this.projectLocationTextField, -1, 224, Short.MAX_VALUE).add((Component)this.projectNameTextField, -1, 224, Short.MAX_VALUE)))).addPreferredGap(0).add((Component)this.browseButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblDBName).add((Component)this.txtDBName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblDBLocation).add((Component)this.txtDBLocation, -2, -1, -2)).add(24, 24, 24).add((Component)this.infoDBLocation, -2, 90, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_ProjectLocation_A11YDesc"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_Browse_A11YDesc"));
        this.txtDBName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_DBName_A11YDesc"));
        this.txtDBLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_DBLocation_A11YDesc"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_TITLE"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        File file2;
        if (!this.isJavaEECapableServerRegistered()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_MissingJavaEE5AppServer"));
            return false;
        }
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_InvalidProjectName"));
            return false;
        }
        String string = this.projectLocationTextField.getText();
        File file3 = FileUtil.normalizeFile((File)new File(string).getAbsoluteFile());
        if (!file3.isDirectory() || string.length() == 0) {
            String string2 = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_InvalidPath");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
            return false;
        }
        for (file2 = file = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_FolderCannotBeCreated"));
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            String string3 = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_InvalidPath");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string3);
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_FolderAlreadyExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return this.withDB ? this.validDBData(wizardDescriptor) : true;
    }

    boolean validDBData(WizardDescriptor wizardDescriptor) {
        String string = this.txtDBName.getText();
        String string2 = null;
        if (DerbyDatabases.isDerbyRegistered()) {
            int n = DerbyDatabases.getFirstIllegalCharacter((String)string);
            if (n > -1) {
                string2 = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_DatabaseNameIllegalChar", (Object)Character.valueOf((char)n));
            } else if (DerbyDatabases.databaseExists((String)string)) {
                string2 = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_DatabaseDirectoryExists", (Object)string);
            } else if (string.length() == 0) {
                string2 = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_DatabaseNameEmpty");
            }
        } else {
            string2 = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_JavaDBNotRegistered");
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
        return string2 == null;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        wizardDescriptor.putProperty("name", (Object)string);
        if (this.withDB) {
            String string3 = this.txtDBName.getText().trim();
            wizardDescriptor.putProperty("dbName", (Object)string3);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            string = "sample";
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
        if (this.withDB) {
            String string2 = DerbyDatabases.getFirstFreeDatabaseName((String)string);
            this.txtDBName.setText(string2);
            this.txtDBName.selectAll();
            this.updateDBPath(string2);
        }
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    private void update(DocumentEvent documentEvent) {
        Document document;
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("projdir", null, this.projectLocationTextField.getText());
        }
        if ((document = documentEvent.getDocument()) == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
        } else if (document == this.txtDBName.getDocument()) {
            String string = this.txtDBName.getText();
            this.firePropertyChange("dbName", null, string);
            this.updateDBPath(string);
        }
        this.panel.fireChangeEvent();
    }

    private void updateDBPath(String string) {
        String string2 = new File(DerbyDatabases.getSystemHome(), string).getPath();
        this.txtDBLocation.setText(string2);
    }

    private boolean isJavaEECapableServerRegistered() {
        for (String string : Deployment.getDefault().getServerInstanceIDs()) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
            if (!j2eePlatform.getSupportedSpecVersions().contains("1.5")) continue;
            return true;
        }
        return false;
    }
}

