/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.palette.items.JsfForm;
import org.netbeans.modules.web.jsf.palette.items.JsfFormCustomizer;
import org.netbeans.modules.web.jsf.palette.items.JsfTable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JsfTableCustomizer
extends JPanel
implements DocumentListener {
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private boolean dialogOK = false;
    private final boolean hasModuleJsf;
    JsfTable jsfTable;
    JTextComponent target;
    private final FileObject targetFileObject;
    private JTextField classTextField;
    private JRadioButton empty;
    private JLabel errorField;
    private JRadioButton fromBean;
    private JButton jButton1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private ButtonGroup populate;

    public JsfTableCustomizer(JsfTable jsfTable, JTextComponent jTextComponent) {
        this.jsfTable = jsfTable;
        this.target = jTextComponent;
        this.targetFileObject = JsfForm.getFO(jTextComponent);
        this.initComponents();
        this.errorField.setForeground(UIManager.getColor("nb.errorForeground"));
        this.hasModuleJsf = JsfForm.hasModuleJsf(jTextComponent);
        this.classTextField.getDocument().addDocumentListener(this);
    }

    public boolean showDialog() {
        this.dialogOK = false;
        String string = NbBundle.getMessage(JsfTableCustomizer.class, (String)"NAME_jsp-JsfTable");
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(JsfTableCustomizer.class, (String)"LBL_Customizer_InsertPrefix") + " " + string, true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JsfTableCustomizer.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    JsfTableCustomizer.this.evaluateInput();
                    JsfTableCustomizer.this.dialogOK = true;
                }
                JsfTableCustomizer.this.dialog.dispose();
            }
        });
        this.checkStatus();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private void evaluateInput() {
        String string = this.classTextField.getText();
        this.jsfTable.setBean(string);
        this.jsfTable.setVariable("arrayOrCollectionOf" + string);
        int n = this.empty.isSelected() ? 0 : 1;
        this.jsfTable.setFormType(n);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.populate = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.classTextField = new JTextField();
        this.jButton1 = new JButton();
        this.empty = new JRadioButton();
        this.fromBean = new JRadioButton();
        this.errorField = new JLabel();
        this.jFileChooser1.setCurrentDirectory(null);
        this.jLabel1.setLabelFor(this.classTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/palette/items/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("LBL_GetProperty_Bean"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)resourceBundle.getString("LBL_Browse"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JsfTableCustomizer.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.populate.add(this.empty);
        this.empty.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.empty, (String)resourceBundle.getString("LBL_Empty_Table"));
        this.empty.setMargin(new Insets(0, 0, 0, 0));
        this.empty.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JsfTableCustomizer.this.emptyItemStateChanged(itemEvent);
            }
        });
        this.populate.add(this.fromBean);
        Mnemonics.setLocalizedText((AbstractButton)this.fromBean, (String)resourceBundle.getString("LBL_Table_From_Entity"));
        this.fromBean.setMargin(new Insets(0, 0, 0, 0));
        this.fromBean.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JsfTableCustomizer.this.emptyItemStateChanged(itemEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorField, (String)resourceBundle.getString("MSG_No_Managed_Beans"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.empty).add((Component)this.fromBean).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.classTextField, -1, 464, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1)).add((Component)this.errorField)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.empty).addPreferredGap(0).add((Component)this.fromBean).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jButton1).add((Component)this.classTextField, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((Component)this.errorField).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSN_EntytyClass"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSD_EntytyClass"));
        this.jButton1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSL_Browse"));
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSD_Browse"));
        this.empty.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSN_EmptyTable"));
        this.empty.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSD_EmptyTable"));
        this.fromBean.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSN_GeneratedTable"));
        this.fromBean.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JsfTableCustomizer.class, (String)"ACSD_GeneratedTable"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_JsfTable"));
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)this.targetFileObject);
        ElementHandle elementHandle = TypeElementFinder.find((ClasspathInfo)classpathInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
            }

            public boolean accept(ElementHandle<TypeElement> elementHandle) {
                return true;
            }
        });
        if (elementHandle != null) {
            this.classTextField.setText(elementHandle.getQualifiedName());
        }
    }

    private void emptyItemStateChanged(ItemEvent itemEvent) {
        this.checkStatus();
    }

    private void checkStatus() {
        if (this.empty.isSelected()) {
            this.classTextField.setEnabled(false);
            this.jButton1.setEnabled(false);
        } else {
            this.classTextField.setEnabled(true);
            this.jButton1.setEnabled(true);
        }
        boolean bl = false;
        try {
            bl = this.empty.isSelected() || JsfFormCustomizer.classExists(this.targetFileObject, this.classTextField.getText());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.descriptor.setValid(this.hasModuleJsf && bl);
        this.errorField.setText(this.hasModuleJsf ? (bl ? "" : ResourceBundle.getBundle("org/netbeans/modules/web/jsf/palette/items/Bundle").getString("MSG_InvalidClassName")) : ResourceBundle.getBundle("org/netbeans/modules/web/jsf/palette/items/Bundle").getString("MSG_NoJSF"));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkStatus();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkStatus();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkStatus();
    }

    public static class ManagedBeanRenderer
    extends JLabel
    implements ListCellRenderer {
        public ManagedBeanRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "" + object;
            if (object instanceof ManagedBean) {
                ManagedBean managedBean = (ManagedBean)object;
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                string = managedBean.getManagedBeanName() + "(" + managedBean.getManagedBeanClass() + ")";
            }
            this.setFont(jList.getFont());
            this.setText(string);
            return this;
        }
    }
}

