/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ui.DebuggerOutput;
import org.netbeans.modules.debugger.jpda.ui.IOManager;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.openide.util.NbBundle;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
JPDABreakpointListener,
PropertyChangeListener {
    private static final Pattern dollarEscapePattern = Pattern.compile("\\$");
    private static final Pattern backslashEscapePattern = Pattern.compile("\\\\");
    private static final Pattern threadNamePattern = Pattern.compile("\\{threadName\\}");
    private static final Pattern classNamePattern = Pattern.compile("\\{className\\}");
    private static final Pattern methodNamePattern = Pattern.compile("\\{methodName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final Pattern expressionPattern = Pattern.compile("\\{=(.*?)\\}");
    private IOManager ioManager;
    private JPDADebugger debugger;
    private ContextProvider contextProvider;
    private final Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.ioManager = null;
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (jPDABreakpointEvent.getDebugger() != this.debugger) {
                return;
            }
        }
        if (jPDABreakpointEvent.getConditionResult() == 2) {
            return;
        }
        object = (JPDABreakpoint)jPDABreakpointEvent.getSource();
        if (object.getSuspend() != 0) {
            this.getBreakpointsNodeModel().setCurrentBreakpoint((JPDABreakpoint)object);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ioManager == null) {
                this.lookupIOManager();
                if (this.ioManager == null) {
                    return;
                }
            }
        }
        object2 = object.getPrintText();
        if (object2 == null || ((String)object2).length() == 0) {
            return;
        }
        object2 = this.substitute((String)object2, jPDABreakpointEvent);
        Object object3 = this.lock;
        synchronized (object3) {
            if (this.ioManager != null) {
                this.ioManager.println((String)object2, null);
            }
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("validity".equals(propertyChangeEvent.getPropertyName())) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)propertyChangeEvent.getSource();
            if (jPDABreakpoint.isHidden()) {
                return;
            }
            if (Breakpoint.VALIDITY.INVALID.equals(propertyChangeEvent.getNewValue())) {
                String string = jPDABreakpoint.getValidityMessage();
                Object object = this.lock;
                synchronized (object) {
                    if (this.ioManager == null) {
                        this.lookupIOManager();
                        if (this.ioManager == null) {
                            return;
                        }
                    }
                    String string2 = string != null ? NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpointWithReason", (Object)jPDABreakpoint.toString(), (Object)string) : NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpoint", (Object)jPDABreakpoint.toString());
                    IOManager.Line line = null;
                    if (jPDABreakpoint instanceof LineBreakpoint) {
                        line = new IOManager.Line(((LineBreakpoint)jPDABreakpoint).getURL(), ((LineBreakpoint)jPDABreakpoint).getLineNumber(), this.debugger);
                    }
                    this.ioManager.println(string2, null, true);
                    if (line != null) {
                        this.ioManager.println(NbBundle.getMessage(BreakpointOutput.class, (String)"Link_InvalidBreakpoint", (Object)jPDABreakpoint.toString()), line, true);
                    }
                }
            }
            if (Breakpoint.VALIDITY.VALID.equals(propertyChangeEvent.getNewValue())) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.ioManager == null) {
                        this.lookupIOManager();
                        if (this.ioManager == null) {
                            return;
                        }
                    }
                    String string = NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_ValidBreakpoint", (Object)jPDABreakpoint.toString());
                    IOManager.Line line = null;
                    if (jPDABreakpoint instanceof LineBreakpoint) {
                        line = new IOManager.Line(((LineBreakpoint)jPDABreakpoint).getURL(), ((LineBreakpoint)jPDABreakpoint).getLineNumber(), this.debugger);
                    }
                    this.ioManager.println(string, line, false);
                }
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.debugger == null || !"state".equals(propertyChangeEvent.getPropertyName()) || this.debugger.getState() == 3) {
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String substitute(String string, JPDABreakpointEvent jPDABreakpointEvent) {
        Object object;
        String string2;
        JPDAThread jPDAThread = jPDABreakpointEvent.getThread();
        if (jPDAThread != null) {
            string2 = backslashEscapePattern.matcher(jPDAThread.getName()).replaceAll("\\\\\\\\");
            string2 = dollarEscapePattern.matcher(string2).replaceAll("\\\\\\$");
            string = threadNamePattern.matcher(string).replaceAll(string2);
        } else {
            string = threadNamePattern.matcher(string).replaceAll("?");
        }
        if (jPDABreakpointEvent.getReferenceType() != null) {
            string2 = dollarEscapePattern.matcher(jPDABreakpointEvent.getReferenceType().name()).replaceAll("\\\\\\$");
            string = classNamePattern.matcher(string).replaceAll(string2);
        } else {
            string = classNamePattern.matcher(string).replaceAll("?");
        }
        string2 = null;
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            if (sessionArray[i].lookupFirst(null, JPDADebugger.class) != this.debugger) continue;
            string2 = sessionArray[i];
            break;
        }
        String string3 = string2 != null ? string2.getCurrentLanguage() : null;
        String string4 = jPDAThread.getMethodName();
        if ("".equals(string4)) {
            string4 = "?";
        }
        string4 = dollarEscapePattern.matcher(string4).replaceAll("\\\\\\$");
        string = methodNamePattern.matcher(string).replaceAll(string4);
        int n = jPDAThread.getLineNumber(string3);
        string = n < 0 ? lineNumberPattern.matcher(string).replaceAll("?") : lineNumberPattern.matcher(string).replaceAll(String.valueOf(n));
        while (((Matcher)(object = expressionPattern.matcher(string))).find()) {
            Object object2;
            String string5 = ((Matcher)object).group(1);
            String string6 = "";
            try {
                JPDADebugger jPDADebugger;
                object2 = this.lock;
                synchronized (object2) {
                    if (this.debugger == null) {
                        return string6;
                    }
                    jPDADebugger = this.debugger;
                }
                string6 = jPDADebugger.evaluate(string5).getValue();
                string6 = backslashEscapePattern.matcher(string6).replaceAll("\\\\\\\\");
                string6 = dollarEscapePattern.matcher(string6).replaceAll("\\\\\\$");
            }
            catch (InvalidExpressionException invalidExpressionException) {
                object2 = invalidExpressionException.getCause() != null ? invalidExpressionException.getCause().getMessage() : invalidExpressionException.getMessage();
                Object object3 = this.lock;
                synchronized (object3) {
                    if (this.ioManager != null) {
                        this.ioManager.println("Cannot evaluate expression '" + string5 + "' : " + (String)object2, null);
                    }
                }
            }
            string = ((Matcher)object).replaceFirst(string6);
        }
        object = jPDABreakpointEvent.getConditionException();
        if (object != null) {
            string = string + "\n***\n" + ((Throwable)object).getLocalizedMessage() + "\n***\n";
        }
        return string;
    }

    private void lookupIOManager() {
        List list = this.contextProvider.lookup(null, LazyActionsManagerListener.class);
        for (Object e : list) {
            if (!(e instanceof DebuggerOutput)) continue;
            this.ioManager = ((DebuggerOutput)e).getIOManager();
            break;
        }
    }

    private void hookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.hookBreakpoint(breakpoint);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.unhookBreakpoint(breakpoint);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)breakpoint;
            jPDABreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this);
            jPDABreakpoint.addPropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)breakpoint;
            jPDABreakpoint.removeJPDABreakpointListener((JPDABreakpointListener)this);
            jPDABreakpoint.removePropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List list = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            for (NodeModel nodeModel : list) {
                if (!(nodeModel instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nodeModel;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

