/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.CallStackNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeExpansionModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeModel;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public class DebuggingNodeModel
implements ExtendedNodeModel {
    public static final String CURRENT_THREAD = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING_THREAD = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    public static final String SUSPENDED_THREAD = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    public static final String THREAD_AT_BRKT_LINE = "org/netbeans/modules/debugger/resources/threadsView/thread_at_line_bpkt_16.png";
    public static final String THREAD_AT_BRKT_NONLINE = "org/netbeans/modules/debugger/resources/threadsView/thread_at_non_line_bpkt_16.png";
    public static final String THREAD_AT_BRKT_CONDITIONAL = "org/netbeans/modules/debugger/resources/threadsView/thread_at_conditional_bpkt_16.png";
    public static final String THREAD_SUSPENDED = "org/netbeans/modules/debugger/resources/threadsView/thread_suspended_16.png";
    public static final String THREAD_RUNNING = "org/netbeans/modules/debugger/resources/threadsView/thread_running_16.png";
    public static final String CALL_STACK2 = "org/netbeans/modules/debugger/resources/threadsView/call_stack_16.png";
    public static final String THREAD_GROUP_MIXED = "org/netbeans/modules/debugger/jpda/resources/thread_group_mixed_16.png";
    public static final String THREAD_GROUP_SUSPENDED = "org/netbeans/modules/debugger/jpda/resources/thread_group_suspended_16.png";
    public static final String THREAD_GROUP_RESUMED = "org/netbeans/modules/debugger/jpda/resources/thread_group_running_16.png";
    public static final String SHOW_PACKAGE_NAMES = "show.packageNames";
    private JPDADebugger debugger;
    private List<ModelListener> listeners = new ArrayList<ModelListener>();
    private Map<JPDAThread, ThreadStateUpdater> threadStateUpdaters = new WeakHashMap<JPDAThread, ThreadStateUpdater>();
    private CurrentThreadListener currentThreadListener;
    private DeadlockDetector deadlockDetector;
    private Set nodesInDeadlock = new HashSet();
    private static final Map<JPDADebugger, Set> nodesInDeadlockByDebugger = new WeakHashMap<JPDADebugger, Set>();
    private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
    private static final Map<JPDAThread, String> frameDescriptionsByThread = new WeakHashMap<JPDAThread, String>();
    private static RequestProcessor RPFD = new RequestProcessor("Frame Description", 1);

    public DebuggingNodeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.currentThreadListener = new CurrentThreadListener();
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.currentThreadListener, (Object)this.debugger));
        this.deadlockDetector = this.debugger.getThreadsCollector().getDeadlockDetector();
        this.deadlockDetector.addPropertyChangeListener((PropertyChangeListener)new DeadlockListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getNodesInDeadlock(JPDADebugger jPDADebugger) {
        Map<JPDADebugger, Set> map = nodesInDeadlockByDebugger;
        synchronized (map) {
            return nodesInDeadlockByDebugger.get(jPDADebugger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(Object object) throws UnknownTypeException {
        if ("Root".equals(object)) {
            return "";
        }
        boolean bl = this.preferences.getBoolean(SHOW_PACKAGE_NAMES, false);
        Color color = null;
        Set set = this.nodesInDeadlock;
        synchronized (set) {
            if (this.nodesInDeadlock.contains(object)) {
                color = Color.RED;
            }
        }
        if (object instanceof JPDAThread) {
            set = (JPDAThread)object;
            this.watch((JPDAThread)set);
            JPDAThread jPDAThread = this.debugger.getCurrentThread();
            if (!(set != jPDAThread || DebuggingTreeExpansionModelFilter.isExpanded(this.debugger, object) && set.isSuspended())) {
                return BoldVariablesTableModelFilterFirst.toHTML(DebuggingNodeModel.getDisplayName((JPDAThread)set, bl, this), true, false, color);
            }
            if (color != null) {
                return BoldVariablesTableModelFilterFirst.toHTML(DebuggingNodeModel.getDisplayName((JPDAThread)set, bl, this), false, false, color);
            }
            return DebuggingNodeModel.getDisplayName((JPDAThread)set, bl, this);
        }
        if (object instanceof JPDAThreadGroup) {
            if (this.isCurrent((JPDAThreadGroup)object) && !DebuggingTreeExpansionModelFilter.isExpanded(this.debugger, object)) {
                return BoldVariablesTableModelFilterFirst.toHTML(((JPDAThreadGroup)object).getName(), true, false, null);
            }
            return ((JPDAThreadGroup)object).getName();
        }
        if (object instanceof CallStackFrame) {
            set = (CallStackFrame)object;
            CallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
            if (((Object)set).equals(callStackFrame)) {
                return BoldVariablesTableModelFilterFirst.toHTML(CallStackNodeModel.getCSFName(null, (CallStackFrame)set, bl), true, false, color);
            }
            if (color != null) {
                return BoldVariablesTableModelFilterFirst.toHTML(CallStackNodeModel.getCSFName(null, (CallStackFrame)set, bl), false, false, color);
            }
            return CallStackNodeModel.getCSFName(null, (CallStackFrame)set, bl);
        }
        throw new UnknownTypeException((Object)object.toString());
    }

    public static String getDisplayName(JPDAThread jPDAThread, boolean bl) throws UnknownTypeException {
        return DebuggingNodeModel.getDisplayName(jPDAThread, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayName(JPDAThread jPDAThread, boolean bl, DebuggingNodeModel debuggingNodeModel) throws UnknownTypeException {
        String string;
        Object object = frameDescriptionsByThread;
        synchronized (object) {
            string = frameDescriptionsByThread.get(jPDAThread);
            if (jPDAThread.isSuspended()) {
                DebuggingNodeModel.loadFrameDescription(string, jPDAThread, bl, debuggingNodeModel);
            }
        }
        object = jPDAThread.getName();
        JPDABreakpoint jPDABreakpoint = jPDAThread.getCurrentBreakpoint();
        if (DebuggingTreeModel.isMethodInvoking(jPDAThread)) {
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_Invoking_Method", (Object)object);
        }
        if (jPDABreakpoint != null) {
            return DebuggingNodeModel.getThreadAtBreakpointDisplayName((String)object, jPDABreakpoint);
        }
        if (jPDAThread.isSuspended()) {
            if (string != null) {
                return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_State_Suspended_At", (Object)object, (Object)string);
            }
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_State_Suspended", (Object)object);
        }
        return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_State_Running", (Object)object);
    }

    private static String getThreadAtBreakpointDisplayName(String string, JPDABreakpoint jPDABreakpoint) {
        if (jPDABreakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)jPDABreakpoint;
            String string2 = null;
            try {
                FileObject fileObject = URLMapper.findFileObject((URL)new URL(lineBreakpoint.getURL()));
                if (fileObject != null) {
                    string2 = fileObject.getNameExt();
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            if (string2 == null) {
                string2 = lineBreakpoint.getURL();
            }
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_LineBreakpoint", (Object)string, (Object)string2, (Object)lineBreakpoint.getLineNumber());
        }
        if (jPDABreakpoint instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)jPDABreakpoint;
            String string3 = Arrays.asList(methodBreakpoint.getClassFilters()).toString();
            if (methodBreakpoint.getMethodSignature() == null) {
                return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_MethodBreakpoint", (Object)string, (Object)string3, (Object)methodBreakpoint.getMethodName());
            }
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_MethodBreakpointSig", (Object[])new Object[]{string, string3, methodBreakpoint.getMethodName(), methodBreakpoint.getMethodSignature()});
        }
        if (jPDABreakpoint instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)jPDABreakpoint;
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_ExceptionBreakpoint", (Object)string, (Object)exceptionBreakpoint.getExceptionClassName());
        }
        if (jPDABreakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)jPDABreakpoint;
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_FieldBreakpoint", (Object)string, (Object)fieldBreakpoint.getClassName(), (Object)fieldBreakpoint.getFieldName());
        }
        if (jPDABreakpoint instanceof ThreadBreakpoint) {
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_ThreadBreakpoint", (Object)string);
        }
        if (jPDABreakpoint instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)jPDABreakpoint;
            String string4 = Arrays.asList(classLoadUnloadBreakpoint.getClassFilters()).toString();
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_ClassBreakpoint", (Object)string, (Object)string4);
        }
        return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_Breakpoint", (Object)string, (Object)jPDABreakpoint.toString());
    }

    private static void loadFrameDescription(final String string, final JPDAThread jPDAThread, final boolean bl, final DebuggingNodeModel debuggingNodeModel) {
        RPFD.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string2 = null;
                Object object = jPDAThread;
                synchronized (object) {
                    if (jPDAThread.isSuspended() && jPDAThread.getStackDepth() > 0) {
                        try {
                            CallStackFrame[] callStackFrameArray = jPDAThread.getCallStack(0, 1);
                            if (callStackFrameArray.length > 0) {
                                string2 = CallStackNodeModel.getCSFName(null, callStackFrameArray[0], bl);
                            }
                        }
                        catch (AbsentInformationException absentInformationException) {
                            // empty catch block
                        }
                    }
                }
                if (string == null && string2 != null || string != null && !string.equals(string2)) {
                    object = frameDescriptionsByThread;
                    synchronized (object) {
                        frameDescriptionsByThread.put(jPDAThread, string2);
                    }
                    if (debuggingNodeModel != null) {
                        debuggingNodeModel.fireDisplayNameChanged(jPDAThread);
                    }
                }
            }
        });
    }

    public static String getIconBase(JPDAThread jPDAThread) {
        JPDABreakpoint jPDABreakpoint = jPDAThread.getCurrentBreakpoint();
        if (jPDABreakpoint != null) {
            if (jPDABreakpoint instanceof LineBreakpoint) {
                String string = ((LineBreakpoint)jPDABreakpoint).getCondition();
                if (string != null && string.length() > 0) {
                    return THREAD_AT_BRKT_CONDITIONAL;
                }
                return THREAD_AT_BRKT_LINE;
            }
            return THREAD_AT_BRKT_NONLINE;
        }
        if (jPDAThread.isSuspended()) {
            return THREAD_SUSPENDED;
        }
        return THREAD_RUNNING;
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
            if (callStackFrame != null && callStackFrame.equals(object)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (object instanceof JPDAThread) {
            if (object == this.debugger.getCurrentThread()) {
                return CURRENT_THREAD;
            }
            return ((JPDAThread)object).isSuspended() ? SUSPENDED_THREAD : RUNNING_THREAD;
        }
        if (object == "Root") {
            return CALL_STACK;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        if (object instanceof JPDAThread) {
            return DebuggingNodeModel.getIconBase((JPDAThread)object);
        }
        if (object instanceof CallStackFrame) {
            return CALL_STACK2;
        }
        if (object instanceof JPDAThreadGroup) {
            boolean[] blArray = new boolean[]{false, false};
            this.computeGroupStatus((JPDAThreadGroup)object, blArray);
            if (blArray[0]) {
                if (blArray[1]) {
                    return THREAD_GROUP_MIXED;
                }
                return THREAD_GROUP_SUSPENDED;
            }
            return THREAD_GROUP_RESUMED;
        }
        return this.getIconBase(object) + ".gif";
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof JPDAThread) {
            Object object2;
            JPDAThread jPDAThread = (JPDAThread)object;
            int n = jPDAThread.getState();
            String string = "";
            switch (n) {
                case -1: {
                    string = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Unknown");
                    break;
                }
                case 3: {
                    string = "";
                    object2 = jPDAThread.getContendedMonitor();
                    if (object2 == null) {
                        string = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Monitor");
                        break;
                    }
                    try {
                        string = MessageFormat.format(NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_ConcreteMonitor"), object2.getToStringValue());
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        string = invalidExpressionException.getLocalizedMessage();
                    }
                    break;
                }
                case 5: {
                    string = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_NotStarted");
                    break;
                }
                case 1: {
                    string = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Running");
                    break;
                }
                case 2: {
                    string = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Sleeping");
                    break;
                }
                case 4: {
                    object2 = jPDAThread.getContendedMonitor();
                    if (object2 == null) {
                        string = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Waiting");
                        break;
                    }
                    try {
                        string = MessageFormat.format(NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_WaitingOn"), object2.getToStringValue());
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        string = invalidExpressionException.getLocalizedMessage();
                    }
                    break;
                }
                case 0: {
                    string = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Zombie");
                }
            }
            object2 = jPDAThread.isSuspended() ? NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_ThreadsModel_Suspended_Thread_Desc") : NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_ThreadsModel_Resumed_Thread_Desc");
            if (string != null && string.length() > 0) {
                object2 = "<html>" + (String)object2 + "<br>" + NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_ThreadsModel_Thread_State_Desc", (Object)string) + "</html>";
            }
            return object2;
        }
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = (CallStackFrame)object;
            if (DebuggingTreeModel.isMethodInvoking(callStackFrame.getThread())) {
                return "";
            }
            return CallStackNodeModel.getCSFToolTipText(callStackFrame);
        }
        if (object instanceof JPDAThreadGroup) {
            return ((JPDAThreadGroup)object).getName();
        }
        if (object == "Root") {
            return "";
        }
        throw new UnknownTypeException((Object)object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(modelListener);
        }
    }

    public boolean canCopy(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canRename(Object object) throws UnknownTypeException {
        return false;
    }

    public void setName(Object object, String string) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object object) {
        ArrayList<ModelListener> arrayList;
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        nodeChanged = object instanceof JPDAThread && DebuggingTreeModel.isMethodInvoking((JPDAThread)object) ? new ModelEvent.NodeChanged((Object)this, object, 7) : new ModelEvent.NodeChanged((Object)this, object, 31);
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)nodeChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDisplayNameChanged(Object object) {
        ArrayList<ModelListener> arrayList;
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        nodeChanged = new ModelEvent.NodeChanged((Object)this, object, 1);
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)nodeChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(JPDAThread jPDAThread) {
        Map<JPDAThread, ThreadStateUpdater> map = this.threadStateUpdaters;
        synchronized (map) {
            if (!this.threadStateUpdaters.containsKey(jPDAThread)) {
                this.threadStateUpdaters.put(jPDAThread, new ThreadStateUpdater(jPDAThread));
            }
        }
    }

    private boolean isCurrent(JPDAThreadGroup jPDAThreadGroup) {
        JPDAThread jPDAThread = this.debugger.getCurrentThread();
        if (jPDAThread == null) {
            return false;
        }
        for (JPDAThreadGroup jPDAThreadGroup2 = jPDAThread.getParentThreadGroup(); jPDAThreadGroup2 != null; jPDAThreadGroup2 = jPDAThreadGroup2.getParentThreadGroup()) {
            if (jPDAThreadGroup2 != jPDAThreadGroup) continue;
            return true;
        }
        return false;
    }

    private void computeGroupStatus(JPDAThreadGroup jPDAThreadGroup, boolean[] blArray) {
        JPDAThread[] jPDAThreadArray = jPDAThreadGroup.getThreads();
        for (int i = 0; i < jPDAThreadArray.length; ++i) {
            if (jPDAThreadArray[i].isSuspended()) {
                blArray[0] = true;
            } else {
                blArray[1] = true;
            }
            if (!blArray[0] || !blArray[1]) continue;
            return;
        }
        JPDAThreadGroup[] jPDAThreadGroupArray = jPDAThreadGroup.getThreadGroups();
        for (int i = 0; i < jPDAThreadGroupArray.length; ++i) {
            this.computeGroupStatus(jPDAThreadGroupArray[i], blArray);
            if (!blArray[0] || !blArray[1]) continue;
            return;
        }
    }

    private class DeadlockListener
    implements PropertyChangeListener {
        private DeadlockListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Set set = DebuggingNodeModel.this.deadlockDetector.getDeadlocks();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (DeadlockDetector.Deadlock object : set) {
                for (JPDAThread jPDAThread : object.getThreads()) {
                    hashSet.add(jPDAThread);
                    hashSet.add(jPDAThread.getContendedMonitor());
                }
            }
            if (hashSet.isEmpty()) {
                return;
            }
            Iterator iterator = DebuggingNodeModel.this.nodesInDeadlock;
            synchronized (iterator) {
                DebuggingNodeModel.this.nodesInDeadlock.addAll(hashSet);
            }
            iterator = nodesInDeadlockByDebugger;
            synchronized (iterator) {
                nodesInDeadlockByDebugger.put(DebuggingNodeModel.this.debugger, DebuggingNodeModel.this.nodesInDeadlock);
            }
            for (Object e : hashSet) {
                DebuggingNodeModel.this.fireDisplayNameChanged(e);
                DebuggingTreeExpansionModelFilter.expand(DebuggingNodeModel.this.debugger, e);
            }
        }
    }

    private class CurrentThreadListener
    implements PropertyChangeListener {
        private Reference<JPDAThread> lastCurrentThreadRef = new WeakReference<Object>(null);
        private Reference<JPDAThread> lastCurrentFrameThreadRef = new WeakReference<Object>(null);
        private int lastCurrentFrameDepth;

        private CurrentThreadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JPDAThread jPDAThread;
            CurrentThreadListener currentThreadListener;
            JPDAThread jPDAThread2;
            if ("currentThread".equals(propertyChangeEvent.getPropertyName())) {
                jPDAThread2 = DebuggingNodeModel.this.debugger.getCurrentThread();
                currentThreadListener = this;
                synchronized (currentThreadListener) {
                    jPDAThread = this.lastCurrentThreadRef.get();
                    this.lastCurrentThreadRef = new WeakReference<JPDAThread>(jPDAThread2);
                }
                if (jPDAThread != null) {
                    DebuggingNodeModel.this.fireNodeChanged(jPDAThread);
                }
                if (jPDAThread2 != null) {
                    DebuggingNodeModel.this.fireNodeChanged(jPDAThread2);
                }
                if (DebuggingNodeModel.this.preferences.getBoolean("show.suspendedThreadsOnly", false)) {
                    DebuggingNodeModel.this.fireNodeChanged("Root");
                }
            }
            if ("currentCallStackFrame".equals(propertyChangeEvent.getPropertyName())) {
                jPDAThread2 = DebuggingNodeModel.this.debugger.getCurrentCallStackFrame();
                jPDAThread = null;
                currentThreadListener = this;
                synchronized (currentThreadListener) {
                    JPDAThread jPDAThread3 = this.lastCurrentFrameThreadRef.get();
                    if (jPDAThread3 != null) {
                        try {
                            CallStackFrame[] callStackFrameArray = jPDAThread3.getCallStack(this.lastCurrentFrameDepth, this.lastCurrentFrameDepth + 1);
                            if (callStackFrameArray.length > 0) {
                                jPDAThread = callStackFrameArray[0];
                            }
                        }
                        catch (AbsentInformationException absentInformationException) {
                            // empty catch block
                        }
                    }
                    if (jPDAThread2 != null) {
                        this.lastCurrentFrameThreadRef = new WeakReference<JPDAThread>(jPDAThread2.getThread());
                        this.lastCurrentFrameDepth = jPDAThread2.getFrameDepth();
                    } else {
                        this.lastCurrentFrameThreadRef = new WeakReference<Object>(null);
                        this.lastCurrentFrameDepth = 0;
                    }
                }
                if (jPDAThread != null) {
                    DebuggingNodeModel.this.fireNodeChanged(jPDAThread);
                }
                if (jPDAThread2 != null) {
                    DebuggingNodeModel.this.fireNodeChanged(jPDAThread2);
                }
            }
        }
    }

    private class ThreadStateUpdater
    implements PropertyChangeListener {
        private Reference<JPDAThread> tr;
        private RequestProcessor.Task task;
        private boolean shouldExpand = false;

        public ThreadStateUpdater(JPDAThread jPDAThread) {
            this.tr = new WeakReference<JPDAThread>(jPDAThread);
            ((Customizer)jPDAThread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jPDAThread));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JPDAThread jPDAThread = this.tr.get();
            if (jPDAThread != null) {
                ThreadStateUpdater threadStateUpdater;
                if ("currentBreakpoint".equals(propertyChangeEvent.getPropertyName()) && jPDAThread.isSuspended() && jPDAThread.getCurrentBreakpoint() != null) {
                    threadStateUpdater = this;
                    synchronized (threadStateUpdater) {
                        this.shouldExpand = true;
                    }
                }
                threadStateUpdater = this;
                synchronized (threadStateUpdater) {
                    if (this.task == null) {
                        this.task = new RequestProcessor("Debugger Threads Refresh").create((Runnable)new Refresher());
                    }
                    this.task.schedule(100);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JPDAThread jPDAThread = (JPDAThread)ThreadStateUpdater.this.tr.get();
                if (jPDAThread != null) {
                    boolean bl;
                    if (DebuggingNodeModel.this.preferences.getBoolean("show.suspendedThreadsOnly", false)) {
                        DebuggingNodeModel.this.fireNodeChanged("Root");
                    } else {
                        DebuggingNodeModel.this.fireNodeChanged(jPDAThread);
                    }
                    Refresher refresher = this;
                    synchronized (refresher) {
                        bl = ThreadStateUpdater.this.shouldExpand;
                        ThreadStateUpdater.this.shouldExpand = false;
                    }
                    if (bl) {
                        DebuggingTreeExpansionModelFilter.expand(DebuggingNodeModel.this.debugger, jPDAThread);
                    }
                    if (DebuggingNodeModel.this.preferences.getBoolean("show.threadGroups", false)) {
                        for (refresher = jPDAThread.getParentThreadGroup(); refresher != null; refresher = refresher.getParentThreadGroup()) {
                            DebuggingNodeModel.this.fireNodeChanged(refresher);
                        }
                    }
                }
            }
        }
    }
}

