/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.ReturnVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class VariablesNodeModel
implements ExtendedNodeModel {
    public static final String FIELD = "org/netbeans/modules/debugger/resources/watchesView/Field.gif";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch.gif";
    public static final String STATIC_FIELD = "org/netbeans/modules/debugger/resources/watchesView/StaticField.gif";
    public static final String SUPER = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
    public static final String STATIC = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
    public static final String RETURN = "org/netbeans/modules/debugger/jpda/resources/Filter.gif";
    public static final String EXPR_ARGUMENTS = "org/netbeans/modules/debugger/jpda/resources/ExprArguments.gif";
    private static final int TO_STRING_LENGTH_LIMIT = 10000;
    private JPDADebugger debugger;
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection modelListeners = new HashSet();
    private Map shortDescriptionMap = new HashMap();

    public VariablesNodeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Name");
        }
        if (object instanceof Field) {
            return ((Field)object).getName();
        }
        if (object instanceof LocalVariable) {
            return ((LocalVariable)object).getName();
        }
        if (object instanceof Super) {
            return "super";
        }
        if (object instanceof This) {
            return "this";
        }
        if (object == "NoInfo") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info");
        }
        if (object == "No current thread") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        if (object instanceof JPDAClassType) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_StaticNode");
        }
        if (object instanceof ClassVariable) {
            return "class";
        }
        if (object instanceof ReturnVariable) {
            return "return " + ((ReturnVariable)object).methodName() + "()";
        }
        if (object instanceof EditorContext.Operation) {
            boolean bl;
            List list;
            EditorContext.Operation operation = (EditorContext.Operation)object;
            EditorContext.Operation operation2 = null;
            JPDAThread jPDAThread = this.debugger.getCurrentThread();
            if (jPDAThread != null && (list = jPDAThread.getLastOperations()) != null && list.size() > 0) {
                operation2 = (EditorContext.Operation)list.get(list.size() - 1);
            }
            boolean bl2 = bl = operation == operation2;
            if (bl) {
                return NbBundle.getMessage(VariablesNodeModel.class, (String)"afterOperation", (Object)operation.getMethodName());
            }
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"beforeOperation", (Object)operation.getMethodName());
        }
        if (object == "lastOperations") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"lastOperationsNode");
        }
        if (object instanceof String && ((String)object).startsWith("operationArguments ")) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"operationArgumentsNode", (Object)((String)object).substring("operationArguments ".length()));
        }
        if (object == "NativeMethodException") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NativeMethod");
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            int n = string.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_SubArray", (Object)string.substring(8, n), (Object)string.substring(n + 1));
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Desc");
        }
        if (object == "NoInfo") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info_descr");
        }
        if (object == "No current thread") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        if (object instanceof JPDAClassType) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_StaticNode_descr");
        }
        if (object instanceof ClassVariable) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_Class_descr");
        }
        if (object instanceof ReturnVariable) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_VariablesFilter_Return_descr", (Object)(((ReturnVariable)object).methodName() + "()"));
        }
        if (object instanceof EditorContext.Operation) {
            boolean bl;
            EditorContext.Operation operation = (EditorContext.Operation)object;
            boolean bl2 = bl = operation.getReturnValue() != null;
            if (bl) {
                return NbBundle.getMessage(VariablesNodeModel.class, (String)"afterOperation_descr", (Object)operation.getMethodName());
            }
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"beforeOperation_descr", (Object)operation.getMethodName());
        }
        if (object == "lastOperations") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"MSG_LastOperations_descr");
        }
        if (object instanceof String && ((String)object).startsWith("operationArguments ")) {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"operationArgumentsNode_descr", (Object)((String)object).substring("operationArguments ".length()));
        }
        if (object == "NativeMethodException") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NativeMethod_descr");
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            int n = string.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Descr_SubArray", (Object)string.substring(8, n), (Object)string.substring(n + 1));
        }
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object v = this.shortDescriptionMap.remove(object);
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)v);
            }
        }
        this.testKnown(object);
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = VariablesNodeModel.this.getShortDescriptionSynch(object);
                if (string != null && !"".equals(string)) {
                    Map map = VariablesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        VariablesNodeModel.this.shortDescriptionMap.put(object, string);
                    }
                    VariablesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesNodeModel.this, object, 4));
                }
            }
        });
        return "";
    }

    protected String getShortDescriptionSynch(Object object) {
        if (object instanceof Field) {
            if (object instanceof ObjectVariable) {
                String string;
                String string2 = ((ObjectVariable)object).getType();
                if (string2.equals(string = ((Field)object).getDeclaredType())) {
                    try {
                        return "(" + string2 + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)object);
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        return invalidExpressionException.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + string + ") " + "(" + string2 + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)object);
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    return invalidExpressionException.getLocalizedMessage();
                }
            }
            return "(" + ((Field)object).getDeclaredType() + ") " + ((Field)object).getValue();
        }
        if (object instanceof LocalVariable) {
            if (object instanceof ObjectVariable) {
                String string;
                String string3 = ((ObjectVariable)object).getType();
                if (string3.equals(string = ((LocalVariable)object).getDeclaredType())) {
                    try {
                        return "(" + string3 + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)object);
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        return invalidExpressionException.getLocalizedMessage();
                    }
                }
                try {
                    return "(" + string + ") " + "(" + string3 + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)object);
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    return invalidExpressionException.getLocalizedMessage();
                }
            }
            return "(" + ((LocalVariable)object).getDeclaredType() + ") " + ((LocalVariable)object).getValue();
        }
        if (object instanceof Super) {
            return ((Super)object).getType();
        }
        if (object instanceof This) {
            try {
                return "(" + ((This)object).getType() + ") " + VariablesNodeModel.getLimitedToString((ObjectVariable)((This)object));
            }
            catch (InvalidExpressionException invalidExpressionException) {
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        return null;
    }

    private static String getLimitedToString(ObjectVariable objectVariable) throws InvalidExpressionException {
        String string = null;
        try {
            Method method = objectVariable.getClass().getMethod("getToStringValue", Integer.TYPE);
            method.setAccessible(true);
            string = (String)method.invoke((Object)objectVariable, 10000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            string = objectVariable.getToStringValue();
        }
        return string;
    }

    protected void testKnown(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof Field) {
            return;
        }
        if (object instanceof LocalVariable) {
            return;
        }
        if (object instanceof Super) {
            return;
        }
        if (object instanceof This) {
            return;
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            return;
        }
        if (object == "NoInfo") {
            return;
        }
        if (object == "No current thread") {
            return;
        }
        if (object == "lastOperations") {
            return;
        }
        if (object instanceof String && ((String)object).startsWith("operationArguments ")) {
            return;
        }
        if (object == "NativeMethodException") {
            return;
        }
        if (object instanceof JPDAClassType) {
            return;
        }
        if (object instanceof ClassVariable) {
            return;
        }
        if (object instanceof ReturnVariable) {
            return;
        }
        if (object instanceof EditorContext.Operation) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean canRename(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object object) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
        return null;
    }

    public void setName(Object object, String string) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return FIELD;
        }
        if (object instanceof Field) {
            if (((Field)object).isStatic()) {
                return STATIC_FIELD;
            }
            return FIELD;
        }
        if (object instanceof LocalVariable) {
            return LOCAL;
        }
        if (object instanceof Super) {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
        }
        if (object instanceof This) {
            return FIELD;
        }
        if (object instanceof JPDAClassType) {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
        }
        if (object instanceof ClassVariable) {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
        }
        if (object instanceof EditorContext.Operation) {
            return EXPR_ARGUMENTS;
        }
        if (object instanceof ReturnVariable || object == "lastOperations") {
            return RETURN;
        }
        if (object instanceof String && ((String)object).startsWith("operationArguments ")) {
            return EXPR_ARGUMENTS;
        }
        if (object.toString().startsWith("SubArray")) {
            return LOCAL;
        }
        if (object == "NoInfo" || object == "No current thread" || object == "NativeMethodException") {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChange(ModelEvent modelEvent) {
        Object[] objectArray;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            objectArray = this.modelListeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged(modelEvent);
        }
    }
}

