/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Refreshable;
import javax.swing.JToolTip;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class VariablesTableModel
implements TableModel,
Constants {
    private JPDADebugger debugger;
    private Set<ModelListener> listeners = new HashSet<ModelListener>();

    public VariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if ("LocalsToString".equals(string) || "WatchToString".equals(string)) {
            if (object instanceof Super) {
                return "";
            }
            if (object instanceof ObjectVariable) {
                try {
                    String string2 = ((ObjectVariable)object).getToStringValue();
                    return string2;
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    String string3 = VariablesTableModel.getMessage(invalidExpressionException);
                    return string3;
                }
                finally {
                    this.fireChildrenChange(object);
                }
            }
            if (object instanceof Variable) {
                try {
                    String string4 = ((Variable)object).getValue();
                    return string4;
                }
                finally {
                    this.fireChildrenChange(object);
                }
            }
            if (object instanceof EditorContext.Operation || object == "lastOperations" || object instanceof String && ((String)object).startsWith("operationArguments ")) {
                return "";
            }
        } else if ("LocalsType".equals(string) || "WatchType".equals(string)) {
            if (object instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)object).getType());
            }
            if (object instanceof JToolTip && (object = ((JToolTip)object).getClientProperty("getShortDescription")) instanceof Variable) {
                if (object instanceof Refreshable && !((Refreshable)object).isCurrent()) {
                    return "";
                }
                return ((Variable)object).getType();
            }
        } else if ("LocalsValue".equals(string) || "WatchValue".equals(string)) {
            if (object instanceof JPDAWatch) {
                JPDAWatch jPDAWatch = (JPDAWatch)object;
                String string5 = jPDAWatch.getExceptionDescription();
                if (string5 != null) {
                    return ">" + string5 + "<";
                }
                try {
                    String string6 = jPDAWatch.getValue();
                    return string6;
                }
                finally {
                    this.fireChildrenChange(object);
                }
            }
            if (object instanceof Variable) {
                try {
                    String string7 = ((Variable)object).getValue();
                    return string7;
                }
                finally {
                    this.fireChildrenChange(object);
                }
            }
        }
        if (object instanceof JPDAClassType) {
            return "";
        }
        if (object.toString().startsWith("SubArray")) {
            return "";
        }
        if (object instanceof EditorContext.Operation || object == "lastOperations" || object instanceof String && ((String)object).startsWith("operationArguments ")) {
            return "";
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof Variable) {
            if ("LocalsToString".equals(string) || "WatchToString".equals(string) || "LocalsType".equals(string) || "WatchType".equals(string)) {
                return true;
            }
            if ("LocalsValue".equals(string) || "WatchValue".equals(string)) {
                if (object instanceof This) {
                    return true;
                }
                if (object instanceof LocalVariable || object instanceof Field || object instanceof JPDAWatch) {
                    if (WatchesNodeModel.isEmptyWatch(object)) {
                        return true;
                    }
                    return !this.debugger.canBeModified();
                }
                return true;
            }
        }
        if (object instanceof JPDAClassType) {
            return true;
        }
        if (object.toString().startsWith("SubArray")) {
            return true;
        }
        if (object instanceof EditorContext.Operation) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof LocalVariable && "LocalsValue".equals(string)) {
            try {
                ((LocalVariable)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (object instanceof Field && ("LocalsValue".equals(string) || "WatchValue".equals(string))) {
            try {
                ((Field)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (object instanceof JPDAWatch && ("LocalsValue".equals(string) || "WatchValue".equals(string))) {
            try {
                ((JPDAWatch)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChildrenChange(Object object) {
        HashSet<ModelListener> hashSet;
        Set<ModelListener> set = this.listeners;
        synchronized (set) {
            hashSet = new HashSet<ModelListener>(this.listeners);
        }
        for (ModelListener modelListener : hashSet) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, object, 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Set<ModelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Set<ModelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(modelListener);
        }
    }

    static String getShort(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String getMessage(InvalidExpressionException invalidExpressionException) {
        Throwable throwable;
        String string = invalidExpressionException.getLocalizedMessage();
        if (string == null) {
            string = invalidExpressionException.getMessage();
        }
        if (string == null) {
            string = NbBundle.getMessage(VariablesTableModel.class, (String)"MSG_NA");
        }
        if ((throwable = invalidExpressionException.getTargetException()) != null && throwable instanceof ApplicationException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            string = string + " \n" + stringWriter.toString();
        }
        return ">" + string + "<";
    }
}

