/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsNode
extends ContainerNode {
    private final ClasspathInfo cpInfo;

    public MethodsNode(ClasspathInfo classpathInfo, ClassNode classNode) {
        super(NbBundle.getMessage(MethodsNode.class, (String)"Methods_DisplayName"), IconResource.METHODS_ICON, classNode);
        this.cpInfo = classpathInfo;
    }

    public ElementHandle<TypeElement> getClassHandle() {
        return ((ClassNode)this.getParent()).getClassHandle();
    }

    @Override
    protected SelectorChildren getChildren() {
        return new Children();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Children
    extends GreedySelectorChildren<MethodsNode> {
        private Children() {
        }

        @Override
        protected List<? extends SelectorNode> prepareChildren(final MethodsNode methodsNode) {
            final ArrayList arrayList = new ArrayList();
            try {
                ClasspathInfo classpathInfo = methodsNode.cpInfo;
                if (methodsNode.isShowingInheritedMethods()) {
                    classpathInfo = ProjectUtilities.getClasspathInfo((Project)methodsNode.getProject(), (boolean)true, (boolean)true, (boolean)true);
                }
                JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = SourceUtils.resolveClassByName((String)methodsNode.getClassHandle().getBinaryName(), (CompilationController)compilationController);
                        List<ExecutableElement> list = ElementFilter.methodsIn(methodsNode.isShowingInheritedMethods() ? compilationController.getElements().getAllMembers(typeElement) : typeElement.getEnclosedElements());
                        for (ExecutableElement executableElement : list) {
                            MethodNode methodNode = new MethodNode(methodsNode.cpInfo, executableElement, methodsNode);
                            if (methodNode.getSignature() == null) continue;
                            arrayList.add(methodNode);
                        }
                    }
                }, true);
                Collections.sort(arrayList, MethodNode.COMPARATOR);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return arrayList;
        }
    }
}

