/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmModelStateListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.ClassViewTopComponent;
import org.openide.util.NbPreferences;

public class ClassViewInstaller
implements CsmModelStateListener {
    public void modelStateChanged(CsmModelState csmModelState, CsmModelState csmModelState2) {
        switch (csmModelState) {
            case ON: {
                ProjectListener.getInstance().startup();
                break;
            }
            case CLOSING: {
                ProjectListener.getInstance().shutdown();
            }
        }
    }

    private static class ProjectListener
    implements CsmModelListener {
        private static ProjectListener instance;

        private ProjectListener() {
        }

        private static ProjectListener getInstance() {
            if (instance == null) {
                instance = new ProjectListener();
            }
            return instance;
        }

        private void shutdown() {
            CsmListeners.getDefault().removeModelListener((CsmModelListener)this);
        }

        private void startup() {
            CsmListeners.getDefault().addModelListener((CsmModelListener)this);
        }

        private boolean isDefaultBehavior() {
            Preferences preferences = NbPreferences.forModule(ClassViewTopComponent.class);
            return !preferences.getBoolean("ClassViewWasOpened", false);
        }

        public void projectOpened(CsmProject csmProject) {
            if (this.isDefaultBehavior()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ClassViewTopComponent classViewTopComponent = ClassViewTopComponent.findDefault();
                        if (!classViewTopComponent.isOpened()) {
                            classViewTopComponent.open();
                        }
                    }
                });
            }
        }

        public void projectClosed(CsmProject csmProject) {
            if (this.isDefaultBehavior() && CsmModelAccessor.getModel().projects().isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ClassViewTopComponent classViewTopComponent = ClassViewTopComponent.findDefault();
                        if (classViewTopComponent.isOpened()) {
                            classViewTopComponent.closeImplicit();
                        }
                    }
                });
            }
        }

        public void modelChanged(CsmChangeEvent csmChangeEvent) {
        }
    }
}

