/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.LinkedList;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.classview.ClassViewModel;
import org.netbeans.modules.cnd.classview.SmartChangeEvent;

public class ClassViewUpdater
extends Thread {
    private static final boolean traceEvents = Boolean.getBoolean("cnd.classview.updater-events");
    private ClassViewModel model;
    private BlockingQueue queue;
    private volatile boolean isStoped = false;
    private static final int MINIMAL_DELAY = 500;
    private static final int BATCH_MODE_DELAY = 1000;
    private static final int MAXIMAL_BATCH_SIZE = 50;
    private static final int MAXIMAL_BATCH_TIME = 10;
    private static final int USER_ACTIVITY_DELAY = 1000;

    ClassViewUpdater(ClassViewModel classViewModel) {
        super("Class View Updater");
        this.model = classViewModel;
        this.queue = new BlockingQueue();
    }

    public void setStop() {
        this.isStoped = true;
        if (this.queue != null) {
            this.queue.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = 0L;
        try {
            block10: while (true) {
                if (this.isStoped) {
                    return;
                }
                var3_2 = this.queue.get();
                if (this.isStoped) {
                    return;
                }
                if (this.queue.isEmpty()) {
                    Thread.sleep(500L);
                }
                var4_4 = 0;
                while (true) {
                    if (this.isStoped) {
                        return;
                    }
                    while (!this.queue.isEmpty()) {
                        if (this.isStoped) {
                            return;
                        }
                        var5_5 = this.queue.peek();
                        if (!var3_2.addChangeEvent(var5_5)) break;
                        this.queue.get();
                        if (!this.queue.isEmpty() || var3_2.getCount() >= 50 || var4_4 >= 10) continue;
                        ++var4_4;
                        Thread.sleep(1000L);
                    }
                    if (!this.model.isUserActivity()) break;
                    Thread.sleep(1000L);
                }
                if (ClassViewUpdater.traceEvents) {
                    var1_1 = System.nanoTime();
                }
                if (this.isStoped) {
                    return;
                }
                this.model.update(var3_2);
                if (!ClassViewUpdater.traceEvents) continue;
                var5_6 = System.nanoTime();
                var7_7 = (var5_6 - var1_1) / 1000000L;
                System.out.println("Compose change event contains " + var3_2.getCount() + " events. Time = " + (double)var7_7 / 1000.0);
                var9_8 = var3_2.getChangedProjects().entrySet().iterator();
                while (true) {
                    if (var9_8.hasNext()) ** break;
                    continue block10;
                    var10_9 = var9_8.next();
                    System.out.println("    Project " + var10_9.getKey().getName() + " Nd=" + var10_9.getValue().getNewDeclarations().size() + ", Rd=" + var10_9.getValue().getRemovedDeclarations().size() + ", Ud=" + var10_9.getValue().getChangedDeclarations().size() + ", Nn=" + var10_9.getValue().getNewNamespaces().size() + ", Rn=" + var10_9.getValue().getRemovedNamespaces().size());
                }
                break;
            }
            catch (InterruptedException var3_3) {
                return;
            }
        }
        finally {
            this.model = null;
            this.queue = null;
        }
    }

    public void scheduleUpdate(CsmChangeEvent csmChangeEvent) {
        if (this.queue != null) {
            this.queue.add(new SmartChangeEvent(csmChangeEvent));
        }
    }

    private static class BlockingQueue {
        private LinkedList<SmartChangeEvent> data = new LinkedList();
        private Object lock = new Object();

        private BlockingQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SmartChangeEvent get() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (this.data.isEmpty()) {
                    this.lock.wait();
                }
                return this.data.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(SmartChangeEvent smartChangeEvent) {
            Object object = this.lock;
            synchronized (object) {
                this.data.add(smartChangeEvent);
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SmartChangeEvent peek() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (this.data.isEmpty()) {
                    this.lock.wait();
                }
                return this.data.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                return this.data.isEmpty();
            }
        }
    }
}

